/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.languagemodel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.languagetool.languagemodel.LanguageModel;

public class LuceneLanguageModel
implements LanguageModel {
    private final List<File> indexes = new ArrayList<File>();
    private final Map<Integer, LuceneSearcher> luceneSearcherMap = new HashMap<Integer, LuceneSearcher>();
    private final File topIndexDir;

    public LuceneLanguageModel(File topIndexDir) throws IOException {
        if (!topIndexDir.exists() || !topIndexDir.isDirectory()) {
            throw new RuntimeException("Not found or is not a directory: " + topIndexDir);
        }
        this.topIndexDir = topIndexDir;
        this.addIndex(topIndexDir, 2);
        this.addIndex(topIndexDir, 3);
        if (this.luceneSearcherMap.size() == 0) {
            throw new RuntimeException("No directories '2grams' and/or '3grams' found in " + topIndexDir);
        }
    }

    private void addIndex(File topIndexDir, int ngramSize) throws IOException {
        File indexDir = new File(topIndexDir, ngramSize + "grams");
        if (indexDir.exists() && indexDir.isDirectory()) {
            this.luceneSearcherMap.put(ngramSize, new LuceneSearcher(indexDir));
            this.indexes.add(indexDir);
        }
    }

    @Override
    public long getCount(String token1, String token2) {
        Objects.requireNonNull(token1);
        Objects.requireNonNull(token2);
        Term term = new Term("ngram", token1 + " " + token2);
        LuceneSearcher luceneSearcher = this.getLuceneSearcher(2);
        return this.getCount(term, luceneSearcher);
    }

    @Override
    public long getCount(String token1, String token2, String token3) {
        Objects.requireNonNull(token1);
        Objects.requireNonNull(token2);
        Objects.requireNonNull(token3);
        Term term = new Term("ngram", token1 + " " + token2 + " " + token3);
        LuceneSearcher luceneSearcher = this.getLuceneSearcher(3);
        long count = this.getCount(term, luceneSearcher);
        return count;
    }

    protected LuceneSearcher getLuceneSearcher(int ngramSize) {
        LuceneSearcher luceneSearcher = this.luceneSearcherMap.get(ngramSize);
        if (luceneSearcher == null) {
            throw new RuntimeException("No " + ngramSize + "grams directory found in " + this.topIndexDir);
        }
        return luceneSearcher;
    }

    private long getCount(Term term, LuceneSearcher luceneSearcher) {
        try {
            TopDocs docs = luceneSearcher.searcher.search((Query)new TermQuery(term), 1);
            if (docs.totalHits > 0) {
                int docId = docs.scoreDocs[0].doc;
                return Long.parseLong(luceneSearcher.reader.document(docId).get("count"));
            }
            return 0L;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        for (LuceneSearcher searcher : this.luceneSearcherMap.values()) {
            try {
                searcher.reader.close();
                searcher.directory.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        return this.indexes.toString();
    }

    protected static class LuceneSearcher {
        final FSDirectory directory;
        final IndexReader reader;
        final IndexSearcher searcher;

        private LuceneSearcher(File indexDir) throws IOException {
            this.directory = FSDirectory.open((File)indexDir);
            this.reader = DirectoryReader.open((Directory)this.directory);
            this.searcher = new IndexSearcher(this.reader);
        }

        public IndexReader getReader() {
            return this.reader;
        }
    }
}

