/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.languagetool.Language;

public final class Languages {
    private static final List<Language> LANGUAGES = Languages.getAllLanguages();

    private Languages() {
    }

    public static List<Language> get() {
        ArrayList<Language> result = new ArrayList<Language>();
        for (Language lang : LANGUAGES) {
            if ("xx".equals(lang.getShortName())) continue;
            result.add(lang);
        }
        return Collections.unmodifiableList(result);
    }

    public static List<Language> getWithDemoLanguage() {
        return LANGUAGES;
    }

    private static List<Language> getAllLanguages() {
        return Collections.unmodifiableList(Arrays.asList(Language.LANGUAGES));
    }

    public static Language getLanguageForName(String languageName) {
        return Language.getLanguageForName(languageName);
    }

    public static Language getLanguageForShortName(String langCode) {
        return Language.getLanguageForShortName(langCode);
    }

    public static boolean isLanguageSupported(String langCode) {
        return Language.isLanguageSupported(langCode);
    }

    public static Language getLanguageForLocale(Locale locale) {
        return Language.getLanguageForLocale(locale);
    }
}

