/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Experimental;
import org.languagetool.JLanguageTool;
import org.languagetool.chunking.Chunker;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.rules.patterns.Unifier;
import org.languagetool.rules.patterns.UnifierConfiguration;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.xx.DemoDisambiguator;
import org.languagetool.tagging.xx.DemoTagger;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.SimpleSentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tools.MultiKeyProperties;
import org.languagetool.tools.StringTools;

public abstract class Language {
    private static final String PROPERTIES_PATH = "META-INF/org/languagetool/language-module.properties";
    private static final String PROPERTIES_KEY = "languageClasses";
    private static List<Language> externalLanguages = new ArrayList<Language>();
    private final List<String> externalRuleFiles = new ArrayList<String>();
    private boolean isExternalLanguage = false;
    private Pattern ignoredCharactersRegex = Pattern.compile("[\u00ad]");
    private List<PatternRule> patternRules;
    public static Language[] LANGUAGES = Language.getLanguages();
    public static final Language[] REAL_LANGUAGES = Language.getRealLanguages();
    private static final Language[] BUILTIN_LANGUAGES = LANGUAGES;
    private static final Disambiguator DEMO_DISAMBIGUATOR = new DemoDisambiguator();
    private static final Tagger DEMO_TAGGER = new DemoTagger();
    private static final SentenceTokenizer SENTENCE_TOKENIZER = new SimpleSentenceTokenizer();
    private static final WordTokenizer WORD_TOKENIZER = new WordTokenizer();
    private final UnifierConfiguration unifierConfiguration = new UnifierConfiguration();
    private final UnifierConfiguration disambiguationUnifierConfiguration = new UnifierConfiguration();

    private static Language[] getLanguages() {
        ArrayList<Language> languages = new ArrayList<Language>();
        HashSet<String> languageClassNames = new HashSet<String>();
        try {
            Enumeration<URL> propertyFiles = Language.class.getClassLoader().getResources(PROPERTIES_PATH);
            while (propertyFiles.hasMoreElements()) {
                URL url = propertyFiles.nextElement();
                InputStream inputStream = url.openStream();
                Throwable throwable = null;
                try {
                    MultiKeyProperties props = new MultiKeyProperties(inputStream);
                    List<String> classNamesStr = props.getProperty(PROPERTIES_KEY);
                    if (classNamesStr == null) {
                        throw new RuntimeException("Key 'languageClasses' not found in " + url);
                    }
                    for (String classNames : classNamesStr) {
                        String[] classNamesSplit;
                        for (String className : classNamesSplit = classNames.split("\\s*,\\s*")) {
                            if (languageClassNames.contains(className)) continue;
                            languages.add(Language.createLanguageObjects(url, className));
                            languageClassNames.add(className);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return languages.toArray(new Language[languages.size()]);
    }

    private static Language createLanguageObjects(URL url, String className) {
        try {
            Class<?> aClass = Class.forName(className);
            Constructor<?> constructor = aClass.getConstructor(new Class[0]);
            return (Language)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class '" + className + "' specified in " + url + " could not be found in classpath", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Object for class '" + className + "' specified in " + url + " could not created", e);
        }
    }

    public static Language[] getRealLanguages() {
        ArrayList<Language> result = new ArrayList<Language>();
        for (Language lang : LANGUAGES) {
            if ("xx".equals(lang.getShortName())) continue;
            result.add(lang);
        }
        return result.toArray(new Language[result.size()]);
    }

    public abstract String getShortName();

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract String[] getCountries();

    @Nullable
    public String getVariant() {
        return null;
    }

    public List<String> getDefaultEnabledRulesForVariant() {
        return new ArrayList<String>();
    }

    public List<String> getDefaultDisabledRulesForVariant() {
        return new ArrayList<String>();
    }

    @Nullable
    public abstract Contributor[] getMaintainers();

    public abstract List<Rule> getRelevantRules(ResourceBundle var1) throws IOException;

    @Nullable
    public LanguageModel getLanguageModel(File indexDir) throws IOException {
        return null;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel) throws IOException {
        return Collections.emptyList();
    }

    public Locale getLocale() {
        return new Locale(this.getShortName());
    }

    public Locale getLocaleWithCountryAndVariant() {
        if (this.getCountries().length > 0) {
            if (this.getVariant() != null) {
                return new Locale(this.getShortName(), this.getCountries()[0], this.getVariant());
            }
            return new Locale(this.getShortName(), this.getCountries()[0]);
        }
        return this.getLocale();
    }

    public List<String> getRuleFileNames() {
        String fileName;
        ArrayList<String> ruleFiles = new ArrayList<String>();
        ruleFiles.addAll(this.getExternalRuleFiles());
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        ruleFiles.add(dataBroker.getRulesDir() + "/" + this.getShortName() + "/" + "grammar.xml");
        if (this.getShortNameWithCountryAndVariant().length() > 2 && dataBroker.ruleFileExists(fileName = this.getShortName() + "/" + this.getShortNameWithCountryAndVariant() + "/" + "grammar.xml")) {
            ruleFiles.add(dataBroker.getRulesDir() + "/" + fileName);
        }
        return ruleFiles;
    }

    public List<String> getExternalRuleFiles() {
        return this.externalRuleFiles;
    }

    public void addExternalRuleFile(String externalRuleFile) {
        this.externalRuleFiles.add(externalRuleFile);
    }

    @Nullable
    public Language getDefaultLanguageVariant() {
        return null;
    }

    public Disambiguator getDisambiguator() {
        return DEMO_DISAMBIGUATOR;
    }

    public Tagger getTagger() {
        return DEMO_TAGGER;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        return SENTENCE_TOKENIZER;
    }

    public Tokenizer getWordTokenizer() {
        return WORD_TOKENIZER;
    }

    @Nullable
    public Chunker getChunker() {
        return null;
    }

    @Nullable
    public Chunker getPostDisambiguationChunker() {
        return null;
    }

    @Nullable
    public Synthesizer getSynthesizer() {
        return null;
    }

    public Unifier getUnifier() {
        return this.unifierConfiguration.createUnifier();
    }

    public Unifier getDisambiguationUnifier() {
        return this.disambiguationUnifierConfiguration.createUnifier();
    }

    public UnifierConfiguration getUnifierConfiguration() {
        return this.unifierConfiguration;
    }

    public UnifierConfiguration getDisambiguationUnifierConfiguration() {
        return this.disambiguationUnifierConfiguration;
    }

    public final String getTranslatedName(ResourceBundle messages) {
        try {
            return messages.getString(this.getShortNameWithCountryAndVariant());
        }
        catch (MissingResourceException e) {
            try {
                return messages.getString(this.getShortName());
            }
            catch (MissingResourceException e1) {
                return this.getName();
            }
        }
    }

    public final String getShortNameWithCountryAndVariant() {
        String name = this.getShortName();
        if (this.getCountries().length == 1 && !name.contains("-x-")) {
            name = name + "-" + this.getCountries()[0];
            if (this.getVariant() != null) {
                name = name + "-" + this.getVariant();
            }
        }
        return name;
    }

    @Experimental
    protected synchronized List<PatternRule> getPatternRules() throws IOException {
        if (this.patternRules == null) {
            this.patternRules = new ArrayList<PatternRule>();
            PatternRuleLoader ruleLoader = new PatternRuleLoader();
            for (String fileName : this.getRuleFileNames()) {
                InputStream is = this.getClass().getResourceAsStream(fileName);
                if (is == null) {
                    is = new FileInputStream(fileName);
                }
                this.patternRules.addAll(ruleLoader.getRules(is, fileName));
            }
        }
        return this.patternRules;
    }

    public static void reInit(List<Language> languages) {
        LANGUAGES = new Language[BUILTIN_LANGUAGES.length + languages.size()];
        int i = BUILTIN_LANGUAGES.length;
        System.arraycopy(BUILTIN_LANGUAGES, 0, LANGUAGES, 0, BUILTIN_LANGUAGES.length);
        for (Language lang : languages) {
            Language.LANGUAGES[i++] = lang;
        }
        externalLanguages = languages;
    }

    public static List<Language> getExternalLanguages() {
        return externalLanguages;
    }

    public static List<Language> getAllLanguages() {
        ArrayList<Language> langList = new ArrayList<Language>();
        Collections.addAll(langList, LANGUAGES);
        langList.addAll(externalLanguages);
        return langList;
    }

    @Nullable
    public static Language getLanguageForName(String languageName) {
        for (Language element : LANGUAGES) {
            if (!languageName.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    public static Language getLanguageForShortName(String langCode) {
        Language language = Language.getLanguageForShortNameOrNull(langCode);
        if (language == null) {
            ArrayList<String> codes = new ArrayList<String>();
            for (Language realLanguage : LANGUAGES) {
                codes.add(realLanguage.getShortNameWithCountryAndVariant());
            }
            Collections.sort(codes);
            throw new IllegalArgumentException("'" + langCode + "' is not a language code known to LanguageTool." + " Supported language codes are: " + StringUtils.join(codes, (String)", ") + ". The list of languages is read from " + PROPERTIES_PATH + " in the Java classpath. See http://wiki.languagetool.org/java-api for details.");
        }
        return language;
    }

    public static boolean isLanguageSupported(String langCode) {
        return Language.getLanguageForShortNameOrNull(langCode) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static Language getLanguageForShortNameOrNull(String langCode) {
        StringTools.assureSet(langCode, "langCode");
        Language result = null;
        if (langCode.contains("-x-")) {
            Language[] arr$ = LANGUAGES;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                Language element = arr$[i$];
                if (element.getShortName().equalsIgnoreCase(langCode)) {
                    return element;
                }
                ++i$;
            }
            return result;
        }
        if (langCode.contains("-")) {
            String[] parts = langCode.split("-");
            if (parts.length == 2) {
                Language[] arr$ = LANGUAGES;
                int len$ = arr$.length;
                int i$ = 0;
                while (i$ < len$) {
                    Language element = arr$[i$];
                    if (parts[0].equalsIgnoreCase(element.getShortName()) && element.getCountries().length == 1 && parts[1].equalsIgnoreCase(element.getCountries()[0])) {
                        return element;
                    }
                    ++i$;
                }
                return result;
            }
            if (parts.length != 3) throw new IllegalArgumentException("'" + langCode + "' isn't a valid language code");
            Language[] arr$ = LANGUAGES;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                Language element = arr$[i$];
                if (parts[0].equalsIgnoreCase(element.getShortName()) && element.getCountries().length == 1 && parts[1].equalsIgnoreCase(element.getCountries()[0]) && parts[2].equalsIgnoreCase(element.getVariant())) {
                    return element;
                }
                ++i$;
            }
            return result;
        }
        Language[] arr$ = LANGUAGES;
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            Language element = arr$[i$];
            if (langCode.equalsIgnoreCase(element.getShortName())) {
                return element;
            }
            ++i$;
        }
        return result;
    }

    public static Language getLanguageForLocale(Locale locale) {
        Language language = Language.getLanguageForLanguageNameAndCountry(locale);
        if (language != null) {
            return language;
        }
        Language firstFallbackLanguage = Language.getLanguageForLanguageNameOnly(locale);
        if (firstFallbackLanguage != null) {
            return firstFallbackLanguage;
        }
        for (Language aLanguage : REAL_LANGUAGES) {
            if (!aLanguage.getShortNameWithCountryAndVariant().equals("en-US")) continue;
            return aLanguage;
        }
        throw new RuntimeException("No appropriate language found, not even en-US. Supported languages: " + Arrays.toString(REAL_LANGUAGES));
    }

    @Nullable
    private static Language getLanguageForLanguageNameAndCountry(Locale locale) {
        for (Language language : REAL_LANGUAGES) {
            List<String> countryVariants;
            if (!language.getShortName().equals(locale.getLanguage()) || !(countryVariants = Arrays.asList(language.getCountries())).contains(locale.getCountry())) continue;
            return language;
        }
        return null;
    }

    @Nullable
    private static Language getLanguageForLanguageNameOnly(Locale locale) {
        for (Language language : REAL_LANGUAGES) {
            Language defaultVariant;
            if (!language.getShortName().equals(locale.getLanguage()) || !language.hasVariant() || (defaultVariant = language.getDefaultLanguageVariant()) == null) continue;
            return defaultVariant;
        }
        for (Language language : REAL_LANGUAGES) {
            if (!language.getShortName().equals(locale.getLanguage()) || language.hasVariant()) continue;
            return language;
        }
        return null;
    }

    public final String toString() {
        return this.getName();
    }

    public final boolean isVariant() {
        for (Language language : LANGUAGES) {
            boolean skip = language.getShortNameWithCountryAndVariant().equals(this.getShortNameWithCountryAndVariant());
            if (skip || !language.getClass().isAssignableFrom(this.getClass())) continue;
            return true;
        }
        return false;
    }

    public final boolean hasVariant() {
        for (Language language : LANGUAGES) {
            boolean skip = language.getShortNameWithCountryAndVariant().equals(this.getShortNameWithCountryAndVariant());
            if (skip || !this.getClass().isAssignableFrom(language.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean isExternal() {
        return this.isExternalLanguage;
    }

    public void makeExternal() {
        this.isExternalLanguage = true;
    }

    public boolean equalsConsiderVariantsIfSpecified(Language otherLanguage) {
        if (this.getShortName().equals(otherLanguage.getShortName())) {
            boolean thisHasCountry = this.hasCountry();
            boolean otherHasCountry = otherLanguage.hasCountry();
            return !thisHasCountry || !otherHasCountry || this.getShortNameWithCountryAndVariant().equals(otherLanguage.getShortNameWithCountryAndVariant());
        }
        return false;
    }

    private boolean hasCountry() {
        return this.getCountries().length == 1;
    }

    public Pattern getIgnoredCharactersRegex() {
        return this.ignoredCharactersRegex;
    }

    public void setIgnoredCharactersRegex(String ignoredCharactersRegex) {
        this.ignoredCharactersRegex = Pattern.compile(ignoredCharactersRegex);
    }
}

