/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.Objects;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jetbrains.annotations.Nullable;

public final class AnalyzedToken {
    private final String token;
    private final String posTag;
    private final String lemma;
    private final String tokenInflected;
    private boolean isWhitespaceBefore;
    private boolean hasNoPOSTag;

    public AnalyzedToken(String token, String posTag, String lemma) {
        this.token = Objects.requireNonNull(token, "token cannot be null");
        this.posTag = posTag;
        this.lemma = lemma;
        this.tokenInflected = lemma == null ? token : lemma;
        this.hasNoPOSTag = posTag == null || "SENT_END".equals(posTag) || "PARA_END".equals(posTag);
    }

    public String getToken() {
        return this.token;
    }

    @Nullable
    public String getPOSTag() {
        return this.posTag;
    }

    @Nullable
    public String getLemma() {
        return this.lemma;
    }

    public String getTokenInflected() {
        return this.tokenInflected;
    }

    public void setWhitespaceBefore(boolean whitespaceBefore) {
        this.isWhitespaceBefore = whitespaceBefore;
    }

    public boolean isWhitespaceBefore() {
        return this.isWhitespaceBefore;
    }

    public boolean matches(AnalyzedToken an) {
        if (this.equals(an)) {
            return true;
        }
        if ("".equals(an.getToken()) && an.getLemma() == null && an.getPOSTag() == null) {
            return false;
        }
        boolean found = true;
        if (!"".equals(an.getToken())) {
            found = an.getToken().equals(this.token);
        }
        if (an.getLemma() != null) {
            found &= an.getLemma().equals(this.lemma);
        }
        if (an.getPOSTag() != null) {
            found &= an.getPOSTag().equals(this.posTag);
        }
        return found;
    }

    public boolean hasNoTag() {
        return this.hasNoPOSTag;
    }

    public void setNoPOSTag(boolean noTag) {
        this.hasNoPOSTag = noTag;
    }

    public String toString() {
        return this.tokenInflected + '/' + this.posTag;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.isWhitespaceBefore).append((Object)this.lemma).append((Object)this.posTag).append((Object)this.token).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AnalyzedToken rhs = (AnalyzedToken)obj;
        return new EqualsBuilder().append((Object)this.token, (Object)rhs.token).append((Object)this.posTag, (Object)rhs.posTag).append((Object)this.lemma, (Object)rhs.lemma).append(this.isWhitespaceBefore, rhs.isWhitespaceBefore).isEquals();
    }
}

