/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.tools.ContextTools;
import org.languagetool.tools.StringTools;

public class RuleAsXmlSerializer {
    private static final int CAPACITY = 200;

    public String getXmlStart(Language lang, Language motherTongue) {
        StringBuilder xml = new StringBuilder(200);
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<matches software=\"LanguageTool\" version=\"2.7\" buildDate=\"").append(JLanguageTool.BUILD_DATE).append("\">\n");
        if (lang != null || motherTongue != null) {
            String languageXml = "<language ";
            if (lang != null) {
                languageXml = languageXml + "shortname=\"" + lang.getShortNameWithCountryAndVariant() + "\" name=\"" + lang.getName() + "\"";
            }
            if (!(motherTongue == null || lang != null && motherTongue.getShortName().equals(lang.getShortNameWithCountryAndVariant()))) {
                languageXml = languageXml + " mothertongueshortname=\"" + motherTongue.getShortName() + "\" mothertonguename=\"" + motherTongue.getName() + "\"";
            }
            languageXml = languageXml + "/>\n";
            xml.append(languageXml);
        }
        return xml.toString();
    }

    public String getXmlEnd() {
        return "</matches>\n";
    }

    public String ruleMatchesToXmlSnippet(List<RuleMatch> ruleMatches, String text, int contextSize) {
        StringBuilder xml = new StringBuilder(200);
        ContextTools contextTools = new ContextTools();
        contextTools.setEscapeHtml(false);
        contextTools.setContextSize(contextSize);
        String startMarker = "__languagetool_start_marker";
        contextTools.setErrorMarkerStart(startMarker);
        contextTools.setErrorMarkerEnd("");
        for (RuleMatch match : ruleMatches) {
            ITSIssueType type;
            Category category;
            PatternRule pRule;
            String subId = "";
            if (match.getRule() instanceof PatternRule && (pRule = (PatternRule)match.getRule()).getSubId() != null) {
                subId = " subId=\"" + RuleAsXmlSerializer.escapeXMLForAPIOutput(pRule.getSubId()) + "\" ";
            }
            xml.append("<error fromy=\"").append(match.getLine()).append('\"').append(" fromx=\"").append(match.getColumn() - 1).append('\"').append(" toy=\"").append(match.getEndLine()).append('\"').append(" tox=\"").append(match.getEndColumn() - 1).append('\"').append(" ruleId=\"").append(match.getRule().getId()).append('\"');
            String msg = match.getMessage().replaceAll("</?suggestion>", "'");
            xml.append(subId);
            xml.append(" msg=\"").append(RuleAsXmlSerializer.escapeXMLForAPIOutput(msg)).append('\"');
            String context = contextTools.getContext(match.getFromPos(), match.getToPos(), text);
            xml.append(" replacements=\"").append(RuleAsXmlSerializer.escapeXMLForAPIOutput(StringTools.listToString(match.getSuggestedReplacements(), "#"))).append('\"');
            int contextOffset = context.indexOf(startMarker);
            context = context.replaceFirst(startMarker, "");
            context = context.replaceAll("[\n\r]", " ");
            xml.append(" context=\"").append(StringTools.escapeXML(context)).append('\"').append(" contextoffset=\"").append(contextOffset).append('\"').append(" offset=\"").append(match.getFromPos()).append('\"').append(" errorlength=\"").append(match.getToPos() - match.getFromPos()).append('\"');
            if (match.getRule().getUrl() != null) {
                xml.append(" url=\"").append(RuleAsXmlSerializer.escapeXMLForAPIOutput(match.getRule().getUrl().toString())).append('\"');
            }
            if ((category = match.getRule().getCategory()) != null) {
                xml.append(" category=\"").append(RuleAsXmlSerializer.escapeXMLForAPIOutput(category.getName())).append('\"');
            }
            if ((type = match.getRule().getLocQualityIssueType()) != null) {
                xml.append(" locqualityissuetype=\"").append(RuleAsXmlSerializer.escapeXMLForAPIOutput(type.toString())).append('\"');
            }
            xml.append("/>\n");
        }
        return xml.toString();
    }

    public String ruleMatchesToXml(List<RuleMatch> ruleMatches, String text, int contextSize, Language lang, Language motherTongue) {
        StringBuilder xml = new StringBuilder(200);
        xml.append(this.getXmlStart(lang, motherTongue));
        xml.append(this.ruleMatchesToXmlSnippet(ruleMatches, text, contextSize));
        xml.append(this.getXmlEnd());
        return xml.toString();
    }

    public String ruleMatchesToXml(List<RuleMatch> ruleMatches, String text, int contextSize, Language lang) {
        StringBuilder xml = new StringBuilder(200);
        xml.append(this.getXmlStart(lang, null));
        xml.append(this.ruleMatchesToXmlSnippet(ruleMatches, text, contextSize));
        xml.append(this.getXmlEnd());
        return xml.toString();
    }

    private static String escapeXMLForAPIOutput(String s) {
        return StringTools.escapeXML(s).replaceAll("[\n\r]", " ");
    }
}

