/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.segment.srx.SrxDocument;
import net.sourceforge.segment.srx.SrxTextIterator;
import net.sourceforge.segment.srx.io.Srx2SaxParser;
import org.languagetool.JLanguageTool;

final class SrxTools {
    private SrxTools() {
    }

    static SrxDocument createSrxDocument(InputStream inputStream) {
        SrxDocument srxDocument;
        BufferedReader srxReader = null;
        try {
            srxReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            HashMap<String, Boolean> parserParameters = new HashMap<String, Boolean>();
            parserParameters.put("validate", true);
            Srx2SaxParser srxParser = new Srx2SaxParser(parserParameters);
            srxDocument = srxParser.parse((Reader)srxReader);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Could not load rules from resource dir " + JLanguageTool.getDataBroker().getResourceDir(), e);
            }
            catch (Throwable throwable) {
                SrxTools.closeQuietly(srxReader);
                SrxTools.closeQuietly(inputStream);
                throw throwable;
            }
        }
        SrxTools.closeQuietly(srxReader);
        SrxTools.closeQuietly(inputStream);
        return srxDocument;
    }

    private static void closeQuietly(Closeable srxReader) {
        if (srxReader != null) {
            try {
                srxReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static List<String> tokenize(String text, SrxDocument srxDocument, String code) {
        ArrayList<String> segments = new ArrayList<String>();
        SrxTextIterator textIterator = new SrxTextIterator(srxDocument, code, (CharSequence)text);
        while (textIterator.hasNext()) {
            segments.add(textIterator.next());
        }
        return segments;
    }
}

