/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.languagetool.tools.StringTools;

public class ManualTagger {
    private final Map<String, List<LookedUpTerm>> mapping;

    public ManualTagger(InputStream inputStream) throws IOException {
        this.mapping = this.loadMapping(inputStream, "utf8");
    }

    public String[] lookup(String term) {
        List<LookedUpTerm> l = this.mapping.get(term);
        if (l == null) {
            return null;
        }
        ArrayList<String> plainResult = new ArrayList<String>();
        Iterator<LookedUpTerm> i$ = l.iterator();
        while (i$.hasNext()) {
            LookedUpTerm element;
            LookedUpTerm lookedUpTerm = element = i$.next();
            plainResult.add(lookedUpTerm.baseform);
            plainResult.add(lookedUpTerm.posTags);
        }
        if (plainResult.isEmpty()) {
            return null;
        }
        return plainResult.toArray(new String[plainResult.size()]);
    }

    private Map<String, List<LookedUpTerm>> loadMapping(InputStream inputStream, String encoding) throws IOException {
        HashMap<String, List<LookedUpTerm>> map = new HashMap<String, List<LookedUpTerm>>();
        try (InputStreamReader reader = new InputStreamReader(inputStream, encoding);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (StringTools.isEmpty(line) || line.charAt(0) == '#') continue;
                String[] parts = line.split("\t");
                if (parts.length != 3) {
                    throw new IOException("Unknown line format when loading manual tagger dictionary: " + line);
                }
                ArrayList<LookedUpTerm> terms = (ArrayList<LookedUpTerm>)map.get(parts[0]);
                if (terms == null) {
                    terms = new ArrayList<LookedUpTerm>();
                }
                terms.add(new LookedUpTerm(parts[1], parts[2]));
                map.put(parts[0], terms);
            }
        }
        return map;
    }

    private class LookedUpTerm {
        final String baseform;
        final String posTags;

        LookedUpTerm(String baseform, String posTags) {
            this.baseform = baseform;
            this.posTags = posTags;
        }
    }
}

