/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import morfologik.speller.Speller;
import morfologik.stemming.Dictionary;
import org.languagetool.JLanguageTool;
import org.languagetool.tools.StringTools;

public class MorfologikSpeller {
    private final Dictionary dictionary;
    private final Speller speller;

    public MorfologikSpeller(String filename, int maxEditDistance) throws IOException {
        if (maxEditDistance <= 0) {
            throw new RuntimeException("maxEditDistance must be > 0: " + maxEditDistance);
        }
        URL url = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(filename);
        this.dictionary = Dictionary.read((URL)url);
        this.speller = new Speller(this.dictionary, maxEditDistance);
    }

    public MorfologikSpeller(String filename, Locale conversionLocale, int maxEditDistance) throws IOException {
        this(filename, maxEditDistance);
    }

    public MorfologikSpeller(String filename, Locale conversionLocale) throws IOException {
        this(filename, 1);
    }

    public MorfologikSpeller(String filename) throws IOException {
        this(filename, 1);
    }

    public boolean isMisspelled(String word) {
        return word.length() > 0 && !"LanguageTool".equals(word) && !"LanguageToolFx".equals(word) && this.speller.isMisspelled(word);
    }

    public List<String> getSuggestions(String word) {
        ArrayList<String> suggestions = new ArrayList<String>();
        try {
            suggestions.addAll(this.speller.findReplacements(word));
            suggestions.addAll(this.speller.replaceRunOnWords(word));
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        if (this.dictionary.metadata.isConvertingCase() && StringTools.startsWithUppercase(word)) {
            for (int i = 0; i < suggestions.size(); ++i) {
                String uppercaseFirst = StringTools.uppercaseFirstChar((String)suggestions.get(i));
                int auxIndex = suggestions.indexOf(uppercaseFirst);
                if (auxIndex > i) {
                    suggestions.remove(auxIndex);
                }
                if (auxIndex > -1 && auxIndex < i) {
                    suggestions.remove(i);
                    --i;
                    continue;
                }
                suggestions.set(i, uppercaseFirst);
            }
        }
        return suggestions;
    }

    public boolean convertsCase() {
        return this.speller.convertsCase();
    }
}

