/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.hunspell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.spelling.hunspell.HunspellRule;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;
import org.languagetool.tokenizers.CompoundWordTokenizer;
import org.languagetool.tools.StringTools;

public abstract class CompoundAwareHunspellRule
extends HunspellRule {
    private static final int MAX_SUGGESTIONS = 20;
    private final CompoundWordTokenizer wordSplitter;
    private final MorfologikSpeller morfoSpeller;

    public CompoundAwareHunspellRule(ResourceBundle messages, Language language, CompoundWordTokenizer wordSplitter, MorfologikSpeller morfoSpeller) {
        super(messages, language);
        this.wordSplitter = wordSplitter;
        this.morfoSpeller = morfoSpeller;
    }

    @Override
    public List<String> getSuggestions(String word) throws IOException {
        if (this.needsInit) {
            this.init();
        }
        ArrayList<String> candidates = new ArrayList<String>();
        List<String> noSplitSuggestions = this.morfoSpeller.getSuggestions(word);
        candidates.addAll(noSplitSuggestions);
        if (StringTools.startsWithUppercase(word) && !StringTools.isAllUppercase(word)) {
            List<String> noSplitLowercaseSuggestions = this.morfoSpeller.getSuggestions(word.toLowerCase());
            int pos = candidates.size() == 0 ? 0 : 1;
            for (String suggestion : noSplitLowercaseSuggestions) {
                candidates.add(pos, StringTools.uppercaseFirstChar(suggestion));
                pos = Math.min(pos + 2, candidates.size());
            }
        }
        List<String> parts = this.wordSplitter.tokenize(word);
        int partCount = 0;
        for (String part : parts) {
            if (this.hunspellDict.misspelled(part)) {
                List<String> suggestions = this.morfoSpeller.getSuggestions(part);
                if (suggestions.size() == 0) {
                    suggestions = this.morfoSpeller.getSuggestions(StringTools.uppercaseFirstChar(part));
                }
                for (String suggestion : suggestions) {
                    ArrayList<String> partsCopy = new ArrayList<String>(parts);
                    if (partCount > 0 && !parts.get(partCount - 1).endsWith("-")) {
                        partsCopy.set(partCount, suggestion.toLowerCase());
                    } else {
                        partsCopy.set(partCount, suggestion);
                    }
                    candidates.add(StringTools.listToString(partsCopy, ""));
                }
            }
            ++partCount;
        }
        this.filterDupes(candidates);
        List<String> suggestions = this.getCorrectWords(candidates);
        List<String> sortedSuggestions = this.sortSuggestionByQuality(word, suggestions);
        return sortedSuggestions.subList(0, Math.min(20, sortedSuggestions.size()));
    }

    protected List<String> sortSuggestionByQuality(String misspelling, List<String> suggestions) {
        return suggestions;
    }

    private void filterDupes(List<String> words) {
        HashSet<String> seen = new HashSet<String>();
        Iterator<String> iterator = words.iterator();
        while (iterator.hasNext()) {
            String word = iterator.next();
            if (seen.contains(word)) {
                iterator.remove();
            }
            seen.add(word);
        }
    }

    private List<String> getCorrectWords(List<String> wordsOrPhrases) {
        ArrayList<String> result = new ArrayList<String>();
        for (String wordOrPhrase : wordsOrPhrases) {
            String[] words = this.tokenizeText(wordOrPhrase);
            boolean wordIsOkay = true;
            for (String word : words) {
                if (!this.hunspellDict.misspelled(word)) continue;
                wordIsOkay = false;
                break;
            }
            if (!wordIsOkay) continue;
            result.add(wordOrPhrase);
        }
        return result;
    }
}

