/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.EquivalenceTypeLocator;

public class Unifier {
    private static final String UNIFY_IGNORE = "unify-ignore";
    private final List<AnalyzedTokenReadings> tokSequence;
    private final List<List<Map<String, Set<String>>>> tokSequenceEquivalences;
    private boolean allFeatsIn;
    private int tokCnt = 0;
    private int readingsCounter = 1;
    private final Map<EquivalenceTypeLocator, Element> equivalenceTypes;
    private final Map<String, List<String>> equivalenceFeatures;
    private final List<Map<String, Set<String>>> equivalencesMatched = new ArrayList<Map<String, Set<String>>>();
    private List<Boolean> featuresFound;
    private List<Boolean> tmpFeaturesFound;
    private final Map<String, Set<String>> equivalencesToBeKept;
    private Map<String, List<String>> unificationFeats;
    private boolean inUnification;
    private boolean uniMatched;
    private boolean uniAllMatched;

    public Unifier(Map<EquivalenceTypeLocator, Element> equivalenceTypes, Map<String, List<String>> equivalenceFeatures) {
        this.equivalenceTypes = equivalenceTypes;
        this.equivalenceFeatures = equivalenceFeatures;
        this.equivalencesToBeKept = new ConcurrentHashMap<String, Set<String>>();
        this.featuresFound = new ArrayList<Boolean>();
        this.tmpFeaturesFound = new ArrayList<Boolean>();
        this.tokSequence = new ArrayList<AnalyzedTokenReadings>();
        this.tokSequenceEquivalences = new ArrayList<List<Map<String, Set<String>>>>();
    }

    protected final boolean isSatisfied(AnalyzedToken aToken, Map<String, List<String>> uFeatures) {
        if (this.allFeatsIn && this.equivalencesMatched.isEmpty()) {
            return false;
        }
        if (uFeatures == null) {
            return false;
        }
        this.unificationFeats = uFeatures;
        boolean unified = true;
        if (this.allFeatsIn) {
            unified = this.checkNext(aToken, uFeatures);
        } else {
            while (this.equivalencesMatched.size() <= this.tokCnt) {
                this.equivalencesMatched.add(new ConcurrentHashMap());
            }
            for (Map.Entry<String, List<String>> feat : uFeatures.entrySet()) {
                List<String> types = feat.getValue();
                if (types == null || types.isEmpty()) {
                    types = this.equivalenceFeatures.get(feat.getKey());
                }
                for (String typeName : types) {
                    Element testElem = this.equivalenceTypes.get(new EquivalenceTypeLocator(feat.getKey(), typeName));
                    if (testElem == null) {
                        return false;
                    }
                    if (!testElem.isMatched(aToken)) continue;
                    if (!this.equivalencesMatched.get(this.tokCnt).containsKey(feat.getKey())) {
                        HashSet<String> typeSet = new HashSet<String>();
                        typeSet.add(typeName);
                        this.equivalencesMatched.get(this.tokCnt).put(feat.getKey(), typeSet);
                        continue;
                    }
                    this.equivalencesMatched.get(this.tokCnt).get(feat.getKey()).add(typeName);
                }
                unified = this.equivalencesMatched.get(this.tokCnt).containsKey(feat.getKey());
                if (unified) continue;
                break;
            }
            if (unified) {
                if (this.tokCnt == 0 || this.tokSequence.isEmpty()) {
                    this.tokSequence.add(new AnalyzedTokenReadings(aToken, 0));
                    ArrayList<Map<String, Set<String>>> equivList = new ArrayList<Map<String, Set<String>>>();
                    equivList.add(this.equivalencesMatched.get(this.tokCnt));
                    this.tokSequenceEquivalences.add(equivList);
                } else {
                    this.tokSequence.get(0).addReading(aToken);
                    this.tokSequenceEquivalences.get(0).add(this.equivalencesMatched.get(this.tokCnt));
                }
                ++this.tokCnt;
            }
        }
        return unified;
    }

    private boolean checkNext(AnalyzedToken aToken, Map<String, List<String>> uFeatures) {
        boolean anyFeatUnified = false;
        ArrayList<Boolean> tokenFeaturesFound = new ArrayList<Boolean>(this.tmpFeaturesFound);
        ConcurrentHashMap equivalencesMatchedHere = new ConcurrentHashMap();
        if (this.allFeatsIn) {
            for (int i = 0; i < this.tokCnt; ++i) {
                boolean allFeatsUnified = true;
                for (Map.Entry<String, List<String>> feat : uFeatures.entrySet()) {
                    boolean featUnified = false;
                    List<String> types = feat.getValue();
                    if (types == null || types.isEmpty()) {
                        types = this.equivalenceFeatures.get(feat.getKey());
                    }
                    for (String typeName : types) {
                        HashSet<String> typeSet;
                        if (!this.equivalencesMatched.get(i).containsKey(feat.getKey()) || !this.equivalencesMatched.get(i).get(feat.getKey()).contains(typeName)) continue;
                        Element testElem = this.equivalenceTypes.get(new EquivalenceTypeLocator(feat.getKey(), typeName));
                        boolean matched = testElem.isMatched(aToken);
                        boolean bl = featUnified = featUnified || matched;
                        if (!matched) continue;
                        if (!this.equivalencesToBeKept.containsKey(feat.getKey())) {
                            typeSet = new HashSet<String>();
                            typeSet.add(typeName);
                            this.equivalencesToBeKept.put(feat.getKey(), typeSet);
                        } else {
                            this.equivalencesToBeKept.get(feat.getKey()).add(typeName);
                        }
                        if (!equivalencesMatchedHere.containsKey(feat.getKey())) {
                            typeSet = new HashSet();
                            typeSet.add(typeName);
                            equivalencesMatchedHere.put(feat.getKey(), typeSet);
                            continue;
                        }
                        ((Set)equivalencesMatchedHere.get(feat.getKey())).add(typeName);
                    }
                    allFeatsUnified &= featUnified;
                }
                tokenFeaturesFound.set(i, (Boolean)tokenFeaturesFound.get(i) != false || allFeatsUnified);
                anyFeatUnified = anyFeatUnified || allFeatsUnified;
            }
            if (anyFeatUnified) {
                if (this.tokSequence.size() == this.readingsCounter) {
                    this.tokSequence.add(new AnalyzedTokenReadings(aToken, 0));
                    ArrayList equivList = new ArrayList();
                    equivList.add(equivalencesMatchedHere);
                    this.tokSequenceEquivalences.add(equivList);
                } else if (this.readingsCounter < this.tokSequence.size()) {
                    this.tokSequence.get(this.readingsCounter).addReading(aToken);
                    this.tokSequenceEquivalences.get(this.readingsCounter).add(equivalencesMatchedHere);
                } else {
                    anyFeatUnified = false;
                }
                this.tmpFeaturesFound = tokenFeaturesFound;
            }
        }
        return anyFeatUnified;
    }

    public final void startNextToken() {
        this.featuresFound = new ArrayList<Boolean>(this.tmpFeaturesFound);
        ++this.readingsCounter;
        for (int j = 0; j < this.tokSequence.size(); ++j) {
            for (int i = 0; i < this.tokSequenceEquivalences.get(j).size(); ++i) {
                for (Map.Entry<String, List<String>> feat : this.equivalenceFeatures.entrySet()) {
                    if (!UNIFY_IGNORE.equals(feat.getKey())) {
                        if (!this.tokSequenceEquivalences.get(j).get(i).containsKey(feat.getKey())) continue;
                        if (this.equivalencesToBeKept.containsKey(feat.getKey())) {
                            this.tokSequenceEquivalences.get(j).get(i).get(feat.getKey()).retainAll((Collection)this.equivalencesToBeKept.get(feat.getKey()));
                            continue;
                        }
                        this.tokSequenceEquivalences.get(j).get(i).remove(feat.getKey());
                        continue;
                    }
                    this.tokSequenceEquivalences.get(j).get(i).remove(feat.getKey());
                }
            }
        }
        this.equivalencesToBeKept.clear();
    }

    public final void startUnify() {
        this.allFeatsIn = true;
        for (int i = 0; i < this.tokCnt; ++i) {
            this.featuresFound.add(false);
        }
        this.tmpFeaturesFound = new ArrayList<Boolean>(this.featuresFound);
    }

    public final boolean getFinalUnificationValue(Map<String, List<String>> uFeatures) {
        int tokUnified = 0;
        for (int j = 0; j < this.tokSequence.size(); ++j) {
            for (int i = 0; i < this.tokSequenceEquivalences.get(j).size(); ++i) {
                int featUnified = 0;
                if (this.tokSequenceEquivalences.get(j).get(i).containsKey(UNIFY_IGNORE)) {
                    if (i != 0) continue;
                    ++tokUnified;
                    continue;
                }
                for (Map.Entry<String, List<String>> feat : uFeatures.entrySet()) {
                    featUnified = this.tokSequenceEquivalences.get(j).get(i).containsKey(feat.getKey()) && this.tokSequenceEquivalences.get(j).get(i).get(feat.getKey()).isEmpty() ? 0 : ++featUnified;
                    if (featUnified != this.unificationFeats.entrySet().size() || tokUnified > j) continue;
                    ++tokUnified;
                    break;
                }
                if (tokUnified != this.tokSequence.size()) continue;
                return true;
            }
        }
        return false;
    }

    public final void reset() {
        this.equivalencesMatched.clear();
        this.allFeatsIn = false;
        this.tokCnt = 0;
        this.featuresFound.clear();
        this.tmpFeaturesFound.clear();
        this.tokSequence.clear();
        this.tokSequenceEquivalences.clear();
        this.readingsCounter = 1;
        this.uniMatched = false;
        this.uniAllMatched = false;
        this.inUnification = false;
    }

    public final AnalyzedTokenReadings[] getUnifiedTokens() {
        if (this.tokSequence.isEmpty()) {
            return null;
        }
        ArrayList<AnalyzedTokenReadings> uTokens = new ArrayList<AnalyzedTokenReadings>();
        for (int j = 0; j < this.tokSequence.size(); ++j) {
            for (int i = 0; i < this.tokSequenceEquivalences.get(j).size(); ++i) {
                int featUnified = 0;
                if (this.tokSequenceEquivalences.get(j).get(i).containsKey(UNIFY_IGNORE)) {
                    this.addTokenToSequence(uTokens, this.tokSequence.get(j).getAnalyzedToken(i), j);
                    continue;
                }
                for (Map.Entry<String, List<String>> feat : this.unificationFeats.entrySet()) {
                    featUnified = this.tokSequenceEquivalences.get(j).get(i).containsKey(feat.getKey()) && this.tokSequenceEquivalences.get(j).get(i).get(feat.getKey()).isEmpty() ? 0 : ++featUnified;
                    if (featUnified != this.unificationFeats.entrySet().size()) continue;
                    this.addTokenToSequence(uTokens, this.tokSequence.get(j).getAnalyzedToken(i), j);
                }
            }
        }
        return uTokens.toArray(new AnalyzedTokenReadings[uTokens.size()]);
    }

    private void addTokenToSequence(List<AnalyzedTokenReadings> tokenSequence, AnalyzedToken token, int pos) {
        if (tokenSequence.size() <= pos || tokenSequence.isEmpty()) {
            AnalyzedTokenReadings tmpATR = new AnalyzedTokenReadings(token, 0);
            tokenSequence.add(tmpATR);
        } else {
            tokenSequence.get(pos).addReading(token);
        }
    }

    public final boolean isUnified(AnalyzedToken matchToken, Map<String, List<String>> uFeatures, boolean lastReading, boolean isMatched) {
        if (this.inUnification) {
            if (isMatched) {
                this.uniMatched |= this.isSatisfied(matchToken, uFeatures);
            }
            this.uniAllMatched = this.uniMatched;
            if (lastReading) {
                this.startNextToken();
                this.uniMatched = false;
            }
            return this.uniAllMatched && this.getFinalUnificationValue(uFeatures);
        }
        if (isMatched) {
            this.isSatisfied(matchToken, uFeatures);
        }
        if (lastReading) {
            this.inUnification = true;
            this.uniMatched = false;
            this.startUnify();
        }
        return true;
    }

    public final boolean isUnified(AnalyzedToken matchToken, Map<String, List<String>> uFeatures, boolean lastReading) {
        return this.isUnified(matchToken, uFeatures, lastReading, true);
    }

    public final void addNeutralElement(AnalyzedTokenReadings analyzedTokenReadings) {
        this.tokSequence.add(analyzedTokenReadings);
        ArrayList tokEquivs = new ArrayList(analyzedTokenReadings.getReadingsLength());
        ConcurrentHashMap dummy = new ConcurrentHashMap();
        HashSet dummySet = new HashSet();
        dummy.put(UNIFY_IGNORE, dummySet);
        for (int i = 0; i < analyzedTokenReadings.getReadingsLength(); ++i) {
            tokEquivs.add(dummy);
        }
        this.tokSequenceEquivalences.add(tokEquivs);
        ++this.readingsCounter;
    }

    public final AnalyzedTokenReadings[] getFinalUnified() {
        if (this.inUnification) {
            return this.getUnifiedTokens();
        }
        return null;
    }
}

