/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;

class RuleFilterEvaluator {
    private final RuleFilter filter;

    RuleFilterEvaluator(RuleFilter filter) {
        this.filter = filter;
    }

    RuleMatch runFilter(String filterArgs, RuleMatch ruleMatch, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) {
        Map<String, String> args = this.getResolvedArguments(filterArgs, patternTokens, tokenPositions);
        return this.filter.acceptRuleMatch(ruleMatch, args, patternTokens);
    }

    Map<String, String> getResolvedArguments(String filterArgs, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) {
        String[] arguments;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String arg : arguments = filterArgs.split("\\s+")) {
            String[] keyVal = arg.split(":");
            if (keyVal.length != 2) {
                throw new RuntimeException("Invalid syntax for key/value, expected 'key:value', got: '" + arg + "'");
            }
            String key = keyVal[0];
            String val = keyVal[1];
            if (val.startsWith("\\")) {
                int refNumber = Integer.parseInt(val.replace("\\", ""));
                if (refNumber > tokenPositions.size()) {
                    throw new RuntimeException("Your reference number " + refNumber + " is bigger than the number of tokens: " + tokenPositions.size());
                }
                int correctedRef = this.getSkipCorrectedReference(tokenPositions, refNumber);
                if (correctedRef >= patternTokens.length) {
                    throw new RuntimeException("Your reference number " + refNumber + " is bigger than number of matching tokens: " + patternTokens.length);
                }
                if (result.containsKey(key)) {
                    throw new RuntimeException("Duplicate key '" + key + "'");
                }
                result.put(key, patternTokens[correctedRef].getToken());
                continue;
            }
            result.put(key, val);
        }
        return result;
    }

    private int getSkipCorrectedReference(List<Integer> tokenPositions, int refNumber) {
        int correctedRef = 0;
        int i = 0;
        for (int tokenPosition : tokenPositions) {
            if (i++ >= refNumber) break;
            correctedRef += tokenPosition;
        }
        return correctedRef - 1;
    }
}

