/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.languagetool.Language;
import org.languagetool.rules.patterns.FalseFriendRuleHandler;
import org.languagetool.rules.patterns.PatternRule;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FalseFriendRuleLoader
extends DefaultHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final List<PatternRule> getRules(File file, Language language, Language motherTongue) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            List<PatternRule> list = this.getRules(inputStream, language, motherTongue);
            return list;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException("Could not load false friend rules from " + file, e);
        }
    }

    public final List<PatternRule> getRules(InputStream stream, Language textLanguage, Language motherTongue) throws ParserConfigurationException, SAXException, IOException {
        FalseFriendRuleHandler handler = new FalseFriendRuleHandler(textLanguage, motherTongue);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.getXMLReader().setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        saxParser.parse(stream, (DefaultHandler)handler);
        List<PatternRule> rules = handler.getRules();
        ResourceBundle messages = ResourceBundle.getBundle("org.languagetool.MessagesBundle", motherTongue.getLocale());
        for (PatternRule rule : rules) {
            List<String> suggestionMap = handler.getSuggestionMap().get(rule.getId());
            if (suggestionMap == null) continue;
            MessageFormat msgFormat = new MessageFormat(messages.getString("false_friend_suggestion"));
            Object[] msg = new Object[]{this.formatSuggestions(suggestionMap)};
            rule.setMessage(rule.getMessage() + " " + msgFormat.format(msg));
        }
        return rules;
    }

    private String formatSuggestions(List<String> l) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = l.iterator();
        while (iter.hasNext()) {
            String s = iter.next();
            sb.append("<suggestion>");
            sb.append(s);
            sb.append("</suggestion>");
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

