/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.patterns.Element;

public class ElementMatcher {
    private final Element baseElement;
    private Element element;
    private List<ElementMatcher> andGroup;
    private boolean[] andGroupCheck;

    public ElementMatcher(Element element) {
        this.element = this.baseElement = element;
        this.resolveGroup();
    }

    private void resolveGroup() {
        if (this.baseElement.hasAndGroup()) {
            List<Element> elementAndGroup = this.baseElement.getAndGroup();
            this.andGroup = new ArrayList<ElementMatcher>(elementAndGroup.size());
            for (Element el : elementAndGroup) {
                ElementMatcher matcher = new ElementMatcher(el);
                this.andGroup.add(matcher);
            }
        }
    }

    public void resolveReference(int firstMatchToken, AnalyzedTokenReadings[] tokens, Language language) throws IOException {
        int refPos;
        if (this.baseElement.isReferenceElement() && (refPos = firstMatchToken + this.baseElement.getMatch().getTokenRef()) < tokens.length) {
            this.element = this.baseElement.compile(tokens[refPos], language.getSynthesizer());
        }
    }

    public Element getElement() {
        return this.baseElement;
    }

    public final boolean isMatched(AnalyzedToken token) {
        boolean matched = this.element.isMatched(token);
        if (this.element.hasAndGroup()) {
            this.andGroupCheck[0] = this.andGroupCheck[0] | matched;
        }
        return matched;
    }

    void prepareAndGroup(int firstMatchToken, AnalyzedTokenReadings[] tokens, Language language) throws IOException {
        if (this.baseElement.hasAndGroup()) {
            for (ElementMatcher andMatcher : this.andGroup) {
                andMatcher.resolveReference(firstMatchToken, tokens, language);
            }
            this.andGroupCheck = new boolean[this.element.getAndGroup().size() + 1];
            Arrays.fill(this.andGroupCheck, false);
        }
    }

    public final void addMemberAndGroup(AnalyzedToken token) {
        if (this.element.hasAndGroup()) {
            List<ElementMatcher> andGroupList = this.andGroup;
            for (int i = 0; i < andGroupList.size(); ++i) {
                ElementMatcher testAndGroup;
                if (this.andGroupCheck[i + 1] || !(testAndGroup = andGroupList.get(i)).isMatched(token)) continue;
                this.andGroupCheck[i + 1] = true;
            }
        }
    }

    public final boolean checkAndGroup(boolean previousValue) {
        if (this.element.hasAndGroup()) {
            boolean allConditionsMatch = true;
            for (boolean testValue : this.andGroupCheck) {
                allConditionsMatch &= testValue;
            }
            return allConditionsMatch;
        }
        return previousValue;
    }

    public final boolean isMatchedByScopeNextException(AnalyzedToken token) {
        return this.element.isMatchedByScopeNextException(token);
    }

    public final boolean isExceptionMatchedCompletely(AnalyzedToken token) {
        return this.element.isExceptionMatchedCompletely(token);
    }

    public boolean hasPreviousException() {
        return this.element.hasPreviousException();
    }

    public boolean isMatchedByPreviousException(AnalyzedTokenReadings token) {
        return this.element.isMatchedByPreviousException(token);
    }

    public String toString() {
        return "ElementMatcher for " + this.baseElement;
    }
}

