/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.ElementMatcher;
import org.languagetool.rules.patterns.Unifier;

public abstract class AbstractPatternRulePerformer {
    protected boolean prevMatched;
    protected AbstractPatternRule rule;
    protected Unifier unifier;
    protected AnalyzedTokenReadings[] unifiedTokens;

    protected AbstractPatternRulePerformer(AbstractPatternRule rule, Unifier unifier) {
        this.rule = rule;
        this.unifier = unifier;
    }

    protected List<ElementMatcher> createElementMatchers() {
        ArrayList<ElementMatcher> elementMatchers = new ArrayList<ElementMatcher>(this.rule.patternElements.size());
        for (Element el : this.rule.patternElements) {
            ElementMatcher matcher = new ElementMatcher(el);
            elementMatchers.add(matcher);
        }
        return elementMatchers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean testAllReadings(AnalyzedTokenReadings[] tokens, ElementMatcher elem, ElementMatcher prevElement, int tokenNo, int firstMatchToken, int prevSkipNext) throws IOException {
        int l;
        boolean thisMatched = false;
        int numberOfReadings = tokens[tokenNo].getReadingsLength();
        elem.prepareAndGroup(firstMatchToken, tokens, this.rule.getLanguage());
        for (l = 0; l < numberOfReadings; ++l) {
            AnalyzedToken matchToken = tokens[tokenNo].getAnalyzedToken(l);
            boolean tested = false;
            boolean bl = this.prevMatched = this.prevMatched || prevSkipNext > 0 && prevElement != null && prevElement.isMatchedByScopeNextException(matchToken);
            if (this.prevMatched) {
                return false;
            }
            if (!thisMatched) {
                thisMatched = elem.isMatched(matchToken);
                tested = true;
            }
            if (!(thisMatched || prevElement != null && prevElement.getElement().getExceptionList() != null)) {
                if (elem.getElement().getPOStag() == null) {
                    if (!elem.getElement().isInflected()) return false;
                    if (tokens[tokenNo].hasSameLemmas()) {
                        return false;
                    }
                } else if (!elem.getElement().getPOSNegation() && !tokens[tokenNo].isTagged()) {
                    return false;
                }
            }
            if (!this.rule.isGroupsOrUnification() || elem.getElement().isUnificationNeutral()) continue;
            thisMatched &= this.testUnificationAndGroups(thisMatched, l + 1 == numberOfReadings, matchToken, elem, tested);
        }
        if (thisMatched) {
            for (l = 0; l < numberOfReadings; ++l) {
                if (!elem.isExceptionMatchedCompletely(tokens[tokenNo].getAnalyzedToken(l))) continue;
                return false;
            }
            if (tokenNo > 0 && elem.hasPreviousException() && elem.isMatchedByPreviousException(tokens[tokenNo - 1])) {
                return false;
            }
            if (elem.getElement().isUnificationNeutral()) {
                this.unifier.addNeutralElement(tokens[tokenNo]);
            }
        }
        if (elem.getElement().getChunkTag() != null) {
            thisMatched &= tokens[tokenNo].getChunkTags().contains(elem.getElement().getChunkTag()) ^ elem.getElement().getNegation();
        }
        if (!elem.getElement().hasAndGroup()) return thisMatched;
        for (Element e : elem.getElement().getAndGroup()) {
            if (e.getChunkTag() == null) continue;
            thisMatched &= tokens[tokenNo].getChunkTags().contains(e.getChunkTag()) ^ e.getNegation();
        }
        return thisMatched;
    }

    protected boolean testUnificationAndGroups(boolean matched, boolean lastReading, AnalyzedToken matchToken, ElementMatcher elemMatcher, boolean alreadyTested) {
        boolean thisMatched = matched;
        boolean elemIsMatched = alreadyTested || elemMatcher.isMatched(matchToken);
        Element elem = elemMatcher.getElement();
        if (this.rule.testUnification) {
            if (matched && elem.isUnified()) {
                if (elem.isUniNegated()) {
                    thisMatched = !this.unifier.isUnified(matchToken, elem.getUniFeatures(), lastReading, elemIsMatched);
                } else if (elem.isLastInUnification()) {
                    thisMatched = this.unifier.isUnified(matchToken, elem.getUniFeatures(), lastReading, elemIsMatched);
                    if (thisMatched && this.rule.isGetUnified()) {
                        this.unifiedTokens = this.unifier.getFinalUnified();
                    }
                } else {
                    this.unifier.isUnified(matchToken, elem.getUniFeatures(), lastReading, elemIsMatched);
                }
            }
            if (!elem.isUnified()) {
                this.unifier.reset();
            }
        }
        elemMatcher.addMemberAndGroup(matchToken);
        if (lastReading) {
            thisMatched &= elemMatcher.checkAndGroup(thisMatched);
        }
        return thisMatched;
    }

    protected int getMinOccurrenceCorrection() {
        int minOccurCorrection = 0;
        for (Element element : this.rule.getPatternElements()) {
            if (element.getMinOccurrence() != 0) continue;
            ++minOccurCorrection;
        }
        return minOccurCorrection;
    }

    protected int skipMaxTokens(AnalyzedTokenReadings[] tokens, ElementMatcher elem, int firstMatchToken, int prevSkipNext, ElementMatcher prevElement, int m, int remainingElems) throws IOException {
        int maxSkip = 0;
        int maxOccurrences = elem.getElement().getMaxOccurrence() == -1 ? Integer.MAX_VALUE : elem.getElement().getMaxOccurrence();
        for (int j = 1; j < maxOccurrences && m + j < tokens.length - remainingElems; ++j) {
            boolean nextAllElementsMatch;
            boolean bl = nextAllElementsMatch = !tokens[m + j].isImmunized() && this.testAllReadings(tokens, elem, prevElement, m + j, firstMatchToken, prevSkipNext);
            if (!nextAllElementsMatch) break;
            ++maxSkip;
        }
        return maxSkip;
    }
}

