/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.bitext;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.bitext.StringPair;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.bitext.DifferentLengthRule;
import org.languagetool.rules.bitext.IncorrectBitextExample;
import org.languagetool.rules.bitext.SameTranslationRule;

public abstract class BitextRule
extends Rule {
    private List<StringPair> correctExamples;
    private List<IncorrectBitextExample> incorrectExamples;
    private Language sourceLanguage;

    public static List<Class<? extends BitextRule>> getRelevantRules() {
        return Arrays.asList(DifferentLengthRule.class, SameTranslationRule.class);
    }

    @Override
    public abstract String getDescription();

    public abstract String getMessage();

    @Override
    public abstract String getId();

    public abstract RuleMatch[] match(AnalyzedSentence var1, AnalyzedSentence var2) throws IOException;

    @Override
    public abstract void reset();

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        return null;
    }

    public final void setSourceLang(Language lang) {
        this.sourceLanguage = lang;
    }

    public final Language getSourceLang() {
        return this.sourceLanguage;
    }

    public final void setCorrectBitextExamples(List<StringPair> correctExamples) {
        this.correctExamples = correctExamples;
    }

    public final List<StringPair> getCorrectBitextExamples() {
        return this.correctExamples;
    }

    public final void setIncorrectBitextExamples(List<IncorrectBitextExample> incorrectExamples) {
        this.incorrectExamples = incorrectExamples;
    }

    public final List<IncorrectBitextExample> getIncorrectBitextExamples() {
        return this.incorrectExamples;
    }

    protected String getPureText(AnalyzedSentence sentence) {
        StringBuilder sb = new StringBuilder();
        for (AnalyzedTokenReadings token : sentence.getTokens()) {
            sb.append(token.getToken());
        }
        return sb.toString();
    }
}

