/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class SentenceWhitespaceRule
extends Rule {
    private boolean isFirstSentence = true;
    private boolean prevSentenceEndsWithWhitespace = false;

    public SentenceWhitespaceRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(new Category(messages.getString("category_misc")));
        this.setLocQualityIssueType(ITSIssueType.Whitespace);
    }

    @Override
    public String getId() {
        return "SENTENCE_WHITESPACE";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("missing_space_between_sentences");
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokens();
        if (this.isFirstSentence) {
            this.isFirstSentence = false;
        } else if (!this.prevSentenceEndsWithWhitespace && tokens.length > 1) {
            int startPos = 0;
            String firsToken = tokens[1].getToken();
            int endPos = firsToken.length();
            RuleMatch ruleMatch = new RuleMatch(this, startPos, endPos, this.messages.getString("addSpaceBetweenSentences"));
            ruleMatch.setSuggestedReplacement(" " + firsToken);
            ruleMatches.add(ruleMatch);
        }
        if (tokens.length > 0) {
            String lastToken = tokens[tokens.length - 1].getToken();
            this.prevSentenceEndsWithWhitespace = lastToken.trim().isEmpty() && lastToken.length() == 1;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public void reset() {
        this.isFirstSentence = true;
        this.prevSentenceEndsWithWhitespace = false;
    }
}

