/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleMatchFilter;
import org.languagetool.rules.patterns.PatternRule;

public class RuleWithMaxFilter
implements RuleMatchFilter {
    @Override
    public final List<RuleMatch> filter(List<RuleMatch> ruleMatches) {
        Collections.sort(ruleMatches);
        ArrayList<RuleMatch> filteredRules = new ArrayList<RuleMatch>();
        for (int i = 0; i < ruleMatches.size(); ++i) {
            RuleMatch match = ruleMatches.get(i);
            if (i < ruleMatches.size() - 1) {
                RuleMatch nextMatch = ruleMatches.get(i + 1);
                while (this.includes(match, nextMatch) && this.haveSameRule(match, nextMatch) && i < ruleMatches.size()) {
                    if (++i >= ruleMatches.size() - 1) continue;
                    nextMatch = ruleMatches.get(i + 1);
                }
            }
            filteredRules.add(match);
        }
        return filteredRules;
    }

    final boolean includes(RuleMatch match, RuleMatch nextMatch) {
        return match.getFromPos() <= nextMatch.getFromPos() && match.getToPos() >= nextMatch.getToPos();
    }

    private boolean haveSameRule(RuleMatch match, RuleMatch nextMatch) {
        if (!(match.getRule() instanceof PatternRule) || !(nextMatch.getRule() instanceof PatternRule)) {
            return false;
        }
        String id1 = match.getRule().getId();
        String subId1 = ((PatternRule)match.getRule()).getSubId();
        String subId2 = ((PatternRule)nextMatch.getRule()).getSubId();
        if (subId1 == null && subId2 != null) {
            return false;
        }
        if (subId1 != null && subId2 == null) {
            return false;
        }
        return id1 != null && id1.equals(nextMatch.getRule().getId()) && (subId1 == null && subId2 == null || subId1 != null && subId1.equals(subId2));
    }
}

