/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.languagetool.rules.ConfusionProbabilityRule;

public class ConfusionSetLoader {
    private static final String CHARSET = "utf-8";
    private final int minSentences;
    private final float maxErrorRate;
    private final Set<String> usefulHomophones;

    public ConfusionSetLoader() {
        this(null, 0, 100.0f);
    }

    public ConfusionSetLoader(InputStream infoStream, int minSentences, float maxErrorRate) {
        this.minSentences = minSentences;
        this.maxErrorRate = maxErrorRate;
        this.usefulHomophones = infoStream != null ? this.getUsefulHomophones(infoStream) : null;
    }

    public Map<String, ConfusionProbabilityRule.ConfusionSet> loadConfusionSet(InputStream stream) throws IOException {
        HashMap<String, ConfusionProbabilityRule.ConfusionSet> map = new HashMap<String, ConfusionProbabilityRule.ConfusionSet>();
        try (InputStreamReader reader = new InputStreamReader(stream, CHARSET);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] words = line.split(",\\s*");
                ConfusionProbabilityRule.ConfusionSet confusionSet = new ConfusionProbabilityRule.ConfusionSet(words);
                for (String word : words) {
                    if (this.usefulHomophones != null && !this.usefulHomophones.contains(word)) continue;
                    map.put(word, confusionSet);
                }
            }
        }
        return map;
    }

    private Set<String> getUsefulHomophones(InputStream infoStream) {
        HashSet<String> result = new HashSet<String>();
        try (InputStreamReader reader = new InputStreamReader(infoStream, CHARSET);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.isEmpty()) continue;
                String[] parts = line.split(";");
                String word = parts[0];
                int sentences = Integer.parseInt(parts[1]);
                float errorRate = Float.parseFloat(parts[3]);
                if (sentences < this.minSentences || !(errorRate <= this.maxErrorRate)) continue;
                result.add(word);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

