/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public abstract class AbstractWordCoherencyRule
extends Rule {
    private static final String FILE_ENCODING = "utf-8";
    private final Map<String, String> relevantWords;
    private final Map<String, RuleMatch> shouldNotAppearWord = new HashMap<String, RuleMatch>();

    protected abstract String getFilePath();

    protected abstract String getMessage(String var1, String var2);

    public AbstractWordCoherencyRule(ResourceBundle messages) throws IOException {
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_misc")));
        }
        this.relevantWords = this.loadWords(JLanguageTool.getDataBroker().getFromRulesDirAsStream(this.getFilePath()));
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings tmpToken : tokens = sentence.getTokensWithoutWhitespace()) {
            String baseform;
            String token;
            String origToken = token = tmpToken.getToken();
            List<AnalyzedToken> readings = tmpToken.getReadings();
            if (readings != null && readings.size() > 0 && (baseform = readings.get(0).getLemma()) != null) {
                token = baseform;
            }
            if (this.shouldNotAppearWord.containsKey(token)) {
                RuleMatch otherMatch = this.shouldNotAppearWord.get(token);
                String otherSpelling = otherMatch.getMessage();
                String msg = this.getMessage(token, otherSpelling);
                RuleMatch ruleMatch = new RuleMatch(this, tmpToken.getStartPos(), tmpToken.getStartPos() + origToken.length(), msg);
                ruleMatch.setSuggestedReplacement(otherSpelling);
                ruleMatches.add(ruleMatch);
                continue;
            }
            if (!this.relevantWords.containsKey(token)) continue;
            String shouldNotAppear = this.relevantWords.get(token);
            RuleMatch potentialRuleMatch = new RuleMatch(this, tmpToken.getStartPos(), tmpToken.getStartPos() + origToken.length(), token);
            this.shouldNotAppearWord.put(shouldNotAppear, potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private Map<String, String> loadWords(InputStream stream) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        try (InputStreamReader reader = new InputStreamReader(stream, FILE_ENCODING);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.length() < 1 || line.charAt(0) == '#') continue;
                String[] parts = line.split(";");
                if (parts.length != 2) {
                    throw new IOException("Format error in file " + JLanguageTool.getDataBroker().getFromRulesDirAsUrl(this.getFilePath()) + ", line: " + line);
                }
                map.put(parts[0], parts[1]);
                map.put(parts[1], parts[0]);
            }
        }
        return map;
    }

    @Override
    public void reset() {
        this.shouldNotAppearWord.clear();
    }
}

