/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class MultiThreadedJLanguageTool
extends JLanguageTool {
    private int threadPoolSize = -1;

    public MultiThreadedJLanguageTool(Language language) {
        super(language);
    }

    public MultiThreadedJLanguageTool(Language language, Language motherTongue) {
        super(language, motherTongue);
    }

    protected int getThreadPoolSize() {
        int poolSize = this.threadPoolSize;
        if (poolSize <= 0) {
            return Runtime.getRuntime().availableProcessors();
        }
        return poolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    protected ExecutorService getExecutorService(int threads) {
        return Executors.newFixedThreadPool(threads);
    }

    @Override
    protected List<RuleMatch> performCheck(List<AnalyzedSentence> analyzedSentences, List<String> sentences, List<Rule> allRules, JLanguageTool.ParagraphHandling paraMode, AnnotatedText annotatedText) throws IOException {
        int charCount = 0;
        int lineCount = 0;
        int columnCount = 1;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int threads = this.getThreadPoolSize();
        ExecutorService executorService = this.getExecutorService(threads);
        try {
            List<Callable<List<RuleMatch>>> callables = this.createTextCheckCallables(paraMode, annotatedText, analyzedSentences, sentences, allRules, charCount, lineCount, columnCount, threads);
            List<Future<List<RuleMatch>>> futures = executorService.invokeAll(callables);
            for (Future<List<RuleMatch>> future : futures) {
                ruleMatches.addAll((Collection<RuleMatch>)future.get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            executorService.shutdownNow();
        }
        return ruleMatches;
    }

    private List<Callable<List<RuleMatch>>> createTextCheckCallables(JLanguageTool.ParagraphHandling paraMode, AnnotatedText annotatedText, List<AnalyzedSentence> analyzedSentences, List<String> sentences, List<Rule> allRules, int charCount, int lineCount, int columnCount, int threads) {
        int totalRules = allRules.size();
        int chunkSize = totalRules / threads;
        int firstItem = 0;
        ArrayList<Callable<List<RuleMatch>>> callables = new ArrayList<Callable<List<RuleMatch>>>();
        for (int i = 0; i < threads; ++i) {
            List<Rule> subRules = i == threads - 1 ? allRules.subList(firstItem, totalRules) : allRules.subList(firstItem, firstItem + chunkSize);
            callables.add(new JLanguageTool.TextCheckCallable(this, subRules, sentences, analyzedSentences, paraMode, annotatedText, charCount, lineCount, columnCount));
            firstItem += chunkSize;
        }
        return callables;
    }
}

