/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.tools.StringTools;

public class AnalyzedTokenReadings
implements Iterable<AnalyzedToken> {
    protected AnalyzedToken[] anTokReadings;
    private int startPos;
    private String token;
    private List<ChunkTag> chunkTags = new ArrayList<ChunkTag>();
    private boolean isWhitespace;
    private boolean isLinebreak;
    private boolean isSentEnd;
    private boolean isSentStart;
    private boolean isParaEnd;
    private boolean isWhitespaceBefore;
    private boolean isImmunized;
    private boolean isIgnoredBySpeller;
    private String historicalAnnotations = "";
    private boolean hasSameLemmas;

    public AnalyzedTokenReadings(AnalyzedToken[] token, int startPos) {
        this.anTokReadings = (AnalyzedToken[])token.clone();
        this.startPos = startPos;
        this.init();
    }

    public AnalyzedTokenReadings(List<AnalyzedToken> tokens, int startPos) {
        this.anTokReadings = tokens.toArray(new AnalyzedToken[tokens.size()]);
        this.startPos = startPos;
        this.init();
    }

    public AnalyzedTokenReadings(AnalyzedToken token, int startPos) {
        this(token);
        this.startPos = startPos;
    }

    AnalyzedTokenReadings(AnalyzedToken token) {
        this.anTokReadings = new AnalyzedToken[1];
        this.anTokReadings[0] = token;
        this.isWhitespaceBefore = token.isWhitespaceBefore();
        this.init();
    }

    private void init() {
        this.token = this.anTokReadings[0].getToken();
        this.isWhitespace = StringTools.isWhitespace(this.token);
        this.isLinebreak = "\n".equals(this.token) || "\r\n".equals(this.token) || "\r".equals(this.token) || "\n\r".equals(this.token);
        this.isSentStart = "SENT_START".equals(this.anTokReadings[0].getPOSTag());
        this.isParaEnd = this.hasPosTag("PARA_END");
        this.isSentEnd = this.hasPosTag("SENT_END");
        this.setNoRealPOStag();
        this.hasSameLemmas = this.areLemmasSame();
    }

    public final List<AnalyzedToken> getReadings() {
        return Arrays.asList(this.anTokReadings);
    }

    public final AnalyzedToken getAnalyzedToken(int idx) {
        return this.anTokReadings[idx];
    }

    public final boolean hasPosTag(String posTag) {
        AnalyzedToken reading;
        boolean found = false;
        AnalyzedToken[] arr$ = this.anTokReadings;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (reading = arr$[i$]).getPOSTag() != null && (found = posTag.equals(reading.getPOSTag()))); ++i$) {
        }
        return found;
    }

    public final boolean hasLemma(String lemma) {
        AnalyzedToken reading;
        boolean found = false;
        AnalyzedToken[] arr$ = this.anTokReadings;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (reading = arr$[i$]).getLemma() != null && (found = lemma.equals(reading.getLemma()))); ++i$) {
        }
        return found;
    }

    public final boolean hasPartialPosTag(String posTag) {
        AnalyzedToken reading;
        boolean found = false;
        AnalyzedToken[] arr$ = this.anTokReadings;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (reading = arr$[i$]).getPOSTag() != null && (found = reading.getPOSTag().contains(posTag))); ++i$) {
        }
        return found;
    }

    public final void addReading(AnalyzedToken token) {
        ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
        l.addAll(Arrays.asList(this.anTokReadings).subList(0, this.anTokReadings.length - 1));
        if (this.anTokReadings[this.anTokReadings.length - 1].getPOSTag() != null) {
            l.add(this.anTokReadings[this.anTokReadings.length - 1]);
        }
        token.setWhitespaceBefore(this.isWhitespaceBefore);
        l.add(token);
        this.anTokReadings = l.toArray(new AnalyzedToken[l.size()]);
        if (token.getToken().length() > this.token.length()) {
            this.token = token.getToken();
        }
        this.anTokReadings[this.anTokReadings.length - 1].setWhitespaceBefore(this.isWhitespaceBefore);
        this.isParaEnd = this.hasPosTag("PARA_END");
        this.isSentEnd = this.hasPosTag("SENT_END");
        this.setNoRealPOStag();
        this.hasSameLemmas = this.areLemmasSame();
    }

    public final void removeReading(AnalyzedToken token) {
        ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
        AnalyzedToken tmpTok = new AnalyzedToken(token.getToken(), token.getPOSTag(), token.getLemma());
        tmpTok.setWhitespaceBefore(this.isWhitespaceBefore);
        for (AnalyzedToken anTokReading : this.anTokReadings) {
            if (anTokReading.matches(tmpTok)) continue;
            l.add(anTokReading);
        }
        if (l.isEmpty()) {
            l.add(new AnalyzedToken(this.token, null, null));
            ((AnalyzedToken)l.get(0)).setWhitespaceBefore(this.isWhitespaceBefore);
        }
        this.anTokReadings = l.toArray(new AnalyzedToken[l.size()]);
        this.setNoRealPOStag();
        this.hasSameLemmas = this.areLemmasSame();
    }

    public final void leaveReading(AnalyzedToken token) {
        ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
        AnalyzedToken tmpTok = new AnalyzedToken(token.getToken(), token.getPOSTag(), token.getLemma());
        tmpTok.setWhitespaceBefore(this.isWhitespaceBefore);
        for (AnalyzedToken anTokReading : this.anTokReadings) {
            if (!anTokReading.matches(tmpTok)) continue;
            l.add(anTokReading);
        }
        if (l.isEmpty()) {
            l.add(new AnalyzedToken(this.token, null, null));
            ((AnalyzedToken)l.get(0)).setWhitespaceBefore(this.isWhitespaceBefore);
        }
        this.anTokReadings = l.toArray(new AnalyzedToken[l.size()]);
        this.setNoRealPOStag();
        this.hasSameLemmas = this.areLemmasSame();
    }

    public final int getReadingsLength() {
        return this.anTokReadings.length;
    }

    public final boolean isWhitespace() {
        return this.isWhitespace;
    }

    public final boolean isLinebreak() {
        return this.isLinebreak;
    }

    public final boolean isSentenceStart() {
        return this.isSentStart;
    }

    public final boolean isParagraphEnd() {
        return this.isParaEnd;
    }

    public void setParagraphEnd() {
        if (!this.isParagraphEnd()) {
            AnalyzedToken paragraphEnd = new AnalyzedToken(this.getToken(), "PARA_END", this.getAnalyzedToken(0).getLemma());
            this.addReading(paragraphEnd);
        }
    }

    public boolean isSentenceEnd() {
        return this.isSentEnd;
    }

    public final boolean isFieldCode() {
        return "\u0001".equals(this.token) || "\u0002".equals(this.token);
    }

    public final void setSentEnd() {
        if (!this.isSentenceEnd()) {
            AnalyzedToken sentenceEnd = new AnalyzedToken(this.getToken(), "SENT_END", this.getAnalyzedToken(0).getLemma());
            this.addReading(sentenceEnd);
        }
    }

    public final int getStartPos() {
        return this.startPos;
    }

    public final void setStartPos(int position) {
        this.startPos = position;
    }

    public final String getToken() {
        return this.token;
    }

    public final void setWhitespaceBefore(boolean isWhiteSpaceBefore) {
        this.isWhitespaceBefore = isWhiteSpaceBefore;
        for (AnalyzedToken aTok : this.anTokReadings) {
            aTok.setWhitespaceBefore(isWhiteSpaceBefore);
        }
    }

    public final boolean isWhitespaceBefore() {
        return this.isWhitespaceBefore;
    }

    public final void immunize() {
        this.isImmunized = true;
    }

    public final boolean isImmunized() {
        return this.isImmunized;
    }

    public final void ignoreSpelling() {
        this.isIgnoredBySpeller = true;
    }

    public final boolean isIgnoredBySpeller() {
        return this.isIgnoredBySpeller;
    }

    private void setNoRealPOStag() {
        boolean hasNoPOStag = !this.isLinebreak();
        for (AnalyzedToken an : this.anTokReadings) {
            if ("PARA_END".equals(an.getPOSTag()) || "SENT_END".equals(an.getPOSTag()) || an.getPOSTag() == null) continue;
            hasNoPOStag = false;
        }
        for (AnalyzedToken an : this.anTokReadings) {
            an.setNoPOSTag(hasNoPOStag);
        }
    }

    public String getHistoricalAnnotations() {
        return this.historicalAnnotations;
    }

    public void setHistoricalAnnotations(String historicalAnnotations) {
        this.historicalAnnotations = historicalAnnotations;
    }

    public void setChunkTags(List<ChunkTag> chunkTags) {
        this.chunkTags = chunkTags;
    }

    public List<ChunkTag> getChunkTags() {
        return this.chunkTags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.token);
        sb.append('[');
        for (AnalyzedToken element : this.anTokReadings) {
            sb.append(element);
            if (!element.isWhitespaceBefore()) {
                sb.append('*');
            }
            sb.append(',');
        }
        sb.delete(sb.length() - 1, sb.length());
        if (this.chunkTags.size() > 0) {
            sb.append(',');
            sb.append(StringUtils.join(this.chunkTags, (String)"|"));
        }
        sb.append(']');
        if (this.isImmunized()) {
            sb.append("{!},");
        }
        return sb.toString();
    }

    public boolean isTagged() {
        for (AnalyzedToken element : this.anTokReadings) {
            if (element.hasNoTag()) continue;
            return true;
        }
        return false;
    }

    private boolean areLemmasSame() {
        String previousLemma = this.anTokReadings[0].getLemma();
        if (previousLemma == null) {
            for (AnalyzedToken element : this.anTokReadings) {
                if (element.getLemma() == null) continue;
                return false;
            }
            return true;
        }
        for (AnalyzedToken element : this.anTokReadings) {
            if (previousLemma.equals(element.getLemma())) continue;
            return false;
        }
        return true;
    }

    public boolean hasSameLemmas() {
        return this.hasSameLemmas;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.anTokReadings);
        result = 31 * result + (this.isLinebreak ? 1231 : 1237);
        result = 31 * result + (this.isParaEnd ? 1231 : 1237);
        result = 31 * result + (this.isSentEnd ? 1231 : 1237);
        result = 31 * result + (this.isSentStart ? 1231 : 1237);
        result = 31 * result + (this.isWhitespace ? 1231 : 1237);
        result = 31 * result + (this.isWhitespaceBefore ? 1231 : 1237);
        result = 31 * result + this.chunkTags.hashCode();
        result = 31 * result + this.startPos;
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalyzedTokenReadings other = (AnalyzedTokenReadings)obj;
        if (!Arrays.equals(this.anTokReadings, other.anTokReadings)) {
            return false;
        }
        if (this.isLinebreak != other.isLinebreak) {
            return false;
        }
        if (this.isParaEnd != other.isParaEnd) {
            return false;
        }
        if (this.isSentEnd != other.isSentEnd) {
            return false;
        }
        if (this.isSentStart != other.isSentStart) {
            return false;
        }
        if (this.isWhitespace != other.isWhitespace) {
            return false;
        }
        if (this.isWhitespaceBefore != other.isWhitespaceBefore) {
            return false;
        }
        if (this.isImmunized != other.isImmunized) {
            return false;
        }
        if (this.startPos != other.startPos) {
            return false;
        }
        if (!this.chunkTags.equals(other.chunkTags)) {
            return false;
        }
        if (this.hasSameLemmas != other.hasSameLemmas) {
            return false;
        }
        if (this.isIgnoredBySpeller != other.isIgnoredBySpeller) {
            return false;
        }
        return !(this.token == null ? other.token != null : !this.token.equals(other.token));
    }

    @Override
    public Iterator<AnalyzedToken> iterator() {
        final AtomicInteger i = new AtomicInteger(0);
        return new Iterator<AnalyzedToken>(){

            @Override
            public boolean hasNext() {
                return i.get() < AnalyzedTokenReadings.this.getReadingsLength();
            }

            @Override
            public AnalyzedToken next() {
                try {
                    return AnalyzedTokenReadings.this.anTokReadings[i.getAndAdd(1)];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException("No such element: " + i + ", element count: " + AnalyzedTokenReadings.this.anTokReadings.length);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

