/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.bitext.BitextRule;
import org.languagetool.rules.patterns.bitext.BitextPatternRule;
import org.languagetool.rules.patterns.bitext.BitextPatternRuleLoader;
import org.languagetool.rules.patterns.bitext.FalseFriendsAsBitextLoader;
import org.xml.sax.SAXException;

public final class Tools {
    private Tools() {
    }

    public static List<RuleMatch> checkBitext(String src, String trg, JLanguageTool srcLt, JLanguageTool trgLt, List<BitextRule> bRules) throws IOException {
        AnalyzedSentence srcText = srcLt.getAnalyzedSentence(src);
        AnalyzedSentence trgText = trgLt.getAnalyzedSentence(trg);
        List<RuleMatch> ruleMatches = trgLt.checkAnalyzedSentence(JLanguageTool.ParagraphHandling.NORMAL, trgLt.getAllRules(), 0, 0, 1, trg, trgText, null);
        for (BitextRule bRule : bRules) {
            RuleMatch[] curMatch = bRule.match(srcText, trgText);
            if (curMatch == null) continue;
            ruleMatches.addAll(Arrays.asList(curMatch));
        }
        return ruleMatches;
    }

    public static List<BitextRule> getBitextRules(Language source, Language target) throws IOException, ParserConfigurationException, SAXException {
        ArrayList<BitextRule> bRules = new ArrayList<BitextRule>();
        BitextPatternRuleLoader ruleLoader = new BitextPatternRuleLoader();
        String name = "/" + target.getShortName() + "/bitext.xml";
        InputStream is = JLanguageTool.getDataBroker().getFromRulesDirAsStream(name);
        if (is != null) {
            bRules.addAll(ruleLoader.getRules(is, name));
        }
        FalseFriendsAsBitextLoader fRuleLoader = new FalseFriendsAsBitextLoader();
        String falseFriendsFile = "/false-friends.xml";
        List<BitextPatternRule> rules = fRuleLoader.getFalseFriendsAsBitext("/false-friends.xml", source, target);
        bRules.addAll(rules);
        bRules.addAll(Tools.getAllBuiltinBitextRules(source, null));
        return bRules;
    }

    private static List<BitextRule> getAllBuiltinBitextRules(Language language, ResourceBundle messages) {
        ArrayList<BitextRule> rules = new ArrayList<BitextRule>();
        try {
            List<Class<? extends BitextRule>> classes = BitextRule.getRelevantRules();
            for (Class<? extends BitextRule> class1 : classes) {
                Object[] constructors = class1.getConstructors();
                boolean foundConstructor = false;
                for (Constructor<?> constructor : constructors) {
                    Class<?>[] paramTypes = constructor.getParameterTypes();
                    if (paramTypes.length == 0) {
                        rules.add((BitextRule)constructor.newInstance(new Object[0]));
                        foundConstructor = true;
                        break;
                    }
                    if (paramTypes.length == 1 && paramTypes[0].equals(ResourceBundle.class)) {
                        rules.add((BitextRule)constructor.newInstance(messages));
                        foundConstructor = true;
                        break;
                    }
                    if (paramTypes.length != 2 || !paramTypes[0].equals(ResourceBundle.class) || !paramTypes[1].equals(Language.class)) continue;
                    rules.add((BitextRule)constructor.newInstance(messages, language));
                    foundConstructor = true;
                    break;
                }
                if (foundConstructor) continue;
                throw new RuntimeException("Unknown constructor type for rule class " + class1.getName() + ", it supports only these constructors: " + Arrays.toString(constructors));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load bitext rules", e);
        }
        return rules;
    }

    public static int profileRulesOnLine(String contents, JLanguageTool lt, Rule rule) throws IOException {
        int count = 0;
        for (String sentence : lt.sentenceTokenize(contents)) {
            count += rule.match(lt.getAnalyzedSentence(sentence)).length;
        }
        return count;
    }

    public static String correctText(String contents, JLanguageTool lt) throws IOException {
        List<RuleMatch> ruleMatches = lt.check(contents);
        if (ruleMatches.isEmpty()) {
            return contents;
        }
        return Tools.correctTextFromMatches(contents, ruleMatches);
    }

    public static String correctTextFromMatches(String contents, List<RuleMatch> matches) {
        StringBuilder sb = new StringBuilder(contents);
        ArrayList<String> errors = new ArrayList<String>();
        for (RuleMatch rm : matches) {
            List<String> replacements = rm.getSuggestedReplacements();
            if (replacements.isEmpty()) continue;
            errors.add(sb.substring(rm.getFromPos(), rm.getToPos()));
        }
        int offset = 0;
        int counter = 0;
        for (RuleMatch rm : matches) {
            List<String> replacements = rm.getSuggestedReplacements();
            if (replacements.isEmpty()) continue;
            if (((String)errors.get(counter)).equals(sb.substring(rm.getFromPos() - offset, rm.getToPos() - offset))) {
                sb.replace(rm.getFromPos() - offset, rm.getToPos() - offset, replacements.get(0));
                offset += rm.getToPos() - rm.getFromPos() - replacements.get(0).length();
            }
            ++counter;
        }
        return sb.toString();
    }

    public static String getFullStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static InputStream getStream(String filename) throws IOException {
        InputStream is = Tools.class.getResourceAsStream(filename);
        if (is == null) {
            throw new IOException("Could not load file from classpath : " + filename);
        }
        return is;
    }

    public static void selectRules(JLanguageTool lt, String[] disabledRules, String[] enabledRules) {
        Tools.selectRules(lt, disabledRules, enabledRules, true);
    }

    public static void selectRules(JLanguageTool lt, List<String> disabledRuleIds, List<String> enabledRuleIds, boolean useEnabledOnly) {
        Tools.selectRules(lt, disabledRuleIds.toArray(new String[disabledRuleIds.size()]), enabledRuleIds.toArray(new String[enabledRuleIds.size()]), useEnabledOnly);
    }

    public static void selectRules(JLanguageTool lt, String[] disabledRules, String[] enabledRules, boolean useEnabledOnly) {
        for (String disabledRule : disabledRules) {
            lt.disableRule(disabledRule);
        }
        if (enabledRules.length > 0) {
            HashSet<String> enabledRuleIDs = new HashSet<String>(Arrays.asList(enabledRules));
            for (String ruleName : enabledRuleIDs) {
                lt.enableDefaultOffRule(ruleName);
                lt.enableRule(ruleName);
            }
            if (useEnabledOnly) {
                ArrayList<String> rulesToBeDisabled = new ArrayList<String>();
                for (Rule rule : lt.getAllRules()) {
                    if (enabledRuleIDs.contains(rule.getId())) continue;
                    rulesToBeDisabled.add(rule.getId());
                }
                lt.disableRules(rulesToBeDisabled);
            }
        }
    }
}

