/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import org.languagetool.Language;

public final class StringTools {
    private static final Pattern XML_COMMENT_PATTERN = Pattern.compile("<!--.*?-->", 32);
    private static final Pattern XML_PATTERN = Pattern.compile("(?<!<)<[^<>]+>", 32);

    private StringTools() {
    }

    public static void assureSet(String s, String varName) {
        Objects.requireNonNull(varName);
        if (StringTools.isEmpty(s.trim())) {
            throw new IllegalArgumentException(varName + " cannot be empty or whitespace only");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStream(InputStream stream, String encoding) throws IOException {
        InputStreamReader isr = null;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            isr = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
        }
        return sb.toString();
    }

    public static boolean isAllUppercase(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMixedCase(String str) {
        return !StringTools.isAllUppercase(str) && !StringTools.isCapitalizedWord(str) && StringTools.isNotAllLowercase(str);
    }

    public static boolean isNotAllLowercase(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isLetter(c) || Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCapitalizedWord(String str) {
        if (!StringTools.isEmpty(str) && Character.isUpperCase(str.charAt(0))) {
            for (int i = 1; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (!Character.isLetter(c) || Character.isLowerCase(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean startsWithUppercase(String str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        return Character.isUpperCase(str.charAt(0));
    }

    public static String uppercaseFirstChar(String str) {
        return StringTools.changeFirstCharCase(str, true);
    }

    public static String lowercaseFirstChar(String str) {
        return StringTools.changeFirstCharCase(str, false);
    }

    private static String changeFirstCharCase(String str, boolean toUpperCase) {
        int pos;
        if (StringTools.isEmpty(str)) {
            return str;
        }
        if (str.length() == 1) {
            return toUpperCase ? str.toUpperCase(Locale.ENGLISH) : str.toLowerCase();
        }
        int len = str.length() - 1;
        for (pos = 0; !Character.isLetterOrDigit(str.charAt(pos)) && len > pos; ++pos) {
        }
        char firstChar = str.charAt(pos);
        return str.substring(0, pos) + (toUpperCase ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar)) + str.substring(pos + 1);
    }

    public static String readerToString(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        int readBytes = 0;
        char[] chars = new char[4000];
        while (readBytes >= 0 && (readBytes = reader.read(chars, 0, 4000)) > 0) {
            sb.append(new String(chars, 0, readBytes));
        }
        return sb.toString();
    }

    public static String streamToString(InputStream is, String charsetName) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(is, charsetName);){
            String string = StringTools.readerToString(isr);
            return string;
        }
    }

    public static String escapeXML(String s) {
        return StringTools.escapeHTML(s);
    }

    public static String escapeHTML(String s) {
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String listToString(Collection<String> l, String delimiter) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = l.iterator();
        while (iter.hasNext()) {
            String str = iter.next();
            sb.append(str);
            if (!iter.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String trimWhitespace(String string) {
        StringBuilder filter = new StringBuilder();
        String str = string.trim();
        for (int i = 0; i < str.length(); ++i) {
            while (str.charAt(i) <= ' ' && i < str.length() && (str.charAt(i + 1) <= ' ' || i > 1 && str.charAt(i - 1) <= ' ')) {
                ++i;
            }
            char c = str.charAt(i);
            if (c == '\n' || c == '\t' || c == '\r') continue;
            filter.append(c);
        }
        return filter.toString();
    }

    public static String addSpace(String word, Language language) {
        String space = " ";
        if (word.length() == 1) {
            char c = word.charAt(0);
            if ("fr".equals(language.getShortName())) {
                if (c == '.' || c == ',') {
                    space = "";
                }
            } else if (c == '.' || c == ',' || c == ';' || c == ':' || c == '?' || c == '!') {
                space = "";
            }
        }
        return space;
    }

    public static boolean isWhitespace(String str) {
        if ("\u0002".equals(str) || "\u0001".equals(str)) {
            return false;
        }
        String trimStr = str.trim();
        if (StringTools.isEmpty(trimStr)) {
            return true;
        }
        if (trimStr.length() == 1) {
            if ("\u200b".equals(str)) {
                return true;
            }
            return Character.isWhitespace(trimStr.charAt(0));
        }
        return false;
    }

    public static boolean isNonBreakingWhitespace(String str) {
        return "\u00a0".equals(str);
    }

    public static boolean isPositiveNumber(char ch) {
        return ch >= '1' && ch <= '9';
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String filterXML(String str) {
        String s = str;
        s = XML_COMMENT_PATTERN.matcher(s).replaceAll(" ");
        s = XML_PATTERN.matcher(s).replaceAll("");
        return s;
    }

    public static String asString(CharSequence s) {
        if (s == null) {
            return null;
        }
        return s.toString();
    }

    public static enum XmlPrintMode {
        NORMAL_XML,
        START_XML,
        END_XML,
        CONTINUE_XML;

    }
}

