/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers;

import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import net.sourceforge.segment.srx.SrxDocument;
import org.languagetool.Language;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.SrxTools;

public class LocalSRXSentenceTokenizer
implements SentenceTokenizer {
    private final SrxDocument srxDocument;
    private final Language language;
    private String parCode;

    public LocalSRXSentenceTokenizer(Language language, String srxInClassPath) {
        this.language = Objects.requireNonNull(language);
        InputStream stream = this.getClass().getResourceAsStream(srxInClassPath);
        if (stream == null) {
            throw new RuntimeException("Could not find SRX file in classpath: " + srxInClassPath);
        }
        this.srxDocument = SrxTools.createSrxDocument(stream);
        this.setSingleLineBreaksMarksParagraph(false);
    }

    @Override
    public final List<String> tokenize(String text) {
        return SrxTools.tokenize(text, this.srxDocument, this.language.getShortName() + this.parCode);
    }

    @Override
    public final boolean singleLineBreaksMarksPara() {
        return "_one".equals(this.parCode);
    }

    @Override
    public final void setSingleLineBreaksMarksParagraph(boolean lineBreakParagraphs) {
        this.parCode = lineBreakParagraphs ? "_one" : "_two";
    }
}

