/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.hunspell;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.hunspell.Hunspell;

public class HunspellRule
extends SpellingCheckRule {
    public static final String RULE_ID = "HUNSPELL_RULE";
    protected boolean needsInit = true;
    protected Hunspell.Dictionary dictionary = null;
    private static final String NON_ALPHABETIC = "[^\\p{L}]";
    private Pattern nonWordPattern;

    public HunspellRule(ResourceBundle messages, Language language) {
        super(messages, language);
        super.setCategory(new Category(messages.getString("category_typo")));
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_spelling");
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (this.needsInit) {
            this.init();
        }
        if (this.dictionary == null) {
            return this.toRuleMatchArray(ruleMatches);
        }
        String[] tokens = this.tokenizeText(this.getSentenceTextWithoutUrlsAndImmunizedTokens(sentence));
        int len = sentence.getTokens()[1].getStartPos();
        for (int i = 0; i < tokens.length; ++i) {
            String word = tokens[i];
            if (this.ignoreWord(Arrays.asList(tokens), i) || this.ignoreWord(word)) {
                len += word.length() + 1;
                continue;
            }
            boolean isAlphabetic = true;
            if (word.length() == 1) {
                isAlphabetic = Character.isAlphabetic(word.charAt(0));
            }
            if (isAlphabetic && !word.equals("--") && this.dictionary.misspelled(word)) {
                RuleMatch ruleMatch = new RuleMatch(this, len, len + word.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
                List<String> suggestions = this.getSuggestions(word);
                suggestions.addAll(this.getAdditionalSuggestions(suggestions, word));
                if (!suggestions.isEmpty()) {
                    ruleMatch.setSuggestedReplacements(suggestions);
                }
                ruleMatches.add(ruleMatch);
            }
            len += word.length() + 1;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    public List<String> getSuggestions(String word) throws IOException {
        if (this.needsInit) {
            this.init();
        }
        return this.dictionary.suggest(word);
    }

    protected String[] tokenizeText(String sentence) {
        return this.nonWordPattern.split(sentence);
    }

    private String getSentenceTextWithoutUrlsAndImmunizedTokens(AnalyzedSentence sentence) {
        StringBuilder sb = new StringBuilder();
        AnalyzedTokenReadings[] sentenceTokens = sentence.getTokens();
        for (int i = 1; i < sentenceTokens.length; ++i) {
            String token = sentenceTokens[i].getToken();
            if (this.isUrl(token) || sentenceTokens[i].isImmunized() || sentenceTokens[i].isIgnoredBySpeller()) {
                for (int j = 0; j < token.length(); ++j) {
                    sb.append(' ');
                }
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    @Override
    protected void init() throws IOException {
        super.init();
        String langCountry = this.language.getCountries().length > 0 ? this.language.getShortName() + "_" + this.language.getCountries()[0] : this.language.getShortName();
        String shortDicPath = "/" + this.language.getShortName() + "/hunspell/" + langCountry + ".dic";
        String wordChars = "";
        if (JLanguageTool.getDataBroker().resourceExists(shortDicPath)) {
            String path = this.getDictionaryPath(langCountry, shortDicPath);
            if ("".equals(path)) {
                this.dictionary = null;
            } else {
                this.dictionary = Hunspell.getInstance().getDictionary(path);
                if (!"".equals(this.dictionary.getWordChars())) {
                    wordChars = "(?![" + this.dictionary.getWordChars().replace("-", "\\-") + "])";
                }
                this.dictionary.addWord("LanguageTool");
                this.dictionary.addWord("LanguageToolFx");
            }
        }
        this.nonWordPattern = Pattern.compile(wordChars + NON_ALPHABETIC);
        this.needsInit = false;
    }

    private String getDictionaryPath(String dicName, String originalPath) throws IOException {
        String dictionaryPath;
        URL dictURL = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(originalPath);
        if ("jar".equals(dictURL.getProtocol())) {
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            File tempDicFile = new File(tempDir, dicName + ".dic");
            JLanguageTool.addTemporaryFile(tempDicFile);
            this.fileCopy(JLanguageTool.getDataBroker().getFromResourceDirAsStream(originalPath), tempDicFile);
            File tempAffFile = new File(tempDir, dicName + ".aff");
            JLanguageTool.addTemporaryFile(tempAffFile);
            this.fileCopy(JLanguageTool.getDataBroker().getFromResourceDirAsStream(originalPath.replaceFirst(".dic$", ".aff")), tempAffFile);
            dictionaryPath = tempDir.getAbsolutePath() + "/" + dicName;
        } else {
            int suffixLength = ".dic".length();
            try {
                dictionaryPath = new File(dictURL.toURI()).getAbsolutePath();
                dictionaryPath = dictionaryPath.substring(0, dictionaryPath.length() - suffixLength);
            }
            catch (URISyntaxException e) {
                return "";
            }
        }
        return dictionaryPath;
    }

    private void fileCopy(InputStream in, File targetFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
        }
    }
}

