/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns.bitext;

import java.util.ArrayList;
import java.util.List;
import org.languagetool.Language;
import org.languagetool.bitext.StringPair;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.bitext.IncorrectBitextExample;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternRuleHandler;
import org.languagetool.rules.patterns.bitext.BitextPatternRule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class BitextPatternRuleHandler
extends PatternRuleHandler {
    private PatternRule srcRule;
    private PatternRule trgRule;
    private IncorrectExample trgExample;
    private IncorrectExample srcExample;
    private Language srcLang;
    private List<StringPair> correctExamples = new ArrayList<StringPair>();
    private List<IncorrectBitextExample> incorrectExamples = new ArrayList<IncorrectBitextExample>();
    private final List<BitextPatternRule> rules = new ArrayList<BitextPatternRule>();

    BitextPatternRuleHandler() {
    }

    List<BitextPatternRule> getBitextRules() {
        return this.rules;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("rules")) {
            String languageStr = attrs.getValue("targetLang");
            this.language = Language.getLanguageForShortName(languageStr);
        } else if (qName.equals("rule")) {
            super.startElement(namespaceURI, lName, qName, attrs);
            this.correctExamples = new ArrayList<StringPair>();
            this.incorrectExamples = new ArrayList<IncorrectBitextExample>();
        } else if (qName.equals("target")) {
            this.startPattern(attrs);
        } else if (qName.equals("source")) {
            this.srcLang = Language.getLanguageForShortName(attrs.getValue("lang"));
        } else {
            super.startElement(namespaceURI, lName, qName, attrs);
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (qName.equals("rule")) {
            this.trgRule.setMessage(this.message.toString());
            if (this.suggestionMatches != null) {
                for (Match m : this.suggestionMatches) {
                    this.trgRule.addSuggestionMatch(m);
                }
                if (this.phraseElementList.size() <= 1) {
                    this.suggestionMatches.clear();
                }
            }
            BitextPatternRule bRule = new BitextPatternRule(this.srcRule, this.trgRule);
            bRule.setCorrectBitextExamples(this.correctExamples);
            bRule.setIncorrectBitextExamples(this.incorrectExamples);
            bRule.setSourceLang(this.srcLang);
            this.rules.add(bRule);
        } else if (qName.equals("trgExample")) {
            this.trgExample = this.setExample();
        } else if (qName.equals("srcExample")) {
            this.srcExample = this.setExample();
        } else if (qName.equals("source")) {
            this.srcRule = this.finalizeRule();
        } else if (qName.equals("target")) {
            this.trgRule = this.finalizeRule();
        } else if (qName.equals("example")) {
            if (this.inCorrectExample) {
                this.correctExamples.add(new StringPair(this.srcExample.getExample(), this.trgExample.getExample()));
            } else if (this.inIncorrectExample) {
                StringPair examplePair = new StringPair(this.srcExample.getExample(), this.trgExample.getExample());
                if (this.trgExample.getCorrections() == null) {
                    this.incorrectExamples.add(new IncorrectBitextExample(examplePair));
                } else {
                    List<String> corrections = this.trgExample.getCorrections();
                    String[] correctionArray = corrections.toArray(new String[corrections.size()]);
                    this.incorrectExamples.add(new IncorrectBitextExample(examplePair, correctionArray));
                }
            }
            this.inCorrectExample = false;
            this.inIncorrectExample = false;
        } else {
            super.endElement(namespaceURI, sName, qName);
        }
    }

    private IncorrectExample setExample() {
        IncorrectExample example = null;
        if (this.inCorrectExample) {
            example = new IncorrectExample(this.correctExample.toString());
        } else if (this.inIncorrectExample) {
            String[] corrections = this.exampleCorrection.toString().split("\\|");
            example = corrections.length > 0 && corrections[0].length() > 0 ? new IncorrectExample(this.incorrectExample.toString(), corrections) : new IncorrectExample(this.incorrectExample.toString());
        }
        this.correctExample = new StringBuilder();
        this.incorrectExample = new StringBuilder();
        this.exampleCorrection = new StringBuilder();
        return example;
    }

    private PatternRule finalizeRule() {
        PatternRule rule = null;
        this.phraseElementInit();
        if (this.phraseElementList.isEmpty()) {
            rule = new PatternRule(this.id, this.language, this.elementList, this.name, "", this.shortMessage.toString());
            this.prepareRule(rule);
        } else {
            if (!this.elementList.isEmpty()) {
                for (List ph : this.phraseElementList) {
                    ph.addAll(new ArrayList(this.elementList));
                }
            }
            for (List phraseElement : this.phraseElementList) {
                this.processElement(phraseElement);
                rule = new PatternRule(this.id, this.language, phraseElement, this.name, this.message.toString(), this.shortMessage.toString(), "", this.phraseElementList.size() > 1);
                this.prepareRule(rule);
            }
        }
        this.elementList.clear();
        if (this.phraseElementList != null) {
            this.phraseElementList.clear();
        }
        this.startPositionCorrection = 0;
        this.endPositionCorrection = 0;
        return rule;
    }
}

