/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SymbolLocator;
import org.languagetool.tools.UnsyncStack;

public class GenericUnpairedBracketsRule
extends Rule {
    private static final Pattern NUMERALS_EN = Pattern.compile("(?i)\\d{1,2}?[a-z']*|M*(D?C{0,3}|C[DM])(L?X{0,3}|X[LC])(V?I{0,3}|I[VX])$");
    private static final Pattern PUNCTUATION = Pattern.compile("\\p{Punct}");
    private static final Pattern PUNCTUATION_NO_DOT = Pattern.compile("[ldmnst]'|[\u2013\u2014\\p{Punct}&&[^\\.]]");
    protected Pattern numerals;
    protected String[] startSymbols;
    protected String[] endSymbols;
    protected final UnsyncStack<SymbolLocator> symbolStack = new UnsyncStack();
    private final UnsyncStack<RuleMatchLocator> ruleMatchStack = new UnsyncStack();
    private boolean endOfParagraph;
    private int ruleMatchIndex;
    private Map<String, Boolean> uniqueMap;

    public GenericUnpairedBracketsRule(ResourceBundle messages, Language language) {
        super(messages);
        super.setCategory(new Category(messages.getString("category_misc")));
        this.setParagraphBackTrack(true);
        this.startSymbols = language.getUnpairedRuleStartSymbols();
        this.endSymbols = language.getUnpairedRuleEndSymbols();
        this.numerals = NUMERALS_EN;
        this.uniqueMapInit();
        this.setLocQualityIssueType(ITSIssueType.Typographical);
    }

    @Override
    public String getId() {
        return "UNPAIRED_BRACKETS";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_unpaired_brackets");
    }

    public void uniqueMapInit() {
        this.uniqueMap = new HashMap<String, Boolean>();
        for (String endSymbol : this.endSymbols) {
            int found = 0;
            for (String endSymbol1 : this.endSymbols) {
                if (!endSymbol1.equals(endSymbol)) continue;
                ++found;
            }
            this.uniqueMap.put(endSymbol, found == 1);
        }
    }

    protected boolean isNoException(String token, AnalyzedTokenReadings[] tokens, int i, int j, boolean precSpace, boolean follSpace) {
        if (i >= 2 && tokens[i - 2].getToken().equals(":") && tokens[i - 1].getToken().equals("-") && tokens[i].getToken().equals(")")) {
            return false;
        }
        return i < 2 || !tokens[i - 2].getToken().equals(";") || !tokens[i - 1].getToken().equals("-") || !tokens[i].getToken().equals(")");
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        if (this.endOfParagraph) {
            this.reset();
        }
        this.ruleMatchIndex = this.getMatchesIndex();
        block0: for (int i = 1; i < tokens.length; ++i) {
            for (int j = 0; j < this.startSymbols.length; ++j) {
                boolean followedByWhitespace;
                String token = tokens[i].getToken();
                if (!token.equals(this.startSymbols[j]) && !token.equals(this.endSymbols[j])) continue;
                boolean precededByWhitespace = this.getPrecededByWhitespace(tokens, i, j);
                boolean noException = this.isNoException(token, tokens, i, j, precededByWhitespace, followedByWhitespace = this.getFollowedByWhitespace(tokens, i, j));
                if (noException && precededByWhitespace && token.equals(this.startSymbols[j])) {
                    this.symbolStack.push(new SymbolLocator(this.startSymbols[j], i));
                    continue block0;
                }
                if (!noException || !followedByWhitespace && !tokens[i].isSentenceEnd() || !token.equals(this.endSymbols[j]) || i > 1 && this.endSymbols[j].equals(")") && this.numerals.matcher(tokens[i - 1].getToken()).matches() && (this.symbolStack.empty() || !"(".equals(this.symbolStack.peek().symbol))) continue;
                if (this.symbolStack.empty()) {
                    this.symbolStack.push(new SymbolLocator(this.endSymbols[j], i));
                    continue block0;
                }
                if (this.symbolStack.peek().symbol.equals(this.startSymbols[j])) {
                    this.symbolStack.pop();
                    continue block0;
                }
                if (this.isEndSymbolUnique(this.endSymbols[j])) {
                    this.symbolStack.push(new SymbolLocator(this.endSymbols[j], i));
                    continue block0;
                }
                if (j != this.endSymbols.length - 1) continue;
                this.symbolStack.push(new SymbolLocator(this.endSymbols[j], i));
                continue block0;
            }
        }
        for (SymbolLocator sLoc : this.symbolStack) {
            RuleMatch rMatch = this.createMatch(ruleMatches, tokens[sLoc.index].getStartPos(), sLoc.symbol);
            if (rMatch == null) continue;
            ruleMatches.add(rMatch);
        }
        this.symbolStack.clear();
        if (tokens[tokens.length - 1].isParagraphEnd()) {
            this.endOfParagraph = true;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean getPrecededByWhitespace(AnalyzedTokenReadings[] tokens, int i, int j) {
        boolean precededByWhitespace = true;
        if (this.startSymbols[j].equals(this.endSymbols[j])) {
            precededByWhitespace = tokens[i - 1].isSentenceStart() || tokens[i].isWhitespaceBefore() || PUNCTUATION_NO_DOT.matcher(tokens[i - 1].getToken()).matches();
        }
        return precededByWhitespace;
    }

    private boolean getFollowedByWhitespace(AnalyzedTokenReadings[] tokens, int i, int j) {
        boolean followedByWhitespace = true;
        if (i < tokens.length - 1 && this.startSymbols[j].equals(this.endSymbols[j])) {
            followedByWhitespace = tokens[i + 1].isWhitespaceBefore() || PUNCTUATION.matcher(tokens[i + 1].getToken()).matches();
        }
        return followedByWhitespace;
    }

    private boolean isEndSymbolUnique(String str) {
        return this.uniqueMap.get(str);
    }

    private RuleMatch createMatch(List<RuleMatch> ruleMatches, int startPos, String symbol) {
        int index;
        if (!this.ruleMatchStack.empty() && (index = this.findSymbolNum(symbol)) >= 0) {
            RuleMatchLocator rLoc = this.ruleMatchStack.peek();
            if (rLoc.symbol.equals(this.startSymbols[index])) {
                if (ruleMatches.size() > rLoc.myIndex) {
                    ruleMatches.remove(rLoc.myIndex);
                    this.ruleMatchStack.pop();
                    return null;
                }
                if (this.isInMatches(rLoc.index)) {
                    this.setAsDeleted(rLoc.index);
                    this.ruleMatchStack.pop();
                    return null;
                }
            }
        }
        this.ruleMatchStack.push(new RuleMatchLocator(symbol, this.ruleMatchIndex, ruleMatches.size()));
        ++this.ruleMatchIndex;
        return new RuleMatch(this, startPos, startPos + symbol.length(), this.messages.getString("unpaired_brackets"));
    }

    private int findSymbolNum(String ch) {
        for (int i = 0; i < this.endSymbols.length; ++i) {
            if (!ch.equals(this.endSymbols[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final void reset() {
        this.ruleMatchStack.clear();
        this.symbolStack.clear();
        this.clearMatches();
        this.endOfParagraph = false;
    }

    class RuleMatchLocator
    extends SymbolLocator {
        int myIndex;

        RuleMatchLocator(String symbol, int index, int myIndex) {
            super(symbol, index);
            this.myIndex = myIndex;
        }
    }
}

