/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class CommaWhitespaceRule
extends Rule {
    public CommaWhitespaceRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(new Category(messages.getString("category_misc")));
        this.setLocQualityIssueType(ITSIssueType.Whitespace);
    }

    @Override
    public final String getId() {
        return "COMMA_PARENTHESIS_WHITESPACE";
    }

    @Override
    public final String getDescription() {
        return this.messages.getString("desc_comma_whitespace");
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokens();
        String prevToken = "";
        String prevPrevToken = "";
        boolean prevWhite = false;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i].getToken();
            boolean isWhitespace = tokens[i].isWhitespace() || StringTools.isNonBreakingWhitespace(token) || tokens[i].isFieldCode();
            String msg = null;
            String suggestionText = null;
            if (isWhitespace && CommaWhitespaceRule.isLeftBracket(prevToken)) {
                msg = this.messages.getString("no_space_after");
                suggestionText = prevToken;
            } else if (!isWhitespace && prevToken.equals(",") && CommaWhitespaceRule.isNotQuoteOrHyphen(token) && CommaWhitespaceRule.containsNoNumber(prevPrevToken) && CommaWhitespaceRule.containsNoNumber(token) && !",".equals(prevPrevToken)) {
                msg = this.messages.getString("missing_space_after_comma");
                suggestionText = ", " + tokens[i].getToken();
            } else if (prevWhite) {
                if (CommaWhitespaceRule.isRightBracket(token)) {
                    msg = this.messages.getString("no_space_before");
                    suggestionText = token;
                } else if (token.equals(",")) {
                    msg = this.messages.getString("space_after_comma");
                    suggestionText = ",";
                    if (i + 1 < tokens.length && ",".equals(tokens[i + 1].getToken())) {
                        msg = null;
                    }
                } else if (token.equals(".")) {
                    msg = this.messages.getString("no_space_before_dot");
                    suggestionText = ".";
                    if (i + 1 < tokens.length && CommaWhitespaceRule.isNumberOrDot(tokens[i + 1].getToken())) {
                        msg = null;
                    }
                }
            }
            if (msg != null) {
                int fromPos = tokens[i - 1].getStartPos();
                int toPos = tokens[i].getStartPos() + tokens[i].getToken().length();
                RuleMatch ruleMatch = new RuleMatch(this, fromPos, toPos, msg);
                ruleMatch.setSuggestedReplacement(suggestionText);
                ruleMatches.add(ruleMatch);
            }
            prevPrevToken = prevToken;
            prevToken = token;
            prevWhite = isWhitespace && !tokens[i].isFieldCode();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    static boolean isNotQuoteOrHyphen(String str) {
        if (str.length() == 1) {
            char c = str.charAt(0);
            return c != '\'' && c != '-' && c != '\u201d' && c != '\u2019' && c != '\"' && c != '\u201c' && c != ',';
        }
        return CommaWhitespaceRule.containsNoNumber(str);
    }

    static boolean isNumberOrDot(String str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        char c = str.charAt(0);
        return c == '.' || Character.isDigit(c);
    }

    static boolean isLeftBracket(String str) {
        if (str.length() == 0) {
            return false;
        }
        char c = str.charAt(0);
        return c == '(' || c == '[' || c == '{';
    }

    static boolean isRightBracket(String str) {
        if (str.length() == 0) {
            return false;
        }
        char c = str.charAt(0);
        return c == ')' || c == ']' || c == '}';
    }

    static boolean containsNoNumber(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
    }
}

