/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public abstract class AdvancedWordRepeatRule
extends Rule {
    public AdvancedWordRepeatRule(ResourceBundle messages) {
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_misc")));
        }
        this.setDefaultOff();
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    protected abstract Set<String> getExcludedWordsPattern();

    protected abstract Pattern getExcludedNonWordsPattern();

    protected abstract Pattern getExcludedPos();

    protected abstract String getMessage();

    protected abstract String getShortMessage();

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        boolean repetition = false;
        TreeSet<String> inflectedWords = new TreeSet<String>();
        int curToken = 0;
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i].getToken();
            boolean isWord = true;
            boolean hasLemma = true;
            if (token.length() < 2) {
                isWord = false;
            }
            for (AnalyzedToken analyzedToken : tokens[i]) {
                String posTag = analyzedToken.getPOSTag();
                if (posTag != null) {
                    if (StringTools.isEmpty(posTag)) {
                        isWord = false;
                        break;
                    }
                    String lemma = analyzedToken.getLemma();
                    if (lemma == null) {
                        hasLemma = false;
                        break;
                    }
                    if (this.getExcludedWordsPattern().contains(lemma)) {
                        isWord = false;
                        break;
                    }
                    Matcher m2 = this.getExcludedPos().matcher(posTag);
                    if (!m2.matches()) continue;
                    isWord = false;
                    break;
                }
                hasLemma = false;
            }
            Matcher m1 = this.getExcludedNonWordsPattern().matcher(tokens[i].getToken());
            if (isWord && m1.matches()) {
                isWord = false;
            }
            String prevLemma = "";
            if (isWord) {
                boolean notSentEnd = false;
                for (AnalyzedToken analyzedToken : tokens[i]) {
                    String pos = analyzedToken.getPOSTag();
                    if (pos != null) {
                        notSentEnd |= "SENT_END".equals(pos);
                    }
                    if (hasLemma) {
                        String curLemma = analyzedToken.getLemma();
                        if (!prevLemma.equals(curLemma) && !notSentEnd) {
                            if (inflectedWords.contains(curLemma) && curToken != i) {
                                repetition = true;
                            } else {
                                inflectedWords.add(analyzedToken.getLemma());
                                curToken = i;
                            }
                        }
                        prevLemma = curLemma;
                        continue;
                    }
                    if (inflectedWords.contains(tokens[i].getToken()) && !notSentEnd) {
                        repetition = true;
                        continue;
                    }
                    inflectedWords.add(tokens[i].getToken());
                }
            }
            if (!repetition) continue;
            int pos = tokens[i].getStartPos();
            RuleMatch ruleMatch = new RuleMatch(this, pos, pos + token.length(), this.getMessage(), this.getShortMessage());
            ruleMatches.add(ruleMatch);
            repetition = false;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public void reset() {
    }
}

