/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.tools.ContextTools;

public final class StringTools {
    private static final int DEFAULT_CONTEXT_SIZE = 25;
    private static final Pattern XML_COMMENT_PATTERN = Pattern.compile("<!--.*?-->", 32);
    private static final Pattern XML_PATTERN = Pattern.compile("(?<!<)<[^<>]+>", 32);

    private StringTools() {
    }

    public static void assureSet(String s, String varName) {
        if (s == null) {
            throw new NullPointerException(varName + " cannot be null");
        }
        if (StringTools.isEmpty(s.trim())) {
            throw new IllegalArgumentException(varName + " cannot be empty or whitespace only");
        }
    }

    public static String readFile(InputStream file) throws IOException {
        return StringTools.readFile(file, null);
    }

    public static String readFile(InputStream stream, String encoding) throws IOException {
        return StringTools.readStream(stream, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStream(InputStream stream, String encoding) throws IOException {
        InputStreamReader isr = null;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            isr = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
        }
        return sb.toString();
    }

    public static boolean isAllUppercase(String str) {
        return str.equals(str.toUpperCase(Locale.ENGLISH));
    }

    public static boolean isMixedCase(String str) {
        return !StringTools.isAllUppercase(str) && !StringTools.isCapitalizedWord(str) && !str.equals(str.toLowerCase());
    }

    public static boolean isCapitalizedWord(String str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        char firstChar = str.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            return str.substring(1).equals(str.substring(1).toLowerCase());
        }
        return false;
    }

    public static boolean startsWithUppercase(String str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        char firstChar = str.charAt(0);
        return Character.isUpperCase(firstChar);
    }

    public static String uppercaseFirstChar(String str) {
        return StringTools.changeFirstCharCase(str, true);
    }

    public static String lowercaseFirstChar(String str) {
        return StringTools.changeFirstCharCase(str, false);
    }

    private static String changeFirstCharCase(String str, boolean toUpperCase) {
        int pos;
        if (StringTools.isEmpty(str)) {
            return str;
        }
        if (str.length() == 1) {
            return toUpperCase ? str.toUpperCase(Locale.ENGLISH) : str.toLowerCase();
        }
        int len = str.length() - 1;
        for (pos = 0; !Character.isLetterOrDigit(str.charAt(pos)) && len > pos; ++pos) {
        }
        char firstChar = str.charAt(pos);
        return str.substring(0, pos) + (toUpperCase ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar)) + str.substring(pos + 1);
    }

    public static String readerToString(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        int readBytes = 0;
        char[] chars = new char[4000];
        while (readBytes >= 0 && (readBytes = reader.read(chars, 0, 4000)) > 0) {
            sb.append(new String(chars, 0, readBytes));
        }
        return sb.toString();
    }

    public static String streamToString(InputStream is) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(is);){
            String string = StringTools.readerToString(isr);
            return string;
        }
    }

    public static String streamToString(InputStream is, String charsetName) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(is, charsetName);){
            String string = StringTools.readerToString(isr);
            return string;
        }
    }

    public static String escapeXML(String s) {
        return StringTools.escapeHTML(s);
    }

    public static String escapeHTML(String s) {
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String ruleMatchesToXML(List<RuleMatch> ruleMatches, String text, int contextSize) {
        return StringTools.ruleMatchesToXML(ruleMatches, text, contextSize, XmlPrintMode.NORMAL_XML);
    }

    public static String ruleMatchesToXML(List<RuleMatch> ruleMatches, String text, int contextSize, XmlPrintMode xmlMode, Language lang, Language motherTongue) {
        StringBuilder xml = new StringBuilder();
        if (xmlMode == XmlPrintMode.NORMAL_XML || xmlMode == XmlPrintMode.START_XML) {
            xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            xml.append("<matches software=\"LanguageTool\" version=\"2.4\" buildDate=\"").append(JLanguageTool.BUILD_DATE).append("\">\n");
        }
        if (lang != null || motherTongue != null) {
            String languageXml = "<language ";
            if (lang != null) {
                languageXml = languageXml + "shortname=\"" + lang.getShortNameWithCountryAndVariant() + "\" name=\"" + lang.getName() + "\"";
            }
            if (!(null == motherTongue || lang != null && motherTongue.getShortName().equals(lang.getShortNameWithCountryAndVariant()))) {
                languageXml = languageXml + " mothertongueshortname=\"" + motherTongue.getShortName() + "\" mothertonguename=\"" + motherTongue.getName() + "\"";
            }
            languageXml = languageXml + "/>\n";
            xml.append(languageXml);
        }
        ContextTools contextTools = new ContextTools();
        contextTools.setEscapeHtml(false);
        contextTools.setContextSize(contextSize);
        String START_MARKER = "__languagetool_start_marker";
        contextTools.setErrorMarkerStart("__languagetool_start_marker");
        contextTools.setErrorMarkerEnd("");
        for (RuleMatch match : ruleMatches) {
            String type;
            Category category;
            PatternRule pRule;
            String subId = "";
            if (match.getRule() instanceof PatternRule && (pRule = (PatternRule)match.getRule()).getSubId() != null) {
                subId = " subId=\"" + StringTools.escapeXMLForAPIOutput(pRule.getSubId()) + "\" ";
            }
            xml.append("<error fromy=\"").append(match.getLine()).append("\"").append(" fromx=\"").append(match.getColumn() - 1).append("\"").append(" toy=\"").append(match.getEndLine()).append("\"").append(" tox=\"").append(match.getEndColumn() - 1).append("\"").append(" ruleId=\"").append(match.getRule().getId()).append("\"");
            String msg = match.getMessage().replaceAll("</?suggestion>", "'");
            xml.append(subId);
            xml.append(" msg=\"").append(StringTools.escapeXMLForAPIOutput(msg)).append("\"");
            String context = contextTools.getContext(match.getFromPos(), match.getToPos(), text);
            xml.append(" replacements=\"").append(StringTools.escapeXMLForAPIOutput(StringTools.listToString(match.getSuggestedReplacements(), "#"))).append("\"");
            int contextOffset = context.indexOf("__languagetool_start_marker");
            context = context.replaceFirst("__languagetool_start_marker", "");
            context = context.replaceAll("[\n\r]", " ");
            xml.append(" context=\"").append(StringTools.escapeXML(context)).append("\"").append(" contextoffset=\"").append(contextOffset).append("\"").append(" offset=\"").append(match.getFromPos()).append("\"").append(" errorlength=\"").append(match.getToPos() - match.getFromPos()).append("\"");
            if (match.getRule().getUrl() != null) {
                xml.append(" url=\"").append(StringTools.escapeXMLForAPIOutput(match.getRule().getUrl().toString())).append("\"");
            }
            if ((category = match.getRule().getCategory()) != null) {
                xml.append(" category=\"").append(StringTools.escapeXMLForAPIOutput(category.getName())).append("\"");
            }
            if ((type = match.getRule().getLocQualityIssueType()) != null) {
                xml.append(" locqualityissuetype=\"").append(StringTools.escapeXMLForAPIOutput(type)).append("\"");
            }
            xml.append("/>\n");
        }
        if (xmlMode == XmlPrintMode.END_XML || xmlMode == XmlPrintMode.NORMAL_XML) {
            xml.append("</matches>\n");
        }
        return xml.toString();
    }

    public static String ruleMatchesToXML(List<RuleMatch> ruleMatches, String text, int contextSize, XmlPrintMode xmlMode) {
        return StringTools.ruleMatchesToXML(ruleMatches, text, contextSize, xmlMode, null, null);
    }

    private static String escapeXMLForAPIOutput(String s) {
        return StringTools.escapeXML(s).replaceAll("[\n\r]", " ");
    }

    public static String listToString(Collection<String> l, String delimiter) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = l.iterator();
        while (iter.hasNext()) {
            String str = iter.next();
            sb.append(str);
            if (!iter.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String getContext(int fromPos, int toPos, String contents) {
        ContextTools contextTools = new ContextTools();
        contextTools.setContextSize(25);
        return contextTools.getPlainTextContext(fromPos, toPos, contents);
    }

    public static String getContext(int fromPos, int toPos, String contents, int contextSize) {
        ContextTools contextTools = new ContextTools();
        contextTools.setContextSize(contextSize);
        return contextTools.getPlainTextContext(fromPos, toPos, contents);
    }

    public static String trimWhitespace(String str) {
        StringBuilder filter = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n' || c == ' ' || c == '\t' || c == '\r') continue;
            filter.append(c);
        }
        return filter.toString();
    }

    public static String addSpace(String word, Language language) {
        String space = " ";
        if (word.length() == 1) {
            char c = word.charAt(0);
            if ("fr".equals(language.getShortName())) {
                if (c == '.' || c == ',') {
                    space = "";
                }
            } else if (c == '.' || c == ',' || c == ';' || c == ':' || c == '?' || c == '!') {
                space = "";
            }
        }
        return space;
    }

    public static boolean isWhitespace(String str) {
        if ("\u0002".equals(str) || "\u0001".equals(str)) {
            return false;
        }
        String trimStr = str.trim();
        if (StringTools.isEmpty(trimStr)) {
            return true;
        }
        if (trimStr.length() == 1) {
            if ("\u200b".equals(str)) {
                return true;
            }
            return Character.isWhitespace(trimStr.charAt(0));
        }
        return false;
    }

    public static boolean isNonBreakingWhitespace(String str) {
        return "\u00a0".equals(str);
    }

    public static boolean isPositiveNumber(char ch) {
        return ch >= '1' && ch <= '9';
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String filterXML(String str) {
        String s = str;
        s = XML_COMMENT_PATTERN.matcher(s).replaceAll(" ");
        s = XML_PATTERN.matcher(s).replaceAll("");
        return s;
    }

    public static String asString(CharSequence s) {
        if (s == null) {
            return null;
        }
        return s.toString();
    }

    public static boolean isAlphabetic(int codePoint) {
        return (1086 >> Character.getType(codePoint) & 1) != 0;
    }

    public static enum XmlPrintMode {
        NORMAL_XML,
        START_XML,
        END_XML,
        CONTINUE_XML;

    }
}

