/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.rules;

import java.io.IOException;
import java.util.List;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.patterns.AbstractPatternRulePerformer;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.ElementMatcher;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.MatchState;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;

class DisambiguationPatternRuleReplacer
extends AbstractPatternRulePerformer {
    public DisambiguationPatternRuleReplacer(DisambiguationPatternRule rule) {
        super(rule, rule.getLanguage().getDisambiguationUnifier());
    }

    public final AnalyzedSentence replace(AnalyzedSentence text) throws IOException {
        List<ElementMatcher> elementMatchers = this.createElementMatchers();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        AnalyzedTokenReadings[] whTokens = text.getTokens();
        int[] tokenPositions = new int[tokens.length + 1];
        int patternSize = elementMatchers.size();
        int limit = Math.max(0, tokens.length - patternSize + 1);
        ElementMatcher elem = null;
        boolean changed = false;
        for (int i = 0; !(i >= limit || this.rule.isSentStart() && i > 0); ++i) {
            boolean allElementsMatch = false;
            this.unifiedTokens = null;
            int matchingTokens = 0;
            int skipShiftTotal = 0;
            int firstMatchToken = -1;
            int prevSkipNext = 0;
            if (this.rule.isTestUnification()) {
                this.unifier.reset();
            }
            for (int k = 0; k < patternSize; ++k) {
                ElementMatcher prevElement = elem;
                elem = elementMatchers.get(k);
                elem.resolveReference(firstMatchToken, tokens, this.rule.getLanguage());
                int nextPos = i + k + skipShiftTotal;
                this.prevMatched = false;
                if (prevSkipNext + nextPos >= tokens.length || prevSkipNext < 0) {
                    prevSkipNext = tokens.length - (nextPos + 1);
                }
                int maxTok = Math.min(nextPos + prevSkipNext, tokens.length - (patternSize - k));
                for (int m = nextPos; m <= maxTok; ++m) {
                    allElementsMatch = this.testAllReadings(tokens, elem, prevElement, m, firstMatchToken, prevSkipNext);
                    if (!allElementsMatch) continue;
                    int skipShift = m - nextPos;
                    tokenPositions[matchingTokens] = skipShift + 1;
                    prevSkipNext = elem.getElement().getSkipNext();
                    ++matchingTokens;
                    skipShiftTotal += skipShift;
                    if (firstMatchToken != -1) break;
                    firstMatchToken = m;
                    break;
                }
                if (!allElementsMatch) break;
            }
            if (!allElementsMatch || matchingTokens != patternSize) continue;
            whTokens = this.executeAction(text, whTokens, this.unifiedTokens, firstMatchToken, matchingTokens, tokenPositions);
            changed = true;
        }
        if (changed) {
            return new AnalyzedSentence(whTokens, text.getWhPositions());
        }
        return text;
    }

    private AnalyzedTokenReadings[] executeAction(AnalyzedSentence text, AnalyzedTokenReadings[] whiteTokens, AnalyzedTokenReadings[] unifiedTokens, int firstMatchToken, int matchingTokens, int[] tokenPositions) {
        AnalyzedTokenReadings[] whTokens = (AnalyzedTokenReadings[])whiteTokens.clone();
        DisambiguationPatternRule rule = (DisambiguationPatternRule)this.rule;
        int correctedStPos = 0;
        int startPositionCorrection = rule.getStartPositionCorrection();
        int endPositionCorrection = rule.getEndPositionCorrection();
        if (startPositionCorrection > 0) {
            for (int l = 0; l <= startPositionCorrection; ++l) {
                correctedStPos += tokenPositions[l];
            }
            --correctedStPos;
        }
        int fromPos = text.getOriginalPosition(firstMatchToken + correctedStPos);
        boolean spaceBefore = whTokens[fromPos].isWhitespaceBefore();
        boolean filtered = false;
        DisambiguationPatternRule.DisambiguatorAction disAction = rule.getAction();
        AnalyzedToken[] newTokenReadings = rule.getNewTokenReadings();
        Match matchElement = rule.getMatchElement();
        String disambiguatedPOS = rule.getDisambiguatedPOS();
        switch (disAction) {
            case UNIFY: {
                if (unifiedTokens == null || unifiedTokens.length != matchingTokens - startPositionCorrection + endPositionCorrection) break;
                if (whTokens[text.getOriginalPosition(firstMatchToken + correctedStPos + unifiedTokens.length - 1)].isSentenceEnd()) {
                    unifiedTokens[unifiedTokens.length - 1].setSentEnd();
                }
                for (int i = 0; i < unifiedTokens.length; ++i) {
                    int position = text.getOriginalPosition(firstMatchToken + correctedStPos + i);
                    unifiedTokens[i].setStartPos(whTokens[position].getStartPos());
                    String prevValue = whTokens[position].toString();
                    String prevAnot = whTokens[position].getHistoricalAnnotations();
                    whTokens[position] = unifiedTokens[i];
                    this.annotateChange(whTokens[position], prevValue, prevAnot);
                }
                break;
            }
            case REMOVE: {
                if (newTokenReadings == null || newTokenReadings.length != matchingTokens - startPositionCorrection + endPositionCorrection) break;
                for (int i = 0; i < newTokenReadings.length; ++i) {
                    int position = text.getOriginalPosition(firstMatchToken + correctedStPos + i);
                    String prevValue = whTokens[position].toString();
                    String prevAnot = whTokens[position].getHistoricalAnnotations();
                    whTokens[position].removeReading(newTokenReadings[i]);
                    this.annotateChange(whTokens[position], prevValue, prevAnot);
                }
                break;
            }
            case ADD: {
                if (newTokenReadings == null || newTokenReadings.length != matchingTokens - startPositionCorrection + endPositionCorrection) break;
                for (int i = 0; i < newTokenReadings.length; ++i) {
                    int position = text.getOriginalPosition(firstMatchToken + correctedStPos + i);
                    String token = "".equals(newTokenReadings[i].getToken()) ? whTokens[position].getToken() : newTokenReadings[i].getToken();
                    String lemma = newTokenReadings[i].getLemma() == null ? token : newTokenReadings[i].getLemma();
                    AnalyzedToken newTok = new AnalyzedToken(token, newTokenReadings[i].getPOSTag(), lemma);
                    String prevValue = whTokens[position].toString();
                    String prevAnot = whTokens[position].getHistoricalAnnotations();
                    whTokens[position].addReading(newTok);
                    this.annotateChange(whTokens[position], prevValue, prevAnot);
                }
                break;
            }
            case FILTERALL: {
                for (int i = 0; i < matchingTokens - startPositionCorrection + endPositionCorrection; ++i) {
                    int position = text.getOriginalPosition(firstMatchToken + correctedStPos + i);
                    Element myEl = rule.getPatternElements().get(i + startPositionCorrection);
                    Match tmpMatchToken = new Match(myEl.getPOStag(), null, true, myEl.getPOStag(), null, Match.CaseConversion.NONE, false, false, Match.IncludeRange.NONE);
                    MatchState matchState = tmpMatchToken.createState(rule.getLanguage().getSynthesizer(), whTokens[position]);
                    String prevValue = whTokens[position].toString();
                    String prevAnot = whTokens[position].getHistoricalAnnotations();
                    whTokens[position] = matchState.filterReadings();
                    this.annotateChange(whTokens[position], prevValue, prevAnot);
                }
                break;
            }
            case IMMUNIZE: {
                for (int i = 0; i < matchingTokens - startPositionCorrection + endPositionCorrection; ++i) {
                    whTokens[text.getOriginalPosition(firstMatchToken + correctedStPos + i)].immunize();
                }
                break;
            }
            case FILTER: {
                if (matchElement == null) {
                    Match tmpMatchToken = new Match(disambiguatedPOS, null, true, disambiguatedPOS, null, Match.CaseConversion.NONE, false, false, Match.IncludeRange.NONE);
                    MatchState matchState = tmpMatchToken.createState(rule.getLanguage().getSynthesizer(), whTokens[fromPos]);
                    String prevValue = whTokens[fromPos].toString();
                    String prevAnot = whTokens[fromPos].getHistoricalAnnotations();
                    whTokens[fromPos] = matchState.filterReadings();
                    this.annotateChange(whTokens[fromPos], prevValue, prevAnot);
                    filtered = true;
                }
            }
            default: {
                if (filtered) break;
                if (newTokenReadings != null && newTokenReadings.length > 0) {
                    if (newTokenReadings.length != matchingTokens - startPositionCorrection + endPositionCorrection) break;
                    for (int i = 0; i < newTokenReadings.length; ++i) {
                        int position = text.getOriginalPosition(firstMatchToken + correctedStPos + i);
                        String token = "".equals(newTokenReadings[i].getToken()) ? whTokens[position].getToken() : newTokenReadings[i].getToken();
                        String lemma = newTokenReadings[i].getLemma() == null ? token : newTokenReadings[i].getLemma();
                        AnalyzedToken analyzedToken = new AnalyzedToken(token, newTokenReadings[i].getPOSTag(), lemma);
                        AnalyzedTokenReadings toReplace = new AnalyzedTokenReadings(analyzedToken, whTokens[fromPos].getStartPos());
                        whTokens[position] = this.replaceTokens(whTokens[position], toReplace);
                    }
                    break;
                }
                if (matchElement == null) {
                    String lemma = "";
                    for (AnalyzedToken analyzedToken : whTokens[fromPos]) {
                        if (analyzedToken.getPOSTag() == null || !analyzedToken.getPOSTag().equals(disambiguatedPOS) || analyzedToken.getLemma() == null) continue;
                        lemma = analyzedToken.getLemma();
                    }
                    if (StringTools.isEmpty(lemma)) {
                        lemma = whTokens[fromPos].getAnalyzedToken(0).getLemma();
                    }
                    AnalyzedToken analyzedToken = new AnalyzedToken(whTokens[fromPos].getToken(), disambiguatedPOS, lemma);
                    AnalyzedTokenReadings toReplace = new AnalyzedTokenReadings(analyzedToken, whTokens[fromPos].getStartPos());
                    whTokens[fromPos] = this.replaceTokens(whTokens[fromPos], toReplace);
                    break;
                }
                MatchState matchElementState = matchElement.createState(rule.getLanguage().getSynthesizer(), whTokens[fromPos]);
                String prevValue = whTokens[fromPos].toString();
                String prevAnot = whTokens[fromPos].getHistoricalAnnotations();
                whTokens[fromPos] = matchElementState.filterReadings();
                whTokens[fromPos].setWhitespaceBefore(spaceBefore);
                this.annotateChange(whTokens[fromPos], prevValue, prevAnot);
            }
        }
        return whTokens;
    }

    private void annotateChange(AnalyzedTokenReadings atr, String prevValue, String prevAnot) {
        atr.setHistoricalAnnotations(prevAnot + "\n" + this.rule.getId() + ":" + this.rule.getSubId() + " " + prevValue + " -> " + atr.toString());
    }

    private AnalyzedTokenReadings replaceTokens(AnalyzedTokenReadings oldAtr, AnalyzedTokenReadings newAtr) {
        String prevValue = oldAtr.toString();
        String prevAnot = oldAtr.getHistoricalAnnotations();
        boolean isSentEnd = oldAtr.isSentenceEnd();
        boolean isParaEnd = oldAtr.isParagraphEnd();
        boolean spaceBefore = oldAtr.isWhitespaceBefore();
        int startPosition = oldAtr.getStartPos();
        List<ChunkTag> chunkTags = oldAtr.getChunkTags();
        if (isSentEnd) {
            newAtr.setSentEnd();
        }
        if (isParaEnd) {
            newAtr.setParagraphEnd();
        }
        newAtr.setWhitespaceBefore(spaceBefore);
        newAtr.setStartPos(startPosition);
        newAtr.setChunkTags(chunkTags);
        this.annotateChange(newAtr, prevValue, prevAnot);
        return newAtr;
    }
}

