/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.rules;

import java.io.IOException;
import java.util.List;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.Language;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.Match;
import org.languagetool.tagging.disambiguation.rules.DisambiguatedExample;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRuleReplacer;

public class DisambiguationPatternRule
extends AbstractPatternRule {
    private final String disambiguatedPOS;
    private final Match matchElement;
    private final DisambiguatorAction disAction;
    private AnalyzedToken[] newTokenReadings;
    private List<DisambiguatedExample> examples;
    private List<String> untouchedExamples;

    DisambiguationPatternRule(String id, String description, Language language, List<Element> elements, String disamb, Match posSelect, DisambiguatorAction disambAction) {
        super(id, description, language, elements, true);
        if (disamb == null && posSelect == null && disambAction != DisambiguatorAction.UNIFY && disambAction != DisambiguatorAction.ADD && disambAction != DisambiguatorAction.REMOVE && disambAction != DisambiguatorAction.IMMUNIZE && disambAction != DisambiguatorAction.REPLACE && disambAction != DisambiguatorAction.FILTERALL) {
            throw new NullPointerException("disambiguated POS cannot be null");
        }
        this.disambiguatedPOS = disamb;
        this.matchElement = posSelect;
        this.disAction = disambAction;
    }

    public final void setNewInterpretations(AnalyzedToken[] newReadings) {
        this.newTokenReadings = (AnalyzedToken[])newReadings.clone();
    }

    public final AnalyzedSentence replace(AnalyzedSentence text) throws IOException {
        DisambiguationPatternRuleReplacer replacer = new DisambiguationPatternRuleReplacer(this);
        return replacer.replace(text);
    }

    public void setExamples(List<DisambiguatedExample> examples) {
        this.examples = examples;
    }

    public List<DisambiguatedExample> getExamples() {
        return this.examples;
    }

    public void setUntouchedExamples(List<String> untouchedExamples) {
        this.untouchedExamples = untouchedExamples;
    }

    public List<String> getUntouchedExamples() {
        return this.untouchedExamples;
    }

    public final List<Element> getElements() {
        return this.patternElements;
    }

    public DisambiguatorAction getAction() {
        return this.disAction;
    }

    public AnalyzedToken[] getNewTokenReadings() {
        return this.newTokenReadings;
    }

    public Match getMatchElement() {
        return this.matchElement;
    }

    public String getDisambiguatedPOS() {
        return this.disambiguatedPOS;
    }

    public static enum DisambiguatorAction {
        ADD,
        FILTER,
        REMOVE,
        REPLACE,
        UNIFY,
        IMMUNIZE,
        FILTERALL;

    }
}

