/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.tagging.Tagger;
import org.languagetool.tools.StringTools;

public abstract class BaseTagger
implements Tagger {
    protected Locale conversionLocale = Locale.getDefault();
    private boolean tagLowercaseWithUppercase = true;
    private Dictionary dictionary;

    public abstract String getFileName();

    public void setLocale(Locale locale) {
        this.conversionLocale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dictionary getDictionary() throws IOException {
        if (this.dictionary == null) {
            BaseTagger baseTagger = this;
            synchronized (baseTagger) {
                if (this.dictionary == null) {
                    URL url = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(this.getFileName());
                    this.dictionary = Dictionary.read((URL)url);
                }
            }
        }
        return this.dictionary;
    }

    @Override
    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        DictionaryLookup dictLookup = new DictionaryLookup(this.getDictionary());
        for (String word : sentenceTokens) {
            List<AnalyzedToken> upperTaggerTokens;
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String lowerWord = word.toLowerCase(this.conversionLocale);
            List<AnalyzedToken> taggerTokens = this.asAnalyzedTokenList(word, dictLookup.lookup((CharSequence)word));
            List<AnalyzedToken> lowerTaggerTokens = this.asAnalyzedTokenList(word, dictLookup.lookup((CharSequence)lowerWord));
            boolean isLowercase = word.equals(lowerWord);
            boolean isMixedCase = StringTools.isMixedCase(word);
            this.addTokens(taggerTokens, l);
            if (!isLowercase && !isMixedCase) {
                this.addTokens(lowerTaggerTokens, l);
            }
            if (this.tagLowercaseWithUppercase && lowerTaggerTokens.isEmpty() && taggerTokens.isEmpty() && isLowercase && !(upperTaggerTokens = this.asAnalyzedTokenList(word, dictLookup.lookup((CharSequence)StringTools.uppercaseFirstChar(word)))).isEmpty()) {
                this.addTokens(upperTaggerTokens, l);
            }
            if (l.isEmpty()) {
                List<AnalyzedToken> additionalTaggedTokens = this.additionalTags(word);
                this.addTokens(additionalTaggedTokens, l);
            }
            if (l.isEmpty()) {
                l.add(new AnalyzedToken(word, null, null));
            }
            tokenReadings.add(new AnalyzedTokenReadings(l, pos));
            pos += word.length();
        }
        return tokenReadings;
    }

    protected List<AnalyzedToken> asAnalyzedTokenList(String word, List<WordData> wdList) {
        ArrayList<AnalyzedToken> aTokenList = new ArrayList<AnalyzedToken>();
        for (WordData wd : wdList) {
            aTokenList.add(this.asAnalyzedToken(word, wd));
        }
        return aTokenList;
    }

    protected AnalyzedToken asAnalyzedToken(String word, WordData wd) {
        String tag = StringTools.asString(wd.getTag());
        if (this.dictionary.metadata.isFrequencyIncluded() && tag.length() > 2) {
            tag = tag.substring(0, tag.length() - 2);
        }
        return new AnalyzedToken(word, tag, StringTools.asString(wd.getStem()));
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            for (AnalyzedToken at : taggedTokens) {
                l.add(at);
            }
        }
    }

    @Override
    public final AnalyzedTokenReadings createNullToken(String token, int startPos) {
        return new AnalyzedTokenReadings(new AnalyzedToken(token, null, null), startPos);
    }

    @Override
    public AnalyzedToken createToken(String token, String posTag) {
        return new AnalyzedToken(token, posTag, null);
    }

    public void dontTagLowercaseWithUppercase() {
        this.tagLowercaseWithUppercase = false;
    }

    public List<AnalyzedToken> additionalTags(String word) {
        return null;
    }
}

