/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import org.languagetool.AnalyzedToken;
import org.languagetool.JLanguageTool;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.SynthesizerTools;

public class BaseSynthesizer
implements Synthesizer {
    protected List<String> possibleTags;
    private final String tagFileName;
    private final String resourceFileName;
    private Dictionary dictionary;

    public BaseSynthesizer(String resourceFileName, String tagFileName) {
        this.resourceFileName = resourceFileName;
        this.tagFileName = tagFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dictionary getDictionary() throws IOException {
        if (this.dictionary == null) {
            BaseSynthesizer baseSynthesizer = this;
            synchronized (baseSynthesizer) {
                if (this.dictionary == null) {
                    URL url = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(this.resourceFileName);
                    this.dictionary = Dictionary.read((URL)url);
                }
            }
        }
        return this.dictionary;
    }

    protected IStemmer createStemmer() {
        try {
            Dictionary dict = this.getDictionary();
            return new DictionaryLookup(dict);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load dictionary", e);
        }
    }

    protected void lookup(String lemma, String posTag, List<String> results) {
        IStemmer stemmer = this.createStemmer();
        List wordForms = stemmer.lookup((CharSequence)(lemma + "|" + posTag));
        for (WordData wd : wordForms) {
            results.add(wd.getStem().toString());
        }
    }

    @Override
    public String[] synthesize(AnalyzedToken token, String posTag) throws IOException {
        this.initSynthesizer();
        ArrayList<String> wordForms = new ArrayList<String>();
        this.lookup(token.getLemma(), posTag, wordForms);
        return wordForms.toArray(new String[wordForms.size()]);
    }

    @Override
    public String[] synthesize(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        if (posTagRegExp) {
            this.initSynthesizer();
            this.initPossibleTags();
            Pattern p = Pattern.compile(posTag);
            ArrayList<String> results = new ArrayList<String>();
            for (String tag : this.possibleTags) {
                Matcher m = p.matcher(tag);
                if (!m.matches()) continue;
                this.lookup(token.getLemma(), tag, results);
            }
            return results.toArray(new String[results.size()]);
        }
        return this.synthesize(token, posTag);
    }

    @Override
    public String getPosTagCorrection(String posTag) {
        return posTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPossibleTags() throws IOException {
        if (this.possibleTags == null) {
            BaseSynthesizer baseSynthesizer = this;
            synchronized (baseSynthesizer) {
                if (this.possibleTags == null) {
                    this.possibleTags = SynthesizerTools.loadWords(JLanguageTool.getDataBroker().getFromResourceDirAsStream(this.tagFileName));
                }
            }
        }
    }

    protected void initSynthesizer() throws IOException {
    }
}

