/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;

public abstract class MorfologikSpellerRule
extends SpellingCheckRule {
    protected MorfologikSpeller speller;
    protected Locale conversionLocale;
    private boolean ignoreTaggedWords = false;
    private boolean checkCompound = false;
    private Pattern compoundRegex = Pattern.compile("-");

    public abstract String getFileName();

    public MorfologikSpellerRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        super.setCategory(new Category(messages.getString("category_typo")));
        this.conversionLocale = this.conversionLocale != null ? this.conversionLocale : Locale.getDefault();
        this.init();
        this.setLocQualityIssueType("misspelling");
    }

    @Override
    public abstract String getId();

    @Override
    public String getDescription() {
        return this.messages.getString("desc_spelling");
    }

    public void setLocale(Locale locale) {
        this.conversionLocale = locale;
    }

    public void setIgnoreTaggedWords() {
        this.ignoreTaggedWords = true;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence text) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        if (this.speller == null) {
            if (JLanguageTool.getDataBroker().resourceExists(this.getFileName())) {
                this.speller = new MorfologikSpeller(this.getFileName(), this.conversionLocale);
            } else {
                return this.toRuleMatchArray(ruleMatches);
            }
        }
        int idx = -1;
        for (AnalyzedTokenReadings token : tokens) {
            if (token.isSentenceStart() || this.isUrl(token.getToken()) || this.ignoreToken(tokens, ++idx) || token.isImmunized() || this.ignoreTaggedWords && token.isTagged()) continue;
            String word = token.getToken();
            if (this.tokenizingPattern() == null) {
                ruleMatches.addAll(this.getRuleMatch(word, token.getStartPos()));
                continue;
            }
            int index = 0;
            Matcher m = this.tokenizingPattern().matcher(word);
            while (m.find()) {
                String match = word.subSequence(index, m.start()).toString();
                ruleMatches.addAll(this.getRuleMatch(match, token.getStartPos() + index));
                index = m.end();
            }
            if (index == 0) {
                ruleMatches.addAll(this.getRuleMatch(word, token.getStartPos()));
                continue;
            }
            ruleMatches.addAll(this.getRuleMatch(word.subSequence(index, word.length()).toString(), token.getStartPos() + index));
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    protected boolean isMisspelled(MorfologikSpeller speller, String word) {
        if (!speller.isMisspelled(word)) {
            return false;
        }
        if (this.checkCompound && this.compoundRegex.matcher(word).find()) {
            String[] words;
            for (String singleWord : words = this.compoundRegex.split(word)) {
                if (!speller.isMisspelled(singleWord)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private List<RuleMatch> getRuleMatch(String word, int startPos) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (this.isMisspelled(this.speller, word)) {
            RuleMatch ruleMatch = new RuleMatch(this, startPos, startPos + word.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
            if (!this.isMisspelled(this.speller, word.toLowerCase(this.conversionLocale))) {
                List<String> suggestion = Arrays.asList(word.toLowerCase(this.conversionLocale));
                ruleMatch.setSuggestedReplacements(suggestion);
                ruleMatches.add(ruleMatch);
                return ruleMatches;
            }
            List<String> suggestions = this.speller.getSuggestions(word);
            if (!(suggestions = this.getAdditionalSuggestions(suggestions, word)).isEmpty()) {
                ruleMatch.setSuggestedReplacements(this.orderSuggestions(suggestions, word));
            }
            ruleMatches.add(ruleMatch);
        }
        return ruleMatches;
    }

    public Pattern tokenizingPattern() {
        return null;
    }

    protected List<String> getAdditionalSuggestions(List<String> suggestions, String word) {
        return suggestions;
    }

    protected List<String> orderSuggestions(List<String> suggestions, String word) {
        return suggestions;
    }

    protected void setCheckCompound(boolean checkCompound) {
        this.checkCompound = checkCompound;
    }

    protected void setCompoundRegex(String compoundRegex) {
        this.compoundRegex = Pattern.compile(compoundRegex);
    }
}

