/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.languagetool.Language;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.tools.StringTools;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLRuleHandler
extends DefaultHandler {
    protected List<PatternRule> rules = new ArrayList<PatternRule>();
    protected Language language;
    protected StringBuilder correctExample = new StringBuilder();
    protected StringBuilder incorrectExample = new StringBuilder();
    protected StringBuilder exampleCorrection = new StringBuilder();
    protected StringBuilder message = new StringBuilder();
    protected StringBuilder suggestionsOutMsg = new StringBuilder();
    protected StringBuilder match = new StringBuilder();
    protected StringBuilder elements;
    protected StringBuilder exceptions;
    protected List<String> correctExamples = new ArrayList<String>();
    protected List<IncorrectExample> incorrectExamples = new ArrayList<IncorrectExample>();
    protected boolean inPattern;
    protected boolean inCorrectExample;
    protected boolean inIncorrectExample;
    protected boolean inMessage;
    protected boolean inSuggestion;
    protected boolean inMatch;
    protected boolean inRuleGroup;
    protected boolean inToken;
    protected boolean inException;
    protected boolean inPhrases;
    protected boolean inAndGroup;
    protected boolean inOrGroup;
    protected boolean tokenSpaceBefore;
    protected boolean tokenSpaceBeforeSet;
    protected String posToken;
    protected ChunkTag chunkTag;
    protected boolean posNegation;
    protected boolean posRegExp;
    protected boolean caseSensitive;
    protected boolean regExpression;
    protected boolean tokenNegated;
    protected boolean tokenInflected;
    protected String exceptionPosToken;
    protected boolean exceptionStringRegExp;
    protected boolean exceptionStringNegation;
    protected boolean exceptionStringInflected;
    protected boolean exceptionPosNegation;
    protected boolean exceptionPosRegExp;
    protected boolean exceptionValidNext;
    protected boolean exceptionValidPrev;
    protected boolean exceptionSet;
    protected boolean exceptionSpaceBefore;
    protected boolean exceptionSpaceBeforeSet;
    protected List<Element> elementList;
    protected boolean lastPhrase;
    protected String phraseIdRef;
    protected String phraseId;
    protected int skipPos;
    protected int minOccurrence = 1;
    protected int maxOccurrence = 1;
    protected String ruleGroupId;
    protected String id;
    protected Element tokenElement;
    protected Match tokenReference;
    protected List<Match> suggestionMatches;
    protected List<Match> suggestionMatchesOutMsg;
    protected Locator pLocator;
    protected int startPositionCorrection;
    protected int endPositionCorrection;
    protected int tokenCounter;
    protected Map<String, List<List<Element>>> phraseMap;
    protected List<ArrayList<Element>> phraseElementList;
    protected int andGroupCounter;
    protected int orGroupCounter;
    protected StringBuilder shortMessage = new StringBuilder();
    protected StringBuilder url = new StringBuilder();
    protected boolean inShortMessage;
    protected boolean inUrl;
    protected boolean inUnification;
    protected boolean inMarker;
    protected boolean inUnificationDef;
    protected boolean uniNegation;
    protected String uFeature;
    protected String uType = "";
    protected List<String> uTypeList;
    protected Map<String, List<String>> equivalenceFeatures;
    protected static final String YES = "yes";
    protected static final String POSTAG = "postag";
    protected static final String CHUNKTAG = "chunk";
    protected static final String POSTAG_REGEXP = "postag_regexp";
    protected static final String REGEXP = "regexp";
    protected static final String NEGATE = "negate";
    protected static final String INFLECTED = "inflected";
    protected static final String NEGATE_POS = "negate_pos";
    protected static final String MARKER = "marker";
    protected static final String DEFAULT = "default";
    protected static final String TYPE = "type";
    protected static final String SPACEBEFORE = "spacebefore";
    protected static final String EXAMPLE = "example";
    protected static final String SCOPE = "scope";
    protected static final String IGNORE = "ignore";
    protected static final String SKIP = "skip";
    protected static final String MIN = "min";
    protected static final String MAX = "max";
    protected static final String TOKEN = "token";
    protected static final String FEATURE = "feature";
    protected static final String UNIFY = "unify";
    protected static final String AND = "and";
    protected static final String OR = "or";
    protected static final String EXCEPTION = "exception";
    protected static final String CASE_SENSITIVE = "case_sensitive";
    protected static final String PATTERN = "pattern";
    protected static final String MATCH = "match";
    protected static final String UNIFICATION = "unification";
    protected static final String RULE = "rule";
    protected static final String RULEGROUP = "rulegroup";
    protected static final String NO = "no";
    protected static final String PHRASES = "phrases";
    protected static final String MESSAGE = "message";
    protected static final String SUGGESTION = "suggestion";

    public XMLRuleHandler() {
        this.elementList = new ArrayList<Element>();
        this.equivalenceFeatures = new HashMap<String, List<String>>();
        this.uTypeList = new ArrayList<String>();
    }

    public List<PatternRule> getRules() {
        return this.rules;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.pLocator = locator;
        super.setDocumentLocator(locator);
    }

    protected void resetToken() {
        this.posNegation = false;
        this.posRegExp = false;
        this.inToken = false;
        this.tokenSpaceBefore = false;
        this.tokenSpaceBeforeSet = false;
        this.resetException();
        this.exceptionSet = false;
        this.tokenReference = null;
    }

    protected void resetException() {
        this.exceptionStringNegation = false;
        this.exceptionStringInflected = false;
        this.exceptionPosNegation = false;
        this.exceptionPosRegExp = false;
        this.exceptionStringRegExp = false;
        this.exceptionValidNext = false;
        this.exceptionValidPrev = false;
        this.exceptionSpaceBefore = false;
        this.exceptionSpaceBeforeSet = false;
    }

    protected void phraseElementInit() {
        if (this.phraseElementList == null) {
            this.phraseElementList = new ArrayList<ArrayList<Element>>();
        }
    }

    protected void preparePhrase(Attributes attrs) {
        this.phraseIdRef = attrs.getValue("idref");
        if (this.phraseMap.containsKey(this.phraseIdRef)) {
            for (List<Element> curPhrEl : this.phraseMap.get(this.phraseIdRef)) {
                for (Element e : curPhrEl) {
                    e.setPhraseName(this.phraseIdRef);
                }
                List copy = (List)ObjectUtils.clone(curPhrEl);
                for (Element element : copy) {
                    element.setInsideMarker(this.inMarker);
                }
                if (this.elementList.isEmpty()) {
                    this.phraseElementList.add(new ArrayList(copy));
                    continue;
                }
                ArrayList<Element> prevList = new ArrayList<Element>(this.elementList);
                prevList.addAll(copy);
                this.phraseElementList.add(new ArrayList<Element>(prevList));
                prevList.clear();
            }
            this.lastPhrase = true;
        }
    }

    protected void finalizePhrase() {
        if (this.phraseMap == null) {
            this.phraseMap = new HashMap<String, List<List<Element>>>();
        }
        this.phraseElementInit();
        for (Element element : this.elementList) {
            element.setInsideMarker(this.inMarker);
        }
        if (this.phraseElementList.isEmpty()) {
            this.phraseElementList.add(new ArrayList<Element>(this.elementList));
        } else {
            for (ArrayList arrayList : this.phraseElementList) {
                arrayList.addAll(new ArrayList<Element>(this.elementList));
            }
        }
        this.phraseMap.put(this.phraseId, new ArrayList<ArrayList<Element>>(this.phraseElementList));
        this.elementList.clear();
        this.phraseElementList.clear();
    }

    protected void startPattern(Attributes attrs) throws SAXException {
        this.tokenCounter = 0;
        this.inPattern = true;
        this.caseSensitive = YES.equals(attrs.getValue(CASE_SENSITIVE));
    }

    protected void processElement(List<Element> elList) {
        int counter = 0;
        for (Element elTest : elList) {
            if (elTest.getPhraseName() != null && counter > 0 && elTest.isReferenceElement()) {
                int tokRef = elTest.getMatch().getTokenRef();
                elTest.getMatch().setTokenRef(tokRef + counter - 1);
                String offsetToken = elTest.getString().replace("\\" + tokRef, "\\" + (tokRef + counter - 1));
                elTest.setStringElement(offsetToken);
            }
            ++counter;
        }
    }

    protected void setMatchElement(Attributes attrs) throws SAXException {
        this.inMatch = true;
        this.match = new StringBuilder();
        Match.CaseConversion caseConversion = Match.CaseConversion.NONE;
        if (attrs.getValue("case_conversion") != null) {
            caseConversion = Match.CaseConversion.valueOf(attrs.getValue("case_conversion").toUpperCase(Locale.ENGLISH));
        }
        Match.IncludeRange includeRange = Match.IncludeRange.NONE;
        if (attrs.getValue("include_skipped") != null) {
            includeRange = Match.IncludeRange.valueOf(attrs.getValue("include_skipped").toUpperCase(Locale.ENGLISH));
        }
        Match mWorker = new Match(attrs.getValue(POSTAG), attrs.getValue("postag_replace"), YES.equals(attrs.getValue(POSTAG_REGEXP)), attrs.getValue("regexp_match"), attrs.getValue("regexp_replace"), caseConversion, YES.equals(attrs.getValue("setpos")), YES.equals(attrs.getValue("suppress_misspelled")), includeRange);
        mWorker.setInMessageOnly(!this.inSuggestion);
        if (this.inMessage) {
            if (this.suggestionMatches == null) {
                this.suggestionMatches = new ArrayList<Match>();
            }
            this.suggestionMatches.add(mWorker);
            this.message.append("\u0001\\");
            this.message.append(attrs.getValue(NO));
            this.checkNumber(attrs);
        } else if (this.inSuggestion && !this.inMessage) {
            if (this.suggestionMatchesOutMsg == null) {
                this.suggestionMatchesOutMsg = new ArrayList<Match>();
            }
            this.suggestionMatchesOutMsg.add(mWorker);
            this.suggestionsOutMsg.append("\u0001\\");
            this.suggestionsOutMsg.append(attrs.getValue(NO));
            this.checkNumber(attrs);
        } else if (this.inToken && attrs.getValue(NO) != null) {
            int refNumber = Integer.parseInt(attrs.getValue(NO));
            this.checkRefNumber(refNumber);
            mWorker.setTokenRef(refNumber);
            this.tokenReference = mWorker;
            this.elements.append('\\');
            this.elements.append(refNumber);
        }
    }

    private void checkNumber(Attributes attrs) throws SAXException {
        if (StringTools.isEmpty(attrs.getValue(NO))) {
            throw new SAXException("References cannot be empty: \n Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
        }
        if (Integer.parseInt(attrs.getValue(NO)) < 1) {
            throw new SAXException("References must be larger than 0: " + attrs.getValue(NO) + "\n Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
        }
    }

    private void checkRefNumber(int refNumber) throws SAXException {
        if (refNumber > this.elementList.size()) {
            throw new SAXException("Only backward references in match elements are possible, tried to specify token " + refNumber + "\n" + "Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
        }
    }

    protected void setExceptions(Attributes attrs) {
        this.inException = true;
        this.exceptions = new StringBuilder();
        this.resetException();
        this.exceptionStringNegation = YES.equals(attrs.getValue(NEGATE));
        this.exceptionValidNext = "next".equals(attrs.getValue(SCOPE));
        this.exceptionValidPrev = "previous".equals(attrs.getValue(SCOPE));
        this.exceptionStringInflected = YES.equals(attrs.getValue(INFLECTED));
        if (attrs.getValue(POSTAG) != null) {
            this.exceptionPosToken = attrs.getValue(POSTAG);
            this.exceptionPosRegExp = YES.equals(attrs.getValue(POSTAG_REGEXP));
            this.exceptionPosNegation = YES.equals(attrs.getValue(NEGATE_POS));
        }
        this.exceptionStringRegExp = YES.equals(attrs.getValue(REGEXP));
        if (attrs.getValue(SPACEBEFORE) != null) {
            this.exceptionSpaceBefore = YES.equals(attrs.getValue(SPACEBEFORE));
            this.exceptionSpaceBeforeSet = !IGNORE.equals(attrs.getValue(SPACEBEFORE));
        }
    }

    protected void finalizeExceptions() {
        this.inException = false;
        if (!this.exceptionSet) {
            this.tokenElement = new Element(StringTools.trimWhitespace(this.elements.toString()), this.caseSensitive, this.regExpression, this.tokenInflected);
            this.exceptionSet = true;
        }
        this.tokenElement.setNegation(this.tokenNegated);
        if (!StringTools.isEmpty(this.exceptions.toString()) || this.exceptionPosToken != null) {
            this.tokenElement.setStringPosException(StringTools.trimWhitespace(this.exceptions.toString()), this.exceptionStringRegExp, this.exceptionStringInflected, this.exceptionStringNegation, this.exceptionValidNext, this.exceptionValidPrev, this.exceptionPosToken, this.exceptionPosRegExp, this.exceptionPosNegation);
            this.exceptionPosToken = null;
        }
        if (this.exceptionSpaceBeforeSet) {
            this.tokenElement.setExceptionSpaceBefore(this.exceptionSpaceBefore);
        }
        this.resetException();
    }

    protected void setToken(Attributes attrs) {
        this.inToken = true;
        if (this.lastPhrase) {
            this.elementList.clear();
        }
        this.lastPhrase = false;
        this.tokenNegated = YES.equals(attrs.getValue(NEGATE));
        this.tokenInflected = YES.equals(attrs.getValue(INFLECTED));
        if (attrs.getValue(SKIP) != null) {
            this.skipPos = Integer.parseInt(attrs.getValue(SKIP));
        }
        if (attrs.getValue(MIN) != null) {
            this.minOccurrence = Integer.parseInt(attrs.getValue(MIN));
        }
        if (attrs.getValue(MAX) != null) {
            this.maxOccurrence = Integer.parseInt(attrs.getValue(MAX));
        }
        this.elements = new StringBuilder();
        if (attrs.getValue(POSTAG) != null) {
            this.posToken = attrs.getValue(POSTAG);
            this.posRegExp = YES.equals(attrs.getValue(POSTAG_REGEXP));
            this.posNegation = YES.equals(attrs.getValue(NEGATE_POS));
        }
        if (attrs.getValue(CHUNKTAG) != null) {
            this.chunkTag = new ChunkTag(attrs.getValue(CHUNKTAG));
        }
        this.regExpression = YES.equals(attrs.getValue(REGEXP));
        if (attrs.getValue(SPACEBEFORE) != null) {
            this.tokenSpaceBefore = YES.equals(attrs.getValue(SPACEBEFORE));
            boolean bl = this.tokenSpaceBeforeSet = !IGNORE.equals(attrs.getValue(SPACEBEFORE));
        }
        if (!this.inAndGroup && !this.inOrGroup) {
            ++this.tokenCounter;
        }
    }

    protected List<Match> addLegacyMatches(List<Match> existingSugMatches, String messageStr, boolean inMessage) {
        if (existingSugMatches == null || existingSugMatches.isEmpty()) {
            return null;
        }
        ArrayList<Match> sugMatch = new ArrayList<Match>();
        int pos = 0;
        int ind = 0;
        int matchCounter = 0;
        while (pos != -1) {
            pos = messageStr.indexOf(92, ind + 1);
            if (pos != -1 && messageStr.length() > pos && Character.isDigit(messageStr.charAt(pos + 1))) {
                if (pos == 0 || messageStr.charAt(pos - 1) != '\u0001') {
                    Match mWorker = new Match(null, null, false, null, null, Match.CaseConversion.NONE, false, false, Match.IncludeRange.NONE);
                    mWorker.setInMessageOnly(true);
                    sugMatch.add(mWorker);
                } else if (messageStr.charAt(pos - 1) == '\u0001') {
                    sugMatch.add(existingSugMatches.get(matchCounter));
                    if (inMessage) {
                        this.message.deleteCharAt(pos - 1 - matchCounter);
                    } else {
                        this.suggestionsOutMsg.deleteCharAt(pos - 1 - matchCounter);
                    }
                    ++matchCounter;
                }
            }
            ind = pos;
        }
        if (sugMatch.isEmpty()) {
            return existingSugMatches;
        }
        return sugMatch;
    }

    protected void finalizeTokens() {
        if (!this.exceptionSet || this.tokenElement == null) {
            this.tokenElement = new Element(StringTools.trimWhitespace(this.elements.toString()), this.caseSensitive, this.regExpression, this.tokenInflected);
            this.tokenElement.setNegation(this.tokenNegated);
        } else {
            this.tokenElement.setStringElement(StringTools.trimWhitespace(this.elements.toString()));
        }
        if (this.skipPos != 0) {
            this.tokenElement.setSkipNext(this.skipPos);
            this.skipPos = 0;
        }
        if (this.minOccurrence != 1) {
            this.tokenElement.setMinOccurrence(this.minOccurrence);
            this.minOccurrence = 1;
        }
        if (this.maxOccurrence != 1) {
            this.tokenElement.setMaxOccurrence(this.maxOccurrence);
            this.maxOccurrence = 1;
        }
        if (this.posToken != null) {
            this.tokenElement.setPosElement(this.posToken, this.posRegExp, this.posNegation);
            this.posToken = null;
        }
        if (this.chunkTag != null) {
            this.tokenElement.setChunkElement(this.chunkTag);
            this.chunkTag = null;
        }
        if (this.tokenReference != null) {
            this.tokenElement.setMatch(this.tokenReference);
        }
        if (this.inAndGroup && this.andGroupCounter > 0) {
            this.elementList.get(this.elementList.size() - 1).setAndGroupElement(this.tokenElement);
        } else if (this.inOrGroup && this.orGroupCounter > 0) {
            this.elementList.get(this.elementList.size() - 1).setOrGroupElement(this.tokenElement);
        } else {
            this.elementList.add(this.tokenElement);
        }
        if (this.inAndGroup) {
            ++this.andGroupCounter;
        }
        if (this.inOrGroup) {
            ++this.orGroupCounter;
        }
        if (this.inUnification) {
            this.tokenElement.setUnification(this.equivalenceFeatures);
        }
        this.tokenElement.setInsideMarker(this.inMarker);
        if (this.inUnificationDef) {
            this.language.getUnifierConfiguration().setEquivalence(this.uFeature, this.uType, this.tokenElement);
            this.elementList.clear();
        }
        if (this.tokenSpaceBeforeSet) {
            this.tokenElement.setWhitespaceBefore(this.tokenSpaceBefore);
        }
        this.resetToken();
    }
}

