/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.EquivalenceTypeLocator;

public class Unifier {
    private final List<AnalyzedTokenReadings> tokSequence;
    private boolean allFeatsIn;
    private int tokCnt = -1;
    private int readingsCounter = 1;
    private final Map<EquivalenceTypeLocator, Element> equivalenceTypes;
    private final Map<String, List<String>> equivalenceFeatures;
    private final List<Map<String, Set<String>>> equivalencesMatched = new ArrayList<Map<String, Set<String>>>();
    private List<Boolean> featuresFound;
    private List<Boolean> tmpFeaturesFound;
    private final Map<String, Set<String>> equivalencesToBeRemoved;
    private final Map<String, Set<String>> equivalencesToBeKept;
    private boolean firstUnified;
    private boolean inUnification;
    private boolean uniMatched;
    private boolean uniAllMatched;
    private AnalyzedTokenReadings[] unifiedTokens;

    public Unifier(Map<EquivalenceTypeLocator, Element> equivalenceTypes, Map<String, List<String>> equivalenceFeatures) {
        this.equivalenceTypes = equivalenceTypes;
        this.equivalenceFeatures = equivalenceFeatures;
        this.equivalencesToBeRemoved = new HashMap<String, Set<String>>();
        this.equivalencesToBeKept = new HashMap<String, Set<String>>();
        this.featuresFound = new ArrayList<Boolean>();
        this.tmpFeaturesFound = new ArrayList<Boolean>();
        this.tokSequence = new ArrayList<AnalyzedTokenReadings>();
    }

    protected final boolean isSatisfied(AnalyzedToken aToken, Map<String, List<String>> uFeatures) {
        if (this.allFeatsIn && this.equivalencesMatched.isEmpty()) {
            return false;
        }
        if (uFeatures == null) {
            return false;
        }
        boolean unified = true;
        if (this.allFeatsIn) {
            unified &= this.checkNext(aToken, uFeatures);
        } else {
            ++this.tokCnt;
            while (this.equivalencesMatched.size() <= this.tokCnt) {
                this.equivalencesMatched.add(new HashMap());
            }
            for (Map.Entry<String, List<String>> feat : uFeatures.entrySet()) {
                List<String> types = feat.getValue();
                if (types == null || types.isEmpty()) {
                    types = this.equivalenceFeatures.get(feat.getKey());
                }
                for (String typeName : types) {
                    Element testElem = this.equivalenceTypes.get(new EquivalenceTypeLocator(feat.getKey(), typeName));
                    if (testElem == null) {
                        return false;
                    }
                    if (!testElem.isMatched(aToken)) continue;
                    if (!this.equivalencesMatched.get(this.tokCnt).containsKey(feat.getKey())) {
                        HashSet<String> typeSet = new HashSet<String>();
                        typeSet.add(typeName);
                        this.equivalencesMatched.get(this.tokCnt).put(feat.getKey(), typeSet);
                        continue;
                    }
                    this.equivalencesMatched.get(this.tokCnt).get(feat.getKey()).add(typeName);
                }
                if (unified &= this.equivalencesMatched.get(this.tokCnt).containsKey(feat.getKey())) continue;
                break;
            }
            if (unified) {
                if (this.tokCnt == 0 || this.tokSequence.isEmpty()) {
                    this.tokSequence.add(new AnalyzedTokenReadings(aToken, 0));
                } else {
                    this.tokSequence.get(0).addReading(aToken);
                }
            }
        }
        return unified;
    }

    private boolean checkNext(AnalyzedToken aToken, Map<String, List<String>> uFeatures) {
        boolean unifiedNext = true;
        boolean anyFeatUnified = false;
        ArrayList<Boolean> tokenFeaturesFound = new ArrayList<Boolean>(this.tmpFeaturesFound);
        if (this.allFeatsIn) {
            for (int i = 0; i <= this.tokCnt; ++i) {
                boolean allFeatsUnified = true;
                for (Map.Entry<String, List<String>> feat : uFeatures.entrySet()) {
                    boolean featUnified = false;
                    List<String> types = feat.getValue();
                    if (types == null || types.isEmpty()) {
                        types = this.equivalenceFeatures.get(feat.getKey());
                    }
                    for (String typeName : types) {
                        HashSet<String> typeSet;
                        if (!this.featuresFound.get(i).booleanValue() || !this.equivalencesMatched.get(i).containsKey(feat.getKey()) || !this.equivalencesMatched.get(i).get(feat.getKey()).contains(typeName)) continue;
                        Element testElem = this.equivalenceTypes.get(new EquivalenceTypeLocator(feat.getKey(), typeName));
                        boolean bl = featUnified = featUnified || testElem.isMatched(aToken);
                        if (!testElem.isMatched(aToken)) {
                            if (!this.equivalencesToBeRemoved.containsKey(feat.getKey())) {
                                typeSet = new HashSet<String>();
                                typeSet.add(typeName);
                                this.equivalencesToBeRemoved.put(feat.getKey(), typeSet);
                                continue;
                            }
                            this.equivalencesToBeRemoved.get(feat.getKey()).add(typeName);
                            continue;
                        }
                        if (!this.equivalencesToBeKept.containsKey(feat.getKey())) {
                            typeSet = new HashSet();
                            typeSet.add(typeName);
                            this.equivalencesToBeKept.put(feat.getKey(), typeSet);
                            continue;
                        }
                        this.equivalencesToBeKept.get(feat.getKey()).add(typeName);
                    }
                    allFeatsUnified &= featUnified;
                }
                tokenFeaturesFound.set(i, tokenFeaturesFound.get(i) & allFeatsUnified);
                anyFeatUnified = anyFeatUnified || allFeatsUnified;
            }
            if (unifiedNext &= anyFeatUnified) {
                if (this.tokSequence.size() == this.readingsCounter) {
                    this.tokSequence.add(new AnalyzedTokenReadings(aToken, 0));
                } else if (this.readingsCounter < this.tokSequence.size()) {
                    this.tokSequence.get(this.readingsCounter).addReading(aToken);
                } else {
                    unifiedNext = false;
                }
                this.tmpFeaturesFound = tokenFeaturesFound;
            }
        }
        return unifiedNext;
    }

    public final void startNextToken() {
        this.featuresFound = new ArrayList<Boolean>(this.tmpFeaturesFound);
        ++this.readingsCounter;
        for (int i = 0; i <= this.tokCnt; ++i) {
            for (Map.Entry<String, List<String>> feat : this.equivalenceFeatures.entrySet()) {
                List<String> types = feat.getValue();
                for (String typeName : types) {
                    if (!this.featuresFound.get(i).booleanValue() || !this.equivalencesToBeRemoved.containsKey(feat.getKey()) || !this.equivalencesToBeRemoved.get(feat.getKey()).contains(typeName) || this.equivalencesToBeKept.containsKey(feat.getKey()) && this.equivalencesToBeKept.get(feat.getKey()).contains(typeName) || !this.equivalencesMatched.get(i).containsKey(feat.getKey()) || !this.equivalencesMatched.get(i).get(feat.getKey()).contains(typeName)) continue;
                    this.equivalencesMatched.get(i).get(feat.getKey()).remove(typeName);
                }
            }
        }
        this.equivalencesToBeRemoved.clear();
        this.equivalencesToBeKept.clear();
    }

    public final void startUnify() {
        this.allFeatsIn = true;
        for (int i = 0; i <= this.tokCnt; ++i) {
            this.featuresFound.add(true);
        }
        this.tmpFeaturesFound = new ArrayList<Boolean>(this.featuresFound);
    }

    public final void reset() {
        this.equivalencesMatched.clear();
        this.allFeatsIn = false;
        this.tokCnt = -1;
        this.featuresFound.clear();
        this.tmpFeaturesFound.clear();
        this.tokSequence.clear();
        this.readingsCounter = 1;
        this.firstUnified = false;
        this.uniMatched = false;
        this.uniAllMatched = false;
        this.inUnification = false;
    }

    public final AnalyzedTokenReadings[] getUnifiedTokens() {
        if (this.tokSequence.isEmpty()) {
            return null;
        }
        if (!this.firstUnified) {
            int first = 0;
            this.tmpFeaturesFound.add(true);
            while (!this.tmpFeaturesFound.get(first).booleanValue()) {
                ++first;
            }
            if (first > this.tmpFeaturesFound.size() - 1) {
                return null;
            }
            this.tmpFeaturesFound.remove(this.tmpFeaturesFound.size() - 1);
            int numRead = this.tokSequence.get(0).getReadingsLength();
            if (numRead > 1 && first < numRead) {
                AnalyzedTokenReadings tmpATR = new AnalyzedTokenReadings(this.tokSequence.get(0).getAnalyzedToken(first), 0);
                for (int i = first + 1; i <= Math.min(numRead - 1, this.tokCnt); ++i) {
                    if (!this.tmpFeaturesFound.get(i).booleanValue()) continue;
                    tmpATR.addReading(this.tokSequence.get(0).getAnalyzedToken(i));
                }
                this.tokSequence.set(0, tmpATR);
            }
            this.firstUnified = true;
        }
        AnalyzedTokenReadings[] atr = this.tokSequence.toArray(new AnalyzedTokenReadings[this.tokSequence.size()]);
        return atr;
    }

    public final boolean isUnified(AnalyzedToken matchToken, Map<String, List<String>> uFeatures, boolean lastReading, boolean isMatched) {
        if (this.inUnification) {
            if (isMatched) {
                this.uniMatched |= this.isSatisfied(matchToken, uFeatures);
            }
            this.uniAllMatched = this.uniMatched;
            if (lastReading) {
                this.startNextToken();
                this.unifiedTokens = this.getUnifiedTokens();
                this.uniMatched = false;
            }
            return this.uniAllMatched;
        }
        if (isMatched) {
            this.isSatisfied(matchToken, uFeatures);
        }
        if (lastReading) {
            this.inUnification = true;
            this.uniMatched = false;
            this.startUnify();
        }
        return true;
    }

    public final boolean isUnified(AnalyzedToken matchToken, Map<String, List<String>> uFeatures, boolean lastReading) {
        return this.isUnified(matchToken, uFeatures, lastReading, true);
    }

    public final AnalyzedTokenReadings[] getFinalUnified() {
        if (this.inUnification) {
            return this.unifiedTokens;
        }
        return null;
    }
}

