/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.XMLRuleHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PatternRuleHandler
extends XMLRuleHandler {
    static final String PLEASE_SPELL_ME = "<pleasespellme/>";
    protected Category category;
    protected String categoryIssueType;
    protected String ruleGroupIssueType;
    protected String ruleIssueType;
    protected String name;
    private int subId;
    private boolean defaultOff;
    private boolean defaultOn;
    private String ruleGroupDescription;
    private int startPos = -1;
    private int endPos = -1;
    private int tokenCountForMarker = 0;
    private boolean relaxedMode = false;

    void setRelaxedMode(boolean relaxedMode) {
        this.relaxedMode = relaxedMode;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        if ("category".equals(qName)) {
            String catName = attrs.getValue("name");
            String priorityStr = attrs.getValue("priority");
            this.category = priorityStr == null ? new Category(catName) : new Category(catName, Integer.parseInt(priorityStr));
            if ("off".equals(attrs.getValue("default"))) {
                this.category.setDefaultOff();
            }
            if (attrs.getValue("type") != null) {
                this.categoryIssueType = attrs.getValue("type");
            }
        } else if ("rules".equals(qName)) {
            String languageStr = attrs.getValue("lang");
            this.language = Language.getLanguageForShortName(languageStr);
        } else if ("rule".equals(qName)) {
            this.shortMessage = new StringBuilder();
            this.message = new StringBuilder();
            this.suggestionsOutMsg = new StringBuilder();
            this.url = new StringBuilder();
            this.id = attrs.getValue("id");
            if (this.inRuleGroup) {
                ++this.subId;
            }
            if (!this.inRuleGroup || !this.defaultOff) {
                this.defaultOff = "off".equals(attrs.getValue("default"));
            }
            if (!this.inRuleGroup || !this.defaultOn) {
                this.defaultOn = "on".equals(attrs.getValue("default"));
            }
            if (this.inRuleGroup && this.id == null) {
                this.id = this.ruleGroupId;
            }
            this.name = attrs.getValue("name");
            if (this.inRuleGroup && this.name == null) {
                this.name = this.ruleGroupDescription;
            }
            this.correctExamples = new ArrayList();
            this.incorrectExamples = new ArrayList();
            if (this.suggestionMatches != null) {
                this.suggestionMatches.clear();
            }
            if (this.suggestionMatchesOutMsg != null) {
                this.suggestionMatchesOutMsg.clear();
            }
            if (attrs.getValue("type") != null) {
                this.ruleIssueType = attrs.getValue("type");
            }
        } else if ("pattern".equals(qName)) {
            this.startPattern(attrs);
            this.tokenCountForMarker = 0;
        } else if ("and".equals(qName)) {
            this.inAndGroup = true;
            ++this.tokenCountForMarker;
        } else if ("or".equals(qName)) {
            this.inOrGroup = true;
            ++this.tokenCountForMarker;
        } else if ("unify".equals(qName)) {
            this.inUnification = true;
            this.uniNegation = "yes".equals(attrs.getValue("negate"));
        } else if ("feature".equals(qName)) {
            this.uFeature = attrs.getValue("id");
        } else if ("type".equals(qName)) {
            this.uType = attrs.getValue("id");
            this.uTypeList.add(this.uType);
        } else if ("token".equals(qName)) {
            this.setToken(attrs);
            if (!this.inAndGroup && !this.inOrGroup) {
                ++this.tokenCountForMarker;
            }
        } else if ("exception".equals(qName)) {
            this.setExceptions(attrs);
        } else if ("example".equals(qName) && attrs.getValue("type").equals("correct")) {
            this.inCorrectExample = true;
            this.correctExample = new StringBuilder();
        } else if ("example".equals(qName) && attrs.getValue("type").equals("incorrect")) {
            this.inIncorrectExample = true;
            this.incorrectExample = new StringBuilder();
            this.exampleCorrection = new StringBuilder();
            if (attrs.getValue("correction") != null) {
                this.exampleCorrection.append(attrs.getValue("correction"));
            }
        } else if ("message".equals(qName)) {
            this.inMessage = true;
            this.inSuggestion = false;
            this.message = new StringBuilder();
        } else if ("suggestion".equals(qName) && !this.inMessage) {
            if ("yes".equals(attrs.getValue("suppress_misspelled"))) {
                this.suggestionsOutMsg.append(PLEASE_SPELL_ME);
            }
            this.suggestionsOutMsg.append("<suggestion>");
            this.inSuggestion = true;
        } else if ("short".equals(qName)) {
            this.inShortMessage = true;
            this.shortMessage = new StringBuilder();
        } else if ("url".equals(qName)) {
            this.inUrl = true;
            this.url = new StringBuilder();
        } else if ("rulegroup".equals(qName)) {
            this.ruleGroupId = attrs.getValue("id");
            this.ruleGroupDescription = attrs.getValue("name");
            this.defaultOff = "off".equals(attrs.getValue("default"));
            this.defaultOn = "on".equals(attrs.getValue("default"));
            this.inRuleGroup = true;
            this.subId = 0;
            if (attrs.getValue("type") != null) {
                this.ruleGroupIssueType = attrs.getValue("type");
            }
        } else if ("suggestion".equals(qName) && this.inMessage) {
            if ("yes".equals(attrs.getValue("suppress_misspelled"))) {
                this.message.append(PLEASE_SPELL_ME);
            }
            this.message.append("<suggestion>");
            this.inSuggestion = true;
        } else if ("match".equals(qName)) {
            this.setMatchElement(attrs);
        } else if ("marker".equals(qName) && this.inCorrectExample) {
            this.correctExample.append("<marker>");
        } else if ("marker".equals(qName) && this.inIncorrectExample) {
            this.incorrectExample.append("<marker>");
        } else if ("marker".equals(qName) && this.inPattern) {
            this.startPos = this.tokenCounter;
            this.inMarker = true;
        } else if ("unification".equals(qName)) {
            this.uFeature = attrs.getValue("feature");
            this.inUnificationDef = true;
        } else if ("equivalence".equals(qName)) {
            this.uType = attrs.getValue("type");
        } else if ("phrases".equals(qName)) {
            this.inPhrases = true;
        } else if ("includephrases".equals(qName)) {
            this.phraseElementInit();
        } else if ("phrase".equals(qName) && this.inPhrases) {
            this.phraseId = attrs.getValue("id");
        } else if ("phraseref".equals(qName) && attrs.getValue("idref") != null) {
            this.preparePhrase(attrs);
            ++this.tokenCountForMarker;
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if ("category".equals(qName)) {
            this.categoryIssueType = null;
        } else if ("rule".equals(qName)) {
            this.suggestionMatchesOutMsg = this.addLegacyMatches(this.suggestionMatchesOutMsg, this.suggestionsOutMsg.toString(), false);
            this.phraseElementInit();
            if (this.relaxedMode && this.id == null) {
                this.id = "";
            }
            if (this.relaxedMode && this.name == null) {
                this.name = "";
            }
            if (this.phraseElementList.isEmpty()) {
                ArrayList<Element> tmpElements = new ArrayList<Element>();
                this.createRules(new ArrayList<Element>(this.elementList), tmpElements, 0);
            } else {
                if (!this.elementList.isEmpty()) {
                    for (ArrayList ph : this.phraseElementList) {
                        ph.addAll(new ArrayList(this.elementList));
                    }
                }
                for (ArrayList phraseElement : this.phraseElementList) {
                    this.processElement(phraseElement);
                    ArrayList<Element> tmpElements = new ArrayList<Element>();
                    this.createRules(phraseElement, tmpElements, 0);
                }
            }
            this.elementList.clear();
            if (this.phraseElementList != null) {
                this.phraseElementList.clear();
            }
            this.ruleIssueType = null;
        } else if ("exception".equals(qName)) {
            this.finalizeExceptions();
        } else if ("and".equals(qName)) {
            this.inAndGroup = false;
            this.andGroupCounter = 0;
            ++this.tokenCounter;
        } else if ("or".equals(qName)) {
            this.inOrGroup = false;
            this.orGroupCounter = 0;
            ++this.tokenCounter;
        } else if ("token".equals(qName)) {
            this.finalizeTokens();
        } else if ("pattern".equals(qName)) {
            this.inPattern = false;
            if (this.lastPhrase) {
                this.elementList.clear();
            }
            this.tokenCounter = 0;
        } else if ("example".equals(qName)) {
            if (this.inCorrectExample) {
                this.correctExamples.add(this.correctExample.toString());
            } else if (this.inIncorrectExample) {
                String[] corrections = this.exampleCorrection.toString().split("\\|");
                IncorrectExample example = corrections.length > 0 && corrections[0].length() > 0 ? new IncorrectExample(this.incorrectExample.toString(), corrections) : new IncorrectExample(this.incorrectExample.toString());
                this.incorrectExamples.add(example);
            }
            this.inCorrectExample = false;
            this.inIncorrectExample = false;
            this.correctExample = new StringBuilder();
            this.incorrectExample = new StringBuilder();
            this.exampleCorrection = new StringBuilder();
        } else if ("message".equals(qName)) {
            this.suggestionMatches = this.addLegacyMatches(this.suggestionMatches, this.message.toString(), true);
            this.inMessage = false;
        } else if ("suggestion".equals(qName) && !this.inMessage) {
            this.suggestionsOutMsg.append("</suggestion>");
            this.inSuggestion = false;
        } else if ("short".equals(qName)) {
            this.inShortMessage = false;
        } else if ("url".equals(qName)) {
            this.inUrl = false;
        } else if ("match".equals(qName)) {
            if (this.inMessage) {
                ((Match)this.suggestionMatches.get(this.suggestionMatches.size() - 1)).setLemmaString(this.match.toString());
            } else if (this.inSuggestion) {
                ((Match)this.suggestionMatchesOutMsg.get(this.suggestionMatchesOutMsg.size() - 1)).setLemmaString(this.match.toString());
            } else if (this.inToken) {
                this.tokenReference.setLemmaString(this.match.toString());
            }
            this.inMatch = false;
        } else if ("rulegroup".equals(qName)) {
            this.inRuleGroup = false;
            this.ruleGroupIssueType = null;
        } else if ("suggestion".equals(qName) && this.inMessage) {
            this.message.append("</suggestion>");
            this.inSuggestion = false;
        } else if ("marker".equals(qName) && this.inCorrectExample) {
            this.correctExample.append("</marker>");
        } else if ("marker".equals(qName) && this.inIncorrectExample) {
            this.incorrectExample.append("</marker>");
        } else if ("marker".equals(qName) && this.inPattern) {
            this.endPos = this.tokenCountForMarker;
            this.inMarker = false;
        } else if ("phrase".equals(qName) && this.inPhrases) {
            this.finalizePhrase();
        } else if ("includephrases".equals(qName)) {
            this.elementList.clear();
        } else if ("phrases".equals(qName) && this.inPhrases) {
            this.inPhrases = false;
        } else if ("unification".equals(qName)) {
            this.inUnificationDef = false;
        } else if ("feature".equals(qName)) {
            this.equivalenceFeatures.put(this.uFeature, this.uTypeList);
            this.uTypeList = new ArrayList();
        } else if ("unify".equals(qName)) {
            this.inUnification = false;
            this.equivalenceFeatures = new HashMap();
            int lastElement = this.elementList.size() - 1;
            ((Element)this.elementList.get(lastElement)).setLastInUnification();
            if (this.uniNegation) {
                ((Element)this.elementList.get(lastElement)).setUniNegation();
            }
        }
    }

    private void createRules(List<Element> elemList, List<Element> tmpElements, int numElement) {
        if (numElement >= elemList.size()) {
            PatternRule rule = new PatternRule(this.id, this.language, tmpElements, this.name, this.message.toString(), this.shortMessage.toString(), this.suggestionsOutMsg.toString(), this.phraseElementList.size() > 1);
            this.prepareRule(rule);
            this.rules.add(rule);
        } else {
            Element element = elemList.get(numElement);
            if (element.hasOrGroup()) {
                for (Element elementOfOrGroup : element.getOrGroup()) {
                    ArrayList<Element> tmpElements2 = new ArrayList<Element>();
                    tmpElements2.addAll(tmpElements);
                    tmpElements2.add((Element)ObjectUtils.clone((Object)elementOfOrGroup));
                    this.createRules(elemList, tmpElements2, numElement + 1);
                }
            }
            tmpElements.add((Element)ObjectUtils.clone((Object)element));
            this.createRules(elemList, tmpElements, numElement + 1);
        }
    }

    protected void prepareRule(PatternRule rule) {
        if (this.startPos != -1 && this.endPos != -1) {
            rule.setStartPositionCorrection(this.startPos);
            rule.setEndPositionCorrection(this.endPos - this.tokenCountForMarker);
        }
        this.startPos = -1;
        this.endPos = -1;
        rule.setCorrectExamples(this.correctExamples);
        rule.setIncorrectExamples(this.incorrectExamples);
        rule.setCategory(this.category);
        if (this.inRuleGroup) {
            rule.setSubId(Integer.toString(this.subId));
        } else {
            rule.setSubId("1");
        }
        this.caseSensitive = false;
        if (this.suggestionMatches != null) {
            for (Match m : this.suggestionMatches) {
                rule.addSuggestionMatch(m);
            }
            if (this.phraseElementList.size() <= 1) {
                this.suggestionMatches.clear();
            }
        }
        if (this.suggestionMatchesOutMsg != null) {
            for (Match m : this.suggestionMatchesOutMsg) {
                rule.addSuggestionMatchOutMsg(m);
            }
            this.suggestionMatchesOutMsg.clear();
        }
        if (this.defaultOff) {
            rule.setDefaultOff();
        }
        if (this.category == null) {
            throw new RuntimeException("Cannot activate rule '" + this.id + "', it is outside of a <category>...</category>");
        }
        if (this.category.isDefaultOff() && !this.defaultOn) {
            rule.setDefaultOff();
        }
        if (this.url != null && this.url.length() > 0) {
            try {
                rule.setUrl(new URL(this.url.toString()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Could not parse URL for rule: " + rule + ": '" + this.url + "'", e);
            }
        }
        if (this.ruleIssueType != null) {
            rule.setLocQualityIssueType(this.ruleIssueType);
        } else if (this.ruleGroupIssueType != null) {
            rule.setLocQualityIssueType(this.ruleGroupIssueType);
        } else if (this.categoryIssueType != null) {
            rule.setLocQualityIssueType(this.categoryIssueType);
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) {
        String s = new String(buf, offset, len);
        if (this.inException) {
            this.exceptions.append(s);
        } else if (this.inToken) {
            this.elements.append(s);
        } else if (this.inCorrectExample) {
            this.correctExample.append(s);
        } else if (this.inIncorrectExample) {
            this.incorrectExample.append(s);
        } else if (this.inMatch) {
            this.match.append(s);
        } else if (this.inMessage) {
            this.message.append(s);
        } else if (this.inSuggestion) {
            this.suggestionsOutMsg.append(s);
        } else if (this.inShortMessage) {
            this.shortMessage.append(s);
        } else if (this.inUrl) {
            this.url.append(s);
        }
    }
}

