/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.ElementMatcher;
import org.languagetool.rules.patterns.Unifier;

public abstract class AbstractPatternRulePerformer {
    protected boolean prevMatched;
    protected AbstractPatternRule rule;
    protected Unifier unifier;
    protected AnalyzedTokenReadings[] unifiedTokens;

    protected AbstractPatternRulePerformer(AbstractPatternRule rule, Unifier unifier) {
        this.rule = rule;
        this.unifier = unifier;
    }

    protected List<ElementMatcher> createElementMatchers() {
        ArrayList<ElementMatcher> elementMatchers = new ArrayList<ElementMatcher>(this.rule.patternElements.size());
        for (Element el : this.rule.patternElements) {
            ElementMatcher matcher = new ElementMatcher(el);
            elementMatchers.add(matcher);
        }
        return elementMatchers;
    }

    protected boolean testAllReadings(AnalyzedTokenReadings[] tokens, ElementMatcher elem, ElementMatcher prevElement, int tokenNo, int firstMatchToken, int prevSkipNext) throws IOException {
        int l;
        boolean thisMatched = false;
        int numberOfReadings = tokens[tokenNo].getReadingsLength();
        elem.prepareAndGroup(firstMatchToken, tokens, this.rule.getLanguage());
        for (l = 0; l < numberOfReadings; ++l) {
            AnalyzedToken matchToken = tokens[tokenNo].getAnalyzedToken(l);
            boolean bl = this.prevMatched = this.prevMatched || prevSkipNext > 0 && prevElement != null && prevElement.isMatchedByScopeNextException(matchToken);
            if (this.prevMatched) {
                return false;
            }
            boolean bl2 = thisMatched = thisMatched || elem.isMatched(matchToken);
            if (!thisMatched && !elem.getElement().isInflected() && elem.getElement().getPOStag() == null && prevElement != null && prevElement.getElement().getExceptionList() == null) {
                return false;
            }
            if (!this.rule.isGroupsOrUnification()) continue;
            thisMatched &= this.testUnificationAndGroups(thisMatched, l + 1 == numberOfReadings, matchToken, elem);
        }
        if (thisMatched) {
            for (l = 0; l < numberOfReadings; ++l) {
                if (!elem.isExceptionMatchedCompletely(tokens[tokenNo].getAnalyzedToken(l))) continue;
                return false;
            }
            if (tokenNo > 0 && elem.hasPreviousException() && elem.isMatchedByPreviousException(tokens[tokenNo - 1])) {
                return false;
            }
        }
        if (elem.getElement().getChunkTag() != null) {
            thisMatched &= tokens[tokenNo].getChunkTags().contains(elem.getElement().getChunkTag()) ^ elem.getElement().getNegation();
        }
        if (elem.getElement().hasAndGroup()) {
            for (Element e : elem.getElement().getAndGroup()) {
                if (e.getChunkTag() == null) continue;
                thisMatched &= tokens[tokenNo].getChunkTags().contains(e.getChunkTag()) ^ e.getNegation();
            }
        }
        return thisMatched;
    }

    protected boolean testUnificationAndGroups(boolean matched, boolean lastReading, AnalyzedToken matchToken, ElementMatcher elemMatcher) {
        boolean thisMatched = matched;
        boolean elemIsMatched = elemMatcher.isMatched(matchToken);
        Element elem = elemMatcher.getElement();
        if (this.rule.testUnification) {
            if (matched && elem.isUnified()) {
                if (elem.isUniNegated()) {
                    thisMatched = !thisMatched || !this.unifier.isUnified(matchToken, elem.getUniFeatures(), lastReading, elemIsMatched);
                } else if (elem.isLastInUnification()) {
                    thisMatched = thisMatched && this.unifier.isUnified(matchToken, elem.getUniFeatures(), lastReading, elemIsMatched);
                } else {
                    this.unifier.isUnified(matchToken, elem.getUniFeatures(), lastReading, elemIsMatched);
                }
            }
            if (thisMatched && this.rule.isGetUnified()) {
                this.unifiedTokens = this.unifier.getFinalUnified();
            }
            if (!elem.isUnified()) {
                this.unifier.reset();
            }
        }
        elemMatcher.addMemberAndGroup(matchToken);
        if (lastReading) {
            thisMatched &= elemMatcher.checkAndGroup(thisMatched);
        }
        return thisMatched;
    }
}

