/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public abstract class WrongWordInContextRule
extends Rule {
    private final List<ContextWords> contextWordsSet;

    public WrongWordInContextRule(ResourceBundle messages) {
        if (messages != null) {
            super.setCategory(new Category(this.getCategoryString()));
        }
        this.contextWordsSet = this.loadContextWords(JLanguageTool.getDataBroker().getFromRulesDirAsStream(this.getFilename()));
        this.setLocQualityIssueType("misspelling");
    }

    protected abstract String getFilename();

    protected String getCategoryString() {
        return this.messages.getString("category_misc");
    }

    @Override
    public String getId() {
        return "WRONG_WORD_IN_CONTEXT";
    }

    @Override
    public String getDescription() {
        return "Confusion of words";
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence text) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        for (ContextWords contextWords : this.contextWordsSet) {
            String token;
            int j;
            int i;
            boolean[] matchedWord = new boolean[]{false, false};
            Matcher[] matchers = new Matcher[]{null, null};
            matchers[0] = contextWords.words[0].matcher("");
            matchers[1] = contextWords.words[1].matcher("");
            String token1 = "";
            for (i = 1; i < tokens.length && !matchedWord[0]; ++i) {
                token1 = tokens[i].getToken();
                matchedWord[0] = matchers[0].reset(token1).find();
            }
            String token2 = "";
            for (j = 1; j < tokens.length && !matchedWord[1]; ++j) {
                token2 = tokens[j].getToken();
                matchedWord[1] = matchers[1].reset(token2).find();
            }
            int foundWord = -1;
            int notFoundWord = -1;
            int startPos = 0;
            int endPos = 0;
            String matchedToken = "";
            if (matchedWord[0] && !matchedWord[1]) {
                foundWord = 0;
                notFoundWord = 1;
                matchers[1] = contextWords.contexts[1].matcher("");
                startPos = tokens[i - 1].getStartPos();
                endPos = tokens[i - 1].getStartPos() + token1.length();
                matchedToken = token1;
            } else if (matchedWord[1] && !matchedWord[0]) {
                foundWord = 1;
                notFoundWord = 0;
                matchers[0] = contextWords.contexts[0].matcher("");
                startPos = tokens[j - 1].getStartPos();
                endPos = tokens[j - 1].getStartPos() + token2.length();
                matchedToken = token2;
            }
            if (foundWord == -1) continue;
            boolean[] matchedContext = new boolean[]{false, false};
            matchers[foundWord] = contextWords.contexts[foundWord].matcher("");
            matchers[notFoundWord] = contextWords.contexts[notFoundWord].matcher("");
            for (i = 1; i < tokens.length && !matchedContext[foundWord]; ++i) {
                token = tokens[i].getToken();
                matchedContext[foundWord] = matchers[foundWord].reset(token).find();
            }
            for (i = 1; i < tokens.length && !matchedContext[notFoundWord]; ++i) {
                token = tokens[i].getToken();
                matchedContext[notFoundWord] = matchers[notFoundWord].reset(token).find();
            }
            if (!matchedContext[notFoundWord] || matchedContext[foundWord]) continue;
            String msg = this.getMessage(matchedToken, matchedToken.replaceFirst(contextWords.matches[foundWord], contextWords.matches[notFoundWord]), contextWords.explanations[notFoundWord], contextWords.explanations[foundWord]);
            RuleMatch ruleMatch = new RuleMatch(this, startPos, endPos, msg, this.getShortMessageString());
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    protected abstract String getMessageString();

    protected abstract String getShortMessageString();

    protected abstract String getLongMessageString();

    private String getMessage(String wrongWord, String suggestion, String explanationSuggestion, String explanationWrongWord) {
        if (explanationSuggestion.equals("") || explanationWrongWord.equals("")) {
            return this.getMessageString().replaceFirst("\\$SUGGESTION", suggestion).replaceFirst("\\$WRONGWORD", wrongWord);
        }
        return this.getLongMessageString().replaceFirst("\\$SUGGESTION", suggestion).replaceFirst("\\$WRONGWORD", wrongWord).replaceFirst("\\$EXPLANATION_SUGGESTION", explanationSuggestion).replaceFirst("\\$EXPLANATION_WRONGWORD", explanationWrongWord);
    }

    private List<ContextWords> loadContextWords(InputStream file) {
        ArrayList<ContextWords> set = new ArrayList<ContextWords>();
        try (Scanner scanner = new Scanner(file, "utf-8");){
            while (scanner.hasNextLine()) {
                String[] column;
                String line = scanner.nextLine();
                if (line.charAt(0) == '#' || (column = line.split("\t")).length < 6) continue;
                ContextWords contextWords = new ContextWords();
                contextWords.setWord(0, column[0]);
                contextWords.setWord(1, column[1]);
                contextWords.matches[0] = column[2];
                contextWords.matches[1] = column[3];
                contextWords.setContext(0, column[4]);
                contextWords.setContext(1, column[5]);
                if (column.length > 6) {
                    contextWords.explanations[0] = column[6];
                    if (column.length > 7) {
                        contextWords.explanations[1] = column[7];
                    }
                }
                set.add(contextWords);
            }
        }
        return set;
    }

    @Override
    public void reset() {
    }

    class ContextWords {
        String[] matches = new String[]{"", ""};
        String[] explanations = new String[]{"", ""};
        Pattern[] words = new Pattern[2];
        Pattern[] contexts = new Pattern[2];

        ContextWords() {
        }

        private String addBoundaries(String str) {
            String ignore_case = "";
            if (str.startsWith("(?i)")) {
                str = str.substring(4);
                ignore_case = "(?i)";
            }
            return ignore_case + "\\b(" + str + ")\\b";
        }

        public void setWord(int i, String word) {
            this.words[i] = Pattern.compile(this.addBoundaries(word));
        }

        public void setContext(int i, String context) {
            this.contexts[i] = Pattern.compile(this.addBoundaries(context));
        }
    }
}

