/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class LongSentenceRule
extends Rule {
    private static final int DEFAULT_MAX_WORDS = 40;
    private final int maxWords;

    public LongSentenceRule(ResourceBundle messages, int maxSentenceLength) {
        super(messages);
        super.setCategory(new Category(messages.getString("category_misc")));
        if (maxSentenceLength <= 0) {
            throw new IllegalArgumentException("maxSentenceLength must be > 0: " + maxSentenceLength);
        }
        this.maxWords = maxSentenceLength;
        this.setDefaultOff();
        this.setLocQualityIssueType("style");
    }

    public LongSentenceRule(ResourceBundle messages) {
        this(messages, 40);
    }

    @Override
    public String getDescription() {
        return "Readability: sentence over " + this.maxWords + " words";
    }

    @Override
    public String getId() {
        return "TOO_LONG_SENTENCE";
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence text) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        String msg = "Sentence is over " + this.maxWords + " words long, consider revising.";
        int numWords = 0;
        int pos = 0;
        if (tokens.length < this.maxWords + 1) {
            return this.toRuleMatchArray(ruleMatches);
        }
        for (AnalyzedTokenReadings aToken : tokens) {
            String token = aToken.getToken();
            pos += token.length();
            if (token.matches("[?!:;,~\u2019-]") || aToken.isSentenceStart() || aToken.isSentenceEnd()) continue;
            ++numWords;
        }
        if (numWords > this.maxWords) {
            RuleMatch ruleMatch = new RuleMatch(this, 0, pos, msg);
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public void reset() {
    }
}

