/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;

public class AnalyzedSentence {
    private final AnalyzedTokenReadings[] tokens;
    private AnalyzedTokenReadings[] nonBlankTokens;
    private Set<String> tokenSet;
    private int[] whPositions;

    public AnalyzedSentence(AnalyzedTokenReadings[] tokens) {
        this.tokens = tokens;
    }

    public AnalyzedSentence(AnalyzedTokenReadings[] tokens, int[] whPositions) {
        this.tokens = tokens;
        this.setWhPositions(whPositions);
        this.getTokensWithoutWhitespace();
    }

    public final AnalyzedTokenReadings[] getTokens() {
        return this.tokens;
    }

    public final AnalyzedTokenReadings[] getTokensWithoutWhitespace() {
        if (this.nonBlankTokens == null) {
            int whCounter = 0;
            int nonWhCounter = 0;
            int[] mapping = new int[this.tokens.length + 1];
            ArrayList<AnalyzedTokenReadings> l = new ArrayList<AnalyzedTokenReadings>();
            for (AnalyzedTokenReadings token : this.tokens) {
                if (!token.isWhitespace() || token.isSentenceStart() || token.isSentenceEnd() || token.isParagraphEnd()) {
                    l.add(token);
                    mapping[nonWhCounter] = whCounter;
                    ++nonWhCounter;
                }
                ++whCounter;
            }
            this.setNonBlankTokens(l.toArray(new AnalyzedTokenReadings[l.size()]));
            this.setWhPositions((int[])mapping.clone());
        }
        return (AnalyzedTokenReadings[])this.nonBlankTokens.clone();
    }

    public final int getOriginalPosition(int nonWhPosition) {
        if (this.nonBlankTokens == null) {
            this.getTokensWithoutWhitespace();
        }
        return this.getWhPositions()[nonWhPosition];
    }

    public final String toString() {
        return this.toString(",");
    }

    public final String toShortString(String readingDelimiter) {
        return this.toString(readingDelimiter, false);
    }

    public final String toString(String readingDelimiter) {
        return this.toString(readingDelimiter, true);
    }

    private String toString(String readingDelimiter, boolean includeChunks) {
        StringBuilder sb = new StringBuilder();
        for (AnalyzedTokenReadings element : this.tokens) {
            if (!element.isWhitespace()) {
                sb.append(element.getToken());
                sb.append('[');
            }
            Iterator<AnalyzedToken> iterator = element.iterator();
            while (iterator.hasNext()) {
                AnalyzedToken token = iterator.next();
                String posTag = token.getPOSTag();
                if (element.isSentenceStart()) {
                    sb.append("<S>");
                    continue;
                }
                if ("SENT_END".equals(token.getPOSTag())) {
                    sb.append("</S>");
                    continue;
                }
                if ("PARA_END".equals(token.getPOSTag())) {
                    sb.append("<P/>");
                    continue;
                }
                if (posTag == null && !includeChunks) {
                    sb.append(token.getToken());
                    continue;
                }
                if (element.isWhitespace()) continue;
                sb.append(token.toString());
                if (!iterator.hasNext()) continue;
                sb.append(readingDelimiter);
            }
            if (!element.isWhitespace()) {
                if (includeChunks) {
                    sb.append(",");
                    sb.append(StringUtils.join(element.getChunkTags(), (String)"|"));
                }
                sb.append(']');
                continue;
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    public final String getAnnotations() {
        StringBuilder sb = new StringBuilder();
        sb.append("Disambiguator log: \n");
        for (AnalyzedTokenReadings element : this.tokens) {
            if (element.isWhitespace() || "".equals(element.getHistoricalAnnotations())) continue;
            sb.append(element.getHistoricalAnnotations());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setWhPositions(int[] whPositions) {
        this.whPositions = whPositions;
    }

    public int[] getWhPositions() {
        return this.whPositions;
    }

    public void setNonBlankTokens(AnalyzedTokenReadings[] nonBlankTokens) {
        this.nonBlankTokens = nonBlankTokens;
    }

    public synchronized Set<String> getTokenSet() {
        if (this.tokenSet == null) {
            this.tokenSet = new HashSet<String>();
            for (AnalyzedTokenReadings token : this.tokens) {
                this.tokenSet.add(token.getToken().toLowerCase());
            }
        }
        return this.tokenSet;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalyzedSentence other = (AnalyzedSentence)obj;
        if (!Arrays.equals(this.nonBlankTokens, other.nonBlankTokens)) {
            return false;
        }
        if (!Arrays.equals(this.tokens, other.tokens)) {
            return false;
        }
        return Arrays.equals(this.whPositions, other.whPositions);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.nonBlankTokens);
        result = 31 * result + Arrays.hashCode(this.tokens);
        result = 31 * result + Arrays.hashCode(this.whPositions);
        return result;
    }
}

