/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.bitext.BitextReader;
import org.languagetool.bitext.StringPair;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.bitext.BitextRule;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.bitext.BitextPatternRule;
import org.languagetool.rules.patterns.bitext.BitextPatternRuleLoader;
import org.languagetool.rules.patterns.bitext.FalseFriendsAsBitextLoader;
import org.languagetool.tools.StringTools;
import org.xml.sax.SAXException;

public final class Tools {
    private static final int DEFAULT_CONTEXT_SIZE = 45;

    private Tools() {
    }

    public static void tagText(String contents, JLanguageTool lt) throws IOException {
        List<String> sentences = lt.sentenceTokenize(contents);
        for (String sentence : sentences) {
            AnalyzedSentence analyzedText = lt.getAnalyzedSentence(sentence);
            System.out.println(analyzedText.toString());
        }
    }

    public static int checkText(String contents, JLanguageTool lt) throws IOException {
        return Tools.checkText(contents, lt, false, -1, 0, 0, StringTools.XmlPrintMode.NORMAL_XML);
    }

    public static int checkText(String contents, JLanguageTool lt, int lineOffset) throws IOException {
        return Tools.checkText(contents, lt, false, -1, lineOffset, 0, StringTools.XmlPrintMode.NORMAL_XML);
    }

    public static int checkText(String contents, JLanguageTool lt, boolean apiFormat, int lineOffset) throws IOException {
        return Tools.checkText(contents, lt, apiFormat, -1, lineOffset, 0, StringTools.XmlPrintMode.NORMAL_XML);
    }

    public static int checkText(String contents, JLanguageTool lt, boolean apiFormat, int contextSize, int lineOffset, int prevMatches, StringTools.XmlPrintMode xmlMode) throws IOException {
        if (contextSize == -1) {
            contextSize = 45;
        }
        long startTime = System.currentTimeMillis();
        List<RuleMatch> ruleMatches = lt.check(contents);
        for (RuleMatch r : ruleMatches) {
            r.setLine(r.getLine() + lineOffset);
            r.setEndLine(r.getEndLine() + lineOffset);
        }
        if (apiFormat) {
            String xml = StringTools.ruleMatchesToXML(ruleMatches, contents, contextSize, xmlMode);
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            out.print(xml);
        } else {
            Tools.printMatches(ruleMatches, prevMatches, contents, contextSize);
        }
        if (xmlMode == StringTools.XmlPrintMode.NORMAL_XML) {
            Tools.displayTimeStats(startTime, lt.getSentenceCount(), apiFormat);
        }
        return ruleMatches.size();
    }

    private static void displayTimeStats(long startTime, long sentCount, boolean apiFormat) {
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        float timeInSeconds = (float)time / 1000.0f;
        float sentencesPerSecond = (float)sentCount / timeInSeconds;
        if (apiFormat) {
            System.out.println("<!--");
        }
        System.out.printf(Locale.ENGLISH, "Time: %dms for %d sentences (%.1f sentences/sec)", time, sentCount, Float.valueOf(sentencesPerSecond));
        System.out.println();
        if (apiFormat) {
            System.out.println("-->");
        }
    }

    private static void printMatches(List<RuleMatch> ruleMatches, int prevMatches, String contents, int contextSize) {
        int i = 1;
        for (RuleMatch match : ruleMatches) {
            String output = i + prevMatches + ".) Line " + (match.getLine() + 1) + ", column " + match.getColumn() + ", Rule ID: " + match.getRule().getId();
            if (match.getRule() instanceof PatternRule) {
                PatternRule pRule = (PatternRule)match.getRule();
                output = output + "[" + pRule.getSubId() + "]";
            }
            System.out.println(output);
            String msg = match.getMessage();
            msg = msg.replaceAll("<suggestion>", "'");
            msg = msg.replaceAll("</suggestion>", "'");
            System.out.println("Message: " + msg);
            List<String> replacements = match.getSuggestedReplacements();
            if (!replacements.isEmpty()) {
                System.out.println("Suggestion: " + StringTools.listToString(replacements, "; "));
            }
            System.out.println(StringTools.getContext(match.getFromPos(), match.getToPos(), contents, contextSize));
            if (match.getRule().getUrl() != null) {
                System.out.println("More info: " + match.getRule().getUrl().toString());
            }
            if (i < ruleMatches.size()) {
                System.out.println();
            }
            ++i;
        }
    }

    public static int checkBitext(String src, String trg, JLanguageTool srcLt, JLanguageTool trgLt, List<BitextRule> bRules, boolean apiFormat, StringTools.XmlPrintMode xmlMode) throws IOException {
        long startTime = System.currentTimeMillis();
        int contextSize = 45;
        List<RuleMatch> ruleMatches = Tools.checkBitext(src, trg, srcLt, trgLt, bRules);
        for (RuleMatch thisMatch : ruleMatches) {
            thisMatch = trgLt.adjustRuleMatchPos(thisMatch, 0, 1, 1, trg);
        }
        if (apiFormat) {
            String xml = StringTools.ruleMatchesToXML(ruleMatches, trg, 45, xmlMode);
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            out.print(xml);
        } else {
            Tools.printMatches(ruleMatches, 0, trg, 45);
        }
        if (xmlMode == StringTools.XmlPrintMode.NORMAL_XML) {
            Tools.displayTimeStats(startTime, srcLt.getSentenceCount(), apiFormat);
        }
        return ruleMatches.size();
    }

    public static int checkBitext(BitextReader reader, JLanguageTool srcLt, JLanguageTool trgLt, List<BitextRule> bRules, boolean apiFormat) throws IOException {
        long startTime = System.currentTimeMillis();
        int contextSize = 45;
        StringTools.XmlPrintMode xmlMode = StringTools.XmlPrintMode.START_XML;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int matchCount = 0;
        int sentCount = 0;
        for (StringPair srcAndTrg : reader) {
            List<RuleMatch> curMatches = Tools.checkBitext(srcAndTrg.getSource(), srcAndTrg.getTarget(), srcLt, trgLt, bRules);
            ArrayList<RuleMatch> fixedMatches = new ArrayList<RuleMatch>();
            for (RuleMatch thisMatch : curMatches) {
                fixedMatches.add(trgLt.adjustRuleMatchPos(thisMatch, reader.getSentencePosition(), reader.getColumnCount(), reader.getLineCount(), reader.getCurrentLine()));
            }
            ruleMatches.addAll(fixedMatches);
            if (fixedMatches.size() > 0) {
                if (apiFormat) {
                    String xml = StringTools.ruleMatchesToXML(fixedMatches, reader.getCurrentLine(), 45, xmlMode);
                    if (xmlMode == StringTools.XmlPrintMode.START_XML) {
                        xmlMode = StringTools.XmlPrintMode.CONTINUE_XML;
                    }
                    PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
                    out.print(xml);
                } else {
                    Tools.printMatches(fixedMatches, matchCount, reader.getCurrentLine(), 45);
                    matchCount += fixedMatches.size();
                }
            }
            ++sentCount;
        }
        Tools.displayTimeStats(startTime, sentCount, apiFormat);
        if (apiFormat) {
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            out.print("</matches>");
        }
        return ruleMatches.size();
    }

    public static List<RuleMatch> checkBitext(String src, String trg, JLanguageTool srcLt, JLanguageTool trgLt, List<BitextRule> bRules) throws IOException {
        AnalyzedSentence srcText = srcLt.getAnalyzedSentence(src);
        AnalyzedSentence trgText = trgLt.getAnalyzedSentence(trg);
        List<RuleMatch> ruleMatches = trgLt.checkAnalyzedSentence(JLanguageTool.ParagraphHandling.NORMAL, trgLt.getAllRules(), 0, 0, 1, trg, trgText);
        for (BitextRule bRule : bRules) {
            RuleMatch[] curMatch = bRule.match(srcText, trgText);
            if (curMatch == null) continue;
            ruleMatches.addAll(Arrays.asList(curMatch));
        }
        return ruleMatches;
    }

    public static List<BitextRule> getBitextRules(Language source, Language target) throws IOException, ParserConfigurationException, SAXException {
        ArrayList<BitextRule> bRules = new ArrayList<BitextRule>();
        BitextPatternRuleLoader ruleLoader = new BitextPatternRuleLoader();
        String name = "/" + target.getShortName() + "/bitext.xml";
        InputStream is = JLanguageTool.getDataBroker().getFromRulesDirAsStream(name);
        if (is != null) {
            bRules.addAll(ruleLoader.getRules(is, name));
        }
        FalseFriendsAsBitextLoader fRuleLoader = new FalseFriendsAsBitextLoader();
        String falseFriendsFile = "/false-friends.xml";
        List<BitextPatternRule> rules = fRuleLoader.getFalseFriendsAsBitext("/false-friends.xml", source, target);
        bRules.addAll(rules);
        bRules.addAll(Tools.getAllBuiltinBitextRules(source, null));
        return bRules;
    }

    private static List<BitextRule> getAllBuiltinBitextRules(Language language, ResourceBundle messages) {
        ArrayList<BitextRule> rules = new ArrayList<BitextRule>();
        try {
            List<Class<? extends BitextRule>> classes = BitextRule.getRelevantRules();
            Iterator<Class<? extends BitextRule>> i$ = classes.iterator();
            while (i$.hasNext()) {
                int i$2 = 0;
                Class<? extends BitextRule> class1 = i$.next();
                Constructor<?>[] constructors = class1.getConstructors();
                Constructor<?>[] arr$ = constructors;
                int len$ = arr$.length;
                if (i$2 >= len$) continue;
                Constructor<?> constructor = arr$[i$2];
                Class<?>[] paramTypes = constructor.getParameterTypes();
                if (paramTypes.length == 0) {
                    rules.add((BitextRule)constructor.newInstance(new Object[0]));
                    continue;
                }
                if (paramTypes.length == 1 && paramTypes[0].equals(ResourceBundle.class)) {
                    rules.add((BitextRule)constructor.newInstance(messages));
                    continue;
                }
                if (paramTypes.length == 2 && paramTypes[0].equals(ResourceBundle.class) && paramTypes[1].equals(Language.class)) {
                    rules.add((BitextRule)constructor.newInstance(messages, language));
                    continue;
                }
                throw new RuntimeException("Unknown constructor for rule class: " + class1.getName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load rules: " + e.getMessage(), e);
        }
        return rules;
    }

    public static void profileRulesOnText(String contents, JLanguageTool lt) throws IOException {
        long[] workTime = new long[10];
        List<Rule> rules = lt.getAllActiveRules();
        int ruleCount = rules.size();
        System.out.printf("Testing %d rules\n", ruleCount);
        System.out.println("Rule ID\tTime\tSentences\tMatches\tSentences per sec.");
        List<String> sentences = lt.sentenceTokenize(contents);
        for (Rule rule : rules) {
            int matchCount = 0;
            for (int k = 0; k < 10; ++k) {
                long startTime = System.currentTimeMillis();
                for (String sentence : sentences) {
                    matchCount += rule.match(lt.getAnalyzedSentence(sentence)).length;
                }
                long endTime = System.currentTimeMillis();
                workTime[k] = endTime - startTime;
            }
            long time = Tools.median(workTime);
            float timeInSeconds = (float)time / 1000.0f;
            float sentencesPerSecond = (float)sentences.size() / timeInSeconds;
            System.out.printf(Locale.ENGLISH, "%s\t%d\t%d\t%d\t%.1f", rule.getId(), time, sentences.size(), matchCount, Float.valueOf(sentencesPerSecond));
            System.out.println();
        }
    }

    private static long median(long[] m) {
        Arrays.sort(m);
        int middle = m.length / 2;
        if (m.length % 2 == 1) {
            return m[middle];
        }
        return (m[middle - 1] + m[middle]) / 2L;
    }

    public static int profileRulesOnLine(String contents, JLanguageTool lt, Rule rule) throws IOException {
        int count = 0;
        for (String sentence : lt.sentenceTokenize(contents)) {
            count += rule.match(lt.getAnalyzedSentence(sentence)).length;
        }
        return count;
    }

    public static String correctText(String contents, JLanguageTool lt) throws IOException {
        List<RuleMatch> ruleMatches = lt.check(contents);
        if (ruleMatches.isEmpty()) {
            return contents;
        }
        return Tools.correctTextFromMatches(contents, ruleMatches);
    }

    public static void correctBitext(BitextReader reader, JLanguageTool sourceLt, JLanguageTool targetLt, List<BitextRule> bRules) throws IOException {
        for (StringPair srcAndTrg : reader) {
            List<RuleMatch> curMatches = Tools.checkBitext(srcAndTrg.getSource(), srcAndTrg.getTarget(), sourceLt, targetLt, bRules);
            ArrayList<RuleMatch> fixedMatches = new ArrayList<RuleMatch>();
            for (RuleMatch thisMatch : curMatches) {
                fixedMatches.add(targetLt.adjustRuleMatchPos(thisMatch, 0, reader.getTargetColumnCount(), reader.getLineCount(), reader.getCurrentLine()));
            }
            if (fixedMatches.size() > 0) {
                System.out.println(Tools.correctTextFromMatches(srcAndTrg.getTarget(), fixedMatches));
                continue;
            }
            System.out.println(srcAndTrg.getTarget());
        }
    }

    private static String correctTextFromMatches(String contents, List<RuleMatch> matches) {
        StringBuilder sb = new StringBuilder(contents);
        ArrayList<String> errors = new ArrayList<String>();
        for (RuleMatch rm : matches) {
            List<String> replacements = rm.getSuggestedReplacements();
            if (replacements.isEmpty()) continue;
            errors.add(sb.substring(rm.getFromPos(), rm.getToPos()));
        }
        int offset = 0;
        int counter = 0;
        for (RuleMatch rm : matches) {
            List<String> replacements = rm.getSuggestedReplacements();
            if (replacements.isEmpty()) continue;
            if (((String)errors.get(counter)).equals(sb.substring(rm.getFromPos() - offset, rm.getToPos() - offset))) {
                sb.replace(rm.getFromPos() - offset, rm.getToPos() - offset, replacements.get(0));
                offset += rm.getToPos() - rm.getFromPos() - replacements.get(0).length();
            }
            ++counter;
        }
        return sb.toString();
    }

    public static String getFullStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static InputStream getStream(String filename) throws IOException {
        InputStream is = Tools.class.getResourceAsStream(filename);
        if (is == null) {
            throw new IOException("Could not load file from classpath : " + filename);
        }
        return is;
    }

    public static void selectRules(JLanguageTool lt, String[] disabledRules, String[] enabledRules) {
        Tools.selectRules(lt, disabledRules, enabledRules, true);
    }

    public static void selectRules(JLanguageTool lt, String[] disabledRules, String[] enabledRules, boolean useEnabledOnly) {
        for (String disabledRule : disabledRules) {
            lt.disableRule(disabledRule);
        }
        if (enabledRules.length > 0) {
            HashSet<String> enabledRuleIDs = new HashSet<String>(Arrays.asList(enabledRules));
            for (String ruleName : enabledRuleIDs) {
                lt.enableDefaultOffRule(ruleName);
                lt.enableRule(ruleName);
            }
            if (useEnabledOnly) {
                for (Rule rule : lt.getAllRules()) {
                    if (enabledRuleIDs.contains(rule.getId())) continue;
                    lt.disableRule(rule.getId());
                }
            }
        }
    }
}

