/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.spelling.SpellingCheckRule;

public class SuggestionExtractor {
    private static final Pattern SUGGESTION_PATTERN = Pattern.compile("<suggestion.*?>(.*?)</suggestion>");
    private static final Pattern BACK_REFERENCE_PATTERN = Pattern.compile("\\\\\\d+");

    public List<String> getSuggestionTokens(Rule rule, Language language) {
        ArrayList<String> wordsToBeIgnored = new ArrayList<String>();
        if (rule instanceof PatternRule) {
            PatternRule patternRule = (PatternRule)rule;
            String message = patternRule.getMessage();
            List<String> suggestions = this.getSimpleSuggestions(message);
            List<String> tokens = this.getSuggestionTokens(suggestions, language);
            wordsToBeIgnored.addAll(tokens);
        }
        return wordsToBeIgnored;
    }

    List<String> getSimpleSuggestions(String message) {
        Matcher matcher = SUGGESTION_PATTERN.matcher(message);
        int startPos = 0;
        ArrayList<String> suggestions = new ArrayList<String>();
        while (matcher.find(startPos)) {
            String suggestion = matcher.group(1);
            startPos = matcher.end();
            if (!this.isSimpleSuggestion(suggestion)) continue;
            suggestions.add(suggestion);
        }
        return suggestions;
    }

    private boolean isSimpleSuggestion(String suggestion) {
        if (suggestion.contains("<match")) {
            return false;
        }
        Matcher matcher = BACK_REFERENCE_PATTERN.matcher(suggestion);
        return !matcher.find();
    }

    private List<String> getSuggestionTokens(List<String> suggestions, Language language) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (String suggestion : suggestions) {
            List<String> suggestionTokens = language.getWordTokenizer().tokenize(suggestion);
            for (String suggestionToken : suggestionTokens) {
                if (suggestionToken.trim().isEmpty()) continue;
                tokens.add(suggestionToken);
            }
        }
        return tokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIgnoreTokensForLanguages() throws IOException {
        Map<Language, Set<String>> map = this.getLanguageToIgnoreTokensMapping();
        for (Map.Entry<Language, Set<String>> entry : map.entrySet()) {
            Language language = entry.getKey();
            File langDir = this.getLanguageDir(language);
            File hunspellDir = new File(langDir, "hunspell");
            if (!hunspellDir.exists()) {
                System.out.println("No directory " + hunspellDir + " found, ignoring language " + language);
                continue;
            }
            File ignoreFile = new File(hunspellDir, "ignore.txt");
            Set<String> tokens = entry.getValue();
            FileOutputStream fos = new FileOutputStream(ignoreFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "utf-8");
            try {
                this.writeIntro(writer, language);
                for (String token : tokens) {
                    writer.write(token);
                    writer.write("\n");
                }
            }
            finally {
                writer.close();
                fos.close();
            }
            System.out.println("Wrote " + tokens.size() + " words to " + ignoreFile);
        }
    }

    private void writeIntro(Writer writer, Language language) throws IOException {
        writer.write("# words to be ignored by the spellchecker (auto-generated)\n");
        this.writeArtificialTestCaseItems(writer, language);
    }

    private void writeArtificialTestCaseItems(Writer writer, Language language) throws IOException {
        if (language.getShortName().equals("en-US")) {
            writer.write("anArtificialTestWordForLanguageTool\n");
        } else if (language.getShortName().equals("de-DE")) {
            writer.write("einPseudoWortF\u00fcrLanguageToolTests\n");
        }
    }

    private Map<Language, Set<String>> getLanguageToIgnoreTokensMapping() throws IOException {
        HashMap<Language, Set<String>> langToIgnoreTokens = new HashMap<Language, Set<String>>();
        for (Language lang : Language.REAL_LANGUAGES) {
            HashSet<String> suggestionTokens = new HashSet<String>();
            JLanguageTool languageTool = new JLanguageTool(lang);
            Rule spellcheckRule = this.getSpellcheckRule(languageTool);
            if (spellcheckRule == null) {
                System.out.println("No spellchecker rule found for " + lang);
                continue;
            }
            languageTool.activateDefaultPatternRules();
            List<Rule> rules = languageTool.getAllRules();
            int tokenCount = 0;
            int noErrorCount = 0;
            for (Rule rule : rules) {
                List<String> tokens = this.getSuggestionTokens(rule, lang);
                tokenCount += tokens.size();
                for (String token : tokens) {
                    AnalyzedSentence sentence = languageTool.getAnalyzedSentence(token);
                    RuleMatch[] matches = spellcheckRule.match(sentence);
                    if (matches.length > 0) {
                        suggestionTokens.add(token);
                        continue;
                    }
                    ++noErrorCount;
                }
            }
            System.out.println(lang + ": " + noErrorCount + " out of " + tokenCount + " words ignored because they are known to spellchecker anyway");
            Language noVariantLanguage = lang.getDefaultVariant() == null ? lang : lang.getDefaultVariant();
            Set existingTokens = (Set)langToIgnoreTokens.get(noVariantLanguage);
            if (existingTokens != null) {
                existingTokens.addAll(suggestionTokens);
                continue;
            }
            langToIgnoreTokens.put(noVariantLanguage, suggestionTokens);
        }
        return langToIgnoreTokens;
    }

    private File getLanguageDir(Language language) {
        String langCode = language.getShortName();
        File dir = new File("org/languagetool/resource", langCode);
        if (dir.exists()) {
            return dir;
        }
        return new File(langCode + "/src/main/resources/org/languagetool/resource/", langCode);
    }

    private Rule getSpellcheckRule(JLanguageTool languageTool) {
        List<Rule> allActiveRules = languageTool.getAllActiveRules();
        for (Rule activeRule : allActiveRules) {
            if (!(activeRule instanceof SpellingCheckRule)) continue;
            ((SpellingCheckRule)activeRule).setConsiderIgnoreWords(false);
            return activeRule;
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        if (Language.REAL_LANGUAGES.length < 5) {
            throw new RuntimeException("Found only " + Language.REAL_LANGUAGES.length + " languages in classpath. " + "Please run this class with the classpath of 'languagetool-standalone' to have access to all languages.");
        }
        List<String> dirs = Arrays.asList(new File(".").list());
        if (!dirs.contains("en") || !dirs.contains("de")) {
            throw new RuntimeException("Please set the working directory to 'languagetool-language-modules' when running this class");
        }
        SuggestionExtractor extractor = new SuggestionExtractor();
        extractor.writeIgnoreTokensForLanguages();
    }
}

