/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

public class Match {
    private final String posTag;
    private boolean postagRegexp;
    private final boolean suppressMisspelled;
    private final String regexReplace;
    private final String posTagReplace;
    private final CaseConversion caseConversionType;
    private final IncludeRange includeSkipped;
    private String skippedTokens;
    private boolean staticLemma;
    private final boolean setPos;
    private AnalyzedTokenReadings formattedToken;
    private AnalyzedTokenReadings matchedToken;
    private int tokenRef;
    private Synthesizer synthesizer;
    private Pattern pRegexMatch;
    private Pattern pPosRegexMatch;
    private boolean inMessageOnly;

    public Match(String posTag, String posTagReplace, boolean postagRegexp, String regexMatch, String regexReplace, CaseConversion caseConversionType, boolean setPOS, boolean suppressMisspelled, IncludeRange includeSkipped) {
        this.posTag = posTag;
        this.postagRegexp = postagRegexp;
        this.caseConversionType = caseConversionType;
        if (regexMatch != null) {
            this.pRegexMatch = Pattern.compile(regexMatch);
        }
        if (postagRegexp && posTag != null) {
            this.pPosRegexMatch = Pattern.compile(posTag);
        }
        this.regexReplace = regexReplace;
        this.posTagReplace = posTagReplace;
        this.setPos = setPOS;
        this.includeSkipped = includeSkipped;
        this.suppressMisspelled = suppressMisspelled;
    }

    public final void setToken(AnalyzedTokenReadings token) {
        if (this.staticLemma) {
            this.matchedToken = token;
        } else {
            this.formattedToken = token;
        }
    }

    public final void setToken(AnalyzedTokenReadings[] tokens, int index, int next) {
        this.setToken(tokens[index]);
        if (next > 1 && this.includeSkipped != IncludeRange.NONE) {
            StringBuilder sb = new StringBuilder();
            if (this.includeSkipped == IncludeRange.FOLLOWING) {
                this.formattedToken = null;
            }
            for (int k = index + 1; k < index + next; ++k) {
                if (tokens[k].isWhitespaceBefore() && (k != index + 1 || this.includeSkipped != IncludeRange.FOLLOWING)) {
                    sb.append(' ');
                }
                sb.append(tokens[k].getToken());
            }
            this.skippedTokens = sb.toString();
        } else {
            this.skippedTokens = "";
        }
    }

    public final boolean setsPos() {
        return this.setPos;
    }

    public final boolean posRegExp() {
        return this.postagRegexp;
    }

    public final void setLemmaString(String lemmaString) {
        if (!StringTools.isEmpty(lemmaString)) {
            this.formattedToken = new AnalyzedTokenReadings(new AnalyzedToken(lemmaString, this.posTag, lemmaString), 0);
            this.staticLemma = true;
            this.postagRegexp = true;
            if (this.posTag != null) {
                this.pPosRegexMatch = Pattern.compile(this.posTag);
            }
        }
    }

    public final void setSynthesizer(Synthesizer synth) {
        this.synthesizer = synth;
    }

    public final boolean checksSpelling() {
        return this.suppressMisspelled;
    }

    public final String[] toFinalString(Language lang) throws IOException {
        int i;
        String[] formattedString = new String[1];
        if (this.formattedToken != null) {
            int readingCount = this.formattedToken.getReadingsLength();
            formattedString[0] = this.formattedToken.getToken();
            if (this.pRegexMatch != null) {
                formattedString[0] = this.pRegexMatch.matcher(formattedString[0]).replaceAll(this.regexReplace);
            }
            if (this.posTag != null) {
                TreeSet<String> wordForms;
                if (this.synthesizer == null) {
                    formattedString[0] = this.formattedToken.getToken();
                } else if (this.postagRegexp) {
                    wordForms = new TreeSet<String>();
                    boolean oneForm = false;
                    for (int k = 0; k < readingCount; ++k) {
                        if (this.formattedToken.getAnalyzedToken(k).getLemma() != null) continue;
                        String posUnique = this.formattedToken.getAnalyzedToken(k).getPOSTag();
                        if (posUnique == null) {
                            wordForms.add(this.formattedToken.getToken());
                            oneForm = true;
                            continue;
                        }
                        if ("SENT_START".equals(posUnique) || "SENT_END".equals(posUnique) || "PARA_END".equals(posUnique)) {
                            if (!oneForm) {
                                wordForms.add(this.formattedToken.getToken());
                            }
                            oneForm = true;
                            continue;
                        }
                        oneForm = false;
                    }
                    String targetPosTag = this.getTargetPosTag();
                    if (!oneForm) {
                        for (int i2 = 0; i2 < readingCount; ++i2) {
                            String[] possibleWordForms = this.synthesizer.synthesize(this.formattedToken.getAnalyzedToken(i2), targetPosTag, true);
                            if (possibleWordForms == null) continue;
                            wordForms.addAll(Arrays.asList(possibleWordForms));
                        }
                    }
                    if (wordForms.isEmpty()) {
                        formattedString[0] = this.suppressMisspelled ? "" : "(" + this.formattedToken.getToken() + ")";
                    } else {
                        formattedString = wordForms.toArray(new String[wordForms.size()]);
                    }
                } else {
                    wordForms = new TreeSet();
                    for (i = 0; i < readingCount; ++i) {
                        String[] possibleWordForms = this.synthesizer.synthesize(this.formattedToken.getAnalyzedToken(i), this.posTag);
                        if (possibleWordForms == null) continue;
                        wordForms.addAll(Arrays.asList(possibleWordForms));
                    }
                    formattedString = wordForms.toArray(new String[wordForms.size()]);
                }
            }
        }
        String original = this.staticLemma ? (this.matchedToken != null ? this.matchedToken.getToken() : "") : (this.formattedToken != null ? this.formattedToken.getToken() : "");
        for (int i3 = 0; i3 < formattedString.length; ++i3) {
            formattedString[i3] = this.convertCase(formattedString[i3], original);
        }
        if (this.includeSkipped != IncludeRange.NONE && this.skippedTokens != null && !"".equals(this.skippedTokens)) {
            String[] helper = new String[formattedString.length];
            for (i = 0; i < formattedString.length; ++i) {
                if (formattedString[i] == null) {
                    formattedString[i] = "";
                }
                helper[i] = formattedString[i] + this.skippedTokens;
            }
            formattedString = helper;
        }
        if (this.suppressMisspelled && lang != null) {
            List<String> formattedStringElements = Arrays.asList(formattedString);
            List<AnalyzedTokenReadings> analyzed = lang.getTagger().tag(formattedStringElements);
            for (int i4 = 0; i4 < formattedString.length; ++i4) {
                AnalyzedToken analyzedToken = analyzed.get(i4).getAnalyzedToken(0);
                if (analyzedToken.getLemma() != null || !analyzedToken.hasNoTag()) continue;
                formattedString[i4] = "";
            }
        }
        return formattedString;
    }

    public final String getTargetPosTag() {
        String targetPosTag = this.posTag;
        ArrayList<String> posTags = new ArrayList<String>();
        if (this.staticLemma) {
            int numRead = this.matchedToken.getReadingsLength();
            for (int i = 0; i < numRead; ++i) {
                String tst = this.matchedToken.getAnalyzedToken(i).getPOSTag();
                if (tst == null || !this.pPosRegexMatch.matcher(tst).matches()) continue;
                targetPosTag = this.matchedToken.getAnalyzedToken(i).getPOSTag();
                posTags.add(targetPosTag);
            }
            if (this.pPosRegexMatch != null && this.posTagReplace != null) {
                targetPosTag = this.pPosRegexMatch.matcher(targetPosTag).replaceAll(this.posTagReplace);
            }
        } else {
            int numRead = this.formattedToken.getReadingsLength();
            for (int i = 0; i < numRead; ++i) {
                String tst = this.formattedToken.getAnalyzedToken(i).getPOSTag();
                if (tst == null || !this.pPosRegexMatch.matcher(tst).matches()) continue;
                targetPosTag = this.formattedToken.getAnalyzedToken(i).getPOSTag();
                posTags.add(targetPosTag);
            }
            if (this.pPosRegexMatch != null && this.posTagReplace != null) {
                if (posTags.isEmpty()) {
                    posTags.add(targetPosTag);
                }
                StringBuilder sb = new StringBuilder();
                int posTagLen = posTags.size();
                int l = 0;
                for (String lposTag : posTags) {
                    ++l;
                    lposTag = this.pPosRegexMatch.matcher(lposTag).replaceAll(this.posTagReplace);
                    if (this.setPos) {
                        lposTag = this.synthesizer.getPosTagCorrection(lposTag);
                    }
                    sb.append(lposTag);
                    if (l >= posTagLen) continue;
                    sb.append('|');
                }
                targetPosTag = sb.toString();
            }
        }
        return targetPosTag;
    }

    public final String toTokenString() throws IOException {
        StringBuilder output = new StringBuilder();
        String[] stringToFormat = this.toFinalString(null);
        for (int i = 0; i < stringToFormat.length; ++i) {
            output.append(stringToFormat[i]);
            if (i + 1 >= stringToFormat.length) continue;
            output.append('|');
        }
        return output.toString();
    }

    public final void setTokenRef(int i) {
        this.tokenRef = i;
    }

    public final int getTokenRef() {
        return this.tokenRef;
    }

    private String convertCase(String s, String sample) {
        if (StringTools.isEmpty(s)) {
            return s;
        }
        String token = s;
        switch (this.caseConversionType) {
            case NONE: {
                break;
            }
            case PRESERVE: {
                if (!StringTools.startsWithUppercase(sample)) break;
                if (StringTools.isAllUppercase(sample)) {
                    token = token.toUpperCase();
                    break;
                }
                token = StringTools.uppercaseFirstChar(token);
                break;
            }
            case STARTLOWER: {
                token = token.substring(0, 1).toLowerCase() + token.substring(1);
                break;
            }
            case STARTUPPER: {
                token = token.substring(0, 1).toUpperCase() + token.substring(1);
                break;
            }
            case ALLUPPER: {
                token = token.toUpperCase();
                break;
            }
            case ALLLOWER: {
                token = token.toLowerCase();
                break;
            }
        }
        return token;
    }

    public final boolean convertsCase() {
        return !this.caseConversionType.equals((Object)CaseConversion.NONE);
    }

    public final AnalyzedTokenReadings filterReadings() {
        ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
        if (this.formattedToken != null) {
            if (this.staticLemma) {
                this.matchedToken.leaveReading(new AnalyzedToken(this.matchedToken.getToken(), this.posTag, this.formattedToken.getToken()));
                this.formattedToken = this.matchedToken;
            }
            String token = this.formattedToken.getToken();
            if (this.pRegexMatch != null && this.regexReplace != null) {
                token = this.pRegexMatch.matcher(token).replaceAll(this.regexReplace);
            }
            token = this.convertCase(token, token);
            if (this.posTag != null) {
                int numRead = this.formattedToken.getReadingsLength();
                if (this.postagRegexp) {
                    String targetPosTag = this.posTag;
                    for (int i = 0; i < numRead; ++i) {
                        String tst = this.formattedToken.getAnalyzedToken(i).getPOSTag();
                        if (tst == null || !this.pPosRegexMatch.matcher(tst).matches()) continue;
                        targetPosTag = this.formattedToken.getAnalyzedToken(i).getPOSTag();
                        if (this.posTagReplace != null) {
                            targetPosTag = this.pPosRegexMatch.matcher(targetPosTag).replaceAll(this.posTagReplace);
                        }
                        l.add(new AnalyzedToken(token, targetPosTag, this.formattedToken.getAnalyzedToken(i).getLemma()));
                        ((AnalyzedToken)l.get(l.size() - 1)).setWhitespaceBefore(this.formattedToken.isWhitespaceBefore());
                    }
                    if (l.isEmpty()) {
                        for (AnalyzedToken anaTok : this.getNewToken(numRead, token)) {
                            l.add(anaTok);
                        }
                    }
                } else {
                    for (AnalyzedToken anaTok : this.getNewToken(numRead, token)) {
                        l.add(anaTok);
                    }
                }
                if (this.formattedToken.isSentEnd()) {
                    l.add(new AnalyzedToken(this.formattedToken.getToken(), "SENT_END", this.formattedToken.getAnalyzedToken(0).getLemma()));
                }
                if (this.formattedToken.isParaEnd()) {
                    l.add(new AnalyzedToken(this.formattedToken.getToken(), "PARA_END", this.formattedToken.getAnalyzedToken(0).getLemma()));
                }
            }
        }
        if (l.isEmpty()) {
            return this.formattedToken;
        }
        AnalyzedTokenReadings anTkRead = new AnalyzedTokenReadings(l.toArray(new AnalyzedToken[l.size()]), this.formattedToken.getStartPos());
        anTkRead.setWhitespaceBefore(this.formattedToken.isWhitespaceBefore());
        return anTkRead;
    }

    private AnalyzedToken[] getNewToken(int numRead, String token) {
        ArrayList<AnalyzedToken> list = new ArrayList<AnalyzedToken>();
        String lemma = "";
        for (int j = 0; j < numRead; ++j) {
            if (this.formattedToken.getAnalyzedToken(j).getPOSTag() == null) continue;
            if (this.formattedToken.getAnalyzedToken(j).getPOSTag().equals(this.posTag) && this.formattedToken.getAnalyzedToken(j).getLemma() != null) {
                lemma = this.formattedToken.getAnalyzedToken(j).getLemma();
            }
            if (StringTools.isEmpty(lemma)) {
                lemma = this.formattedToken.getAnalyzedToken(0).getLemma();
            }
            list.add(new AnalyzedToken(token, this.posTag, lemma));
            ((AnalyzedToken)list.get(list.size() - 1)).setWhitespaceBefore(this.formattedToken.isWhitespaceBefore());
        }
        return list.toArray(new AnalyzedToken[list.size()]);
    }

    public void setInMessageOnly(boolean inMessageOnly) {
        this.inMessageOnly = inMessageOnly;
    }

    public boolean isInMessageOnly() {
        return this.inMessageOnly;
    }

    public static enum IncludeRange {
        NONE,
        FOLLOWING,
        ALL;


        public static IncludeRange toRange(String str) {
            try {
                return IncludeRange.valueOf(str);
            }
            catch (Exception ex) {
                return NONE;
            }
        }
    }

    public static enum CaseConversion {
        NONE,
        STARTLOWER,
        STARTUPPER,
        ALLLOWER,
        ALLUPPER,
        PRESERVE;


        public static CaseConversion toCase(String str) {
            try {
                return CaseConversion.valueOf(str);
            }
            catch (Exception ex) {
                return NONE;
            }
        }
    }
}

