/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.language.RuleFilenameException;
import org.languagetool.rules.Rule;

public class LanguageBuilder {
    private LanguageBuilder() {
    }

    public static Language makeAdditionalLanguage(File file) {
        return LanguageBuilder.makeLanguage(file, true);
    }

    private static Language makeLanguage(final File file, final boolean isAdditional) {
        boolean secondPartHasCorrectLength;
        if (file == null) {
            throw new NullPointerException("file argument cannot be null");
        }
        if (!file.getName().endsWith(".xml")) {
            throw new RuleFilenameException(file);
        }
        final String[] parts = file.getName().split("-");
        boolean startsWithRules = parts[0].equals("rules");
        boolean bl = secondPartHasCorrectLength = parts.length == 3 && (parts[1].length() == "en".length() || parts[1].length() == "ast".length() || parts[1].length() == "en_US".length());
        if (!startsWithRules || !secondPartHasCorrectLength) {
            throw new RuleFilenameException(file);
        }
        Language newLanguage = new Language(){

            @Override
            public Locale getLocale() {
                return new Locale(this.getShortName());
            }

            @Override
            public Contributor[] getMaintainers() {
                return null;
            }

            @Override
            public String getShortName() {
                if (parts[1].length() == 2) {
                    return parts[1];
                }
                return parts[1].split("_")[0];
            }

            @Override
            public String[] getCountryVariants() {
                if (parts[1].length() == 2) {
                    return new String[]{""};
                }
                return new String[]{parts[1].split("_")[1]};
            }

            @Override
            public String getName() {
                return parts[2].replace(".xml", "");
            }

            @Override
            public List<Class<? extends Rule>> getRelevantRules() {
                return Collections.emptyList();
            }

            @Override
            public List<String> getRuleFileName() {
                ArrayList<String> ruleFiles = new ArrayList<String>();
                ruleFiles.add(file.getAbsolutePath());
                return ruleFiles;
            }

            @Override
            public boolean isExternal() {
                return isAdditional;
            }
        };
        return newLanguage;
    }
}

