/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.Manifest;
import javax.xml.parsers.ParserConfigurationException;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.ResourceBundleWithFallback;
import org.languagetool.databroker.DefaultResourceDataBroker;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SameRuleGroupFilter;
import org.languagetool.rules.patterns.FalseFriendRuleLoader;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.SuggestionExtractor;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tokenizers.Tokenizer;
import org.xml.sax.SAXException;

public final class JLanguageTool {
    public static final String VERSION = "2.2";
    public static final String BUILD_DATE = JLanguageTool.getBuildDate();
    public static final String PATTERN_FILE = "grammar.xml";
    public static final String FALSE_FRIEND_FILE = "false-friends.xml";
    public static final String SENTENCE_START_TAGNAME = "SENT_START";
    public static final String SENTENCE_END_TAGNAME = "SENT_END";
    public static final String PARAGRAPH_END_TAGNAME = "PARA_END";
    public static final String MESSAGE_BUNDLE = "org.languagetool.MessagesBundle";
    private static ResourceDataBroker dataBroker = new DefaultResourceDataBroker();
    private final List<Rule> builtinRules = new ArrayList<Rule>();
    private final List<Rule> userRules = new ArrayList<Rule>();
    private final Set<String> disabledRules = new HashSet<String>();
    private final Set<String> enabledRules = new HashSet<String>();
    private final Set<String> disabledCategories = new HashSet<String>();
    private Language language;
    private Language motherTongue;
    private Disambiguator disambiguator;
    private Tagger tagger;
    private Tokenizer sentenceTokenizer;
    private Tokenizer wordTokenizer;
    private PrintStream printStream;
    private int sentenceCount;
    private boolean listUnknownWords;
    private Set<String> unknownWords;
    private static List<File> temporaryFiles = new ArrayList<File>();

    private static String getBuildDate() {
        try {
            URL res = JLanguageTool.class.getResource(JLanguageTool.class.getSimpleName() + ".class");
            URLConnection connObj = res.openConnection();
            if (connObj instanceof JarURLConnection) {
                JarURLConnection conn = (JarURLConnection)connObj;
                Manifest manifest = conn.getManifest();
                return manifest.getMainAttributes().getValue("Implementation-Date");
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get build date from JAR", e);
        }
    }

    public JLanguageTool(Language language) throws IOException {
        this(language, null);
    }

    public JLanguageTool(Language language, Language motherTongue) throws IOException {
        Rule[] allBuiltinRules;
        if (language == null) {
            throw new NullPointerException("language cannot be null");
        }
        this.language = language;
        this.motherTongue = motherTongue;
        ResourceBundle messages = JLanguageTool.getMessageBundle(language);
        for (Rule element : allBuiltinRules = this.getAllBuiltinRules(language, messages)) {
            if (!element.supportsLanguage(language)) continue;
            this.builtinRules.add(element);
        }
        this.disambiguator = language.getDisambiguator();
        this.tagger = language.getTagger();
        this.sentenceTokenizer = language.getSentenceTokenizer();
        this.wordTokenizer = language.getWordTokenizer();
    }

    public static synchronized ResourceDataBroker getDataBroker() {
        if (dataBroker == null) {
            dataBroker = new DefaultResourceDataBroker();
        }
        return dataBroker;
    }

    public static synchronized void setDataBroker(ResourceDataBroker broker) {
        dataBroker = broker;
    }

    public void setListUnknownWords(boolean listUnknownWords) {
        this.listUnknownWords = listUnknownWords;
    }

    public static ResourceBundle getMessageBundle() {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(MESSAGE_BUNDLE);
            ResourceBundle fallbackBundle = ResourceBundle.getBundle(MESSAGE_BUNDLE, Locale.ENGLISH);
            return new ResourceBundleWithFallback(bundle, fallbackBundle);
        }
        catch (MissingResourceException e) {
            return ResourceBundle.getBundle(MESSAGE_BUNDLE, Locale.ENGLISH);
        }
    }

    static ResourceBundle getMessageBundle(Language lang) {
        try {
            Language defaultVariant;
            ResourceBundle bundle = ResourceBundle.getBundle(MESSAGE_BUNDLE, lang.getLocaleWithCountry());
            if (!JLanguageTool.isValidBundleFor(lang, bundle) && !JLanguageTool.isValidBundleFor(lang, bundle = ResourceBundle.getBundle(MESSAGE_BUNDLE, lang.getLocale())) && (defaultVariant = lang.getDefaultVariant()) != null && defaultVariant.getCountryVariants().length > 0) {
                Locale locale = new Locale(defaultVariant.getShortName(), defaultVariant.getCountryVariants()[0]);
                bundle = ResourceBundle.getBundle(MESSAGE_BUNDLE, locale);
            }
            ResourceBundle fallbackBundle = ResourceBundle.getBundle(MESSAGE_BUNDLE, Locale.ENGLISH);
            return new ResourceBundleWithFallback(bundle, fallbackBundle);
        }
        catch (MissingResourceException e) {
            return ResourceBundle.getBundle(MESSAGE_BUNDLE, Locale.ENGLISH);
        }
    }

    private static boolean isValidBundleFor(Language lang, ResourceBundle bundle) {
        return lang.getLocale().getLanguage().equals(bundle.getLocale().getLanguage());
    }

    private Rule[] getAllBuiltinRules(Language language, ResourceBundle messages) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        List<Class<? extends Rule>> languageRules = language.getRelevantRules();
        for (Class<? extends Rule> ruleClass : languageRules) {
            Constructor<?>[] constructors = ruleClass.getConstructors();
            try {
                if (constructors.length > 0) {
                    Constructor<?> constructor = constructors[0];
                    Class<?>[] paramTypes = constructor.getParameterTypes();
                    if (paramTypes.length == 1 && paramTypes[0].equals(ResourceBundle.class)) {
                        rules.add((Rule)constructor.newInstance(messages));
                        continue;
                    }
                    if (paramTypes.length == 2 && paramTypes[0].equals(ResourceBundle.class) && paramTypes[1].equals(Language.class)) {
                        rules.add((Rule)constructor.newInstance(messages, language));
                        continue;
                    }
                    throw new RuntimeException("No matching constructor found for rule class: " + ruleClass.getName());
                }
                throw new RuntimeException("No public constructor for rule class: " + ruleClass.getName());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load built-in Java rules for language " + language, e);
            }
        }
        return rules.toArray(new Rule[rules.size()]);
    }

    public void setOutput(PrintStream printStream) {
        this.printStream = printStream;
    }

    public List<PatternRule> loadPatternRules(String filename) throws IOException {
        PatternRuleLoader ruleLoader = new PatternRuleLoader();
        InputStream is = this.getClass().getResourceAsStream(filename);
        if (is == null) {
            return ruleLoader.getRules(new File(filename));
        }
        return ruleLoader.getRules(is, filename);
    }

    public List<PatternRule> loadFalseFriendRules(String filename) throws ParserConfigurationException, SAXException, IOException {
        if (this.motherTongue == null) {
            return new ArrayList<PatternRule>();
        }
        FalseFriendRuleLoader ruleLoader = new FalseFriendRuleLoader();
        return ruleLoader.getRules(this.getClass().getResourceAsStream(filename), this.language, this.motherTongue);
    }

    public void activateDefaultPatternRules() throws IOException {
        ArrayList<PatternRule> patternRules = new ArrayList<PatternRule>();
        for (String patternRuleFileName : this.language.getRuleFileName()) {
            patternRules.addAll(this.loadPatternRules(patternRuleFileName));
        }
        this.userRules.addAll(patternRules);
    }

    public void activateDefaultFalseFriendRules() throws ParserConfigurationException, SAXException, IOException {
        String falseFriendRulesFilename = JLanguageTool.getDataBroker().getRulesDir() + "/" + FALSE_FRIEND_FILE;
        List<PatternRule> patternRules = this.loadFalseFriendRules(falseFriendRulesFilename);
        this.userRules.addAll(patternRules);
    }

    public void addRule(Rule rule) {
        this.userRules.add(rule);
        SuggestionExtractor extractor = new SuggestionExtractor();
        List<String> suggestionTokens = extractor.getSuggestionTokens(rule, this.language);
        List<Rule> allActiveRules = this.getAllActiveRules();
        this.addIgnoreWords(suggestionTokens, allActiveRules);
    }

    private void addIgnoreWords(List<String> suggestionTokens, List<Rule> allActiveRules) {
        for (Rule activeRule : allActiveRules) {
            if (!(activeRule instanceof SpellingCheckRule)) continue;
            ((SpellingCheckRule)activeRule).addIgnoreTokens(suggestionTokens);
        }
    }

    private void setIgnoreWords(List<String> suggestionTokens, List<Rule> allActiveRules) {
        for (Rule activeRule : allActiveRules) {
            if (!(activeRule instanceof SpellingCheckRule)) continue;
            ((SpellingCheckRule)activeRule).resetIgnoreTokens();
            ((SpellingCheckRule)activeRule).addIgnoreTokens(suggestionTokens);
        }
    }

    public void disableRule(String ruleId) {
        this.disabledRules.add(ruleId);
        this.reInitSpellCheckIgnoreWords();
    }

    private void reInitSpellCheckIgnoreWords() {
        List<Rule> allActiveRules = this.getAllActiveRules();
        List<String> ignoreTokens = this.getAllIgnoreWords(allActiveRules);
        this.setIgnoreWords(ignoreTokens, allActiveRules);
    }

    private List<String> getAllIgnoreWords(List<Rule> allActiveRules) {
        ArrayList<String> suggestionTokens = new ArrayList<String>();
        for (Rule activeRule : allActiveRules) {
            if (!(activeRule instanceof PatternRule)) continue;
            SuggestionExtractor extractor = new SuggestionExtractor();
            suggestionTokens.addAll(extractor.getSuggestionTokens(activeRule, this.language));
        }
        return suggestionTokens;
    }

    public void disableCategory(String categoryName) {
        this.disabledCategories.add(categoryName);
        this.reInitSpellCheckIgnoreWords();
    }

    public Language getLanguage() {
        return this.language;
    }

    public Set<String> getDisabledRules() {
        return this.disabledRules;
    }

    public void enableDefaultOffRule(String ruleId) {
        this.enabledRules.add(ruleId);
    }

    public Set<String> getDisabledCategories() {
        return this.disabledCategories;
    }

    public void enableRule(String ruleId) {
        if (this.disabledRules.contains(ruleId)) {
            this.disabledRules.remove(ruleId);
        }
    }

    public List<String> sentenceTokenize(String text) {
        return this.sentenceTokenizer.tokenize(text);
    }

    public List<RuleMatch> check(String text) throws IOException {
        return this.check(text, true, ParagraphHandling.NORMAL);
    }

    public List<RuleMatch> check(String text, boolean tokenizeText, ParagraphHandling paraMode) throws IOException {
        List<String> sentences;
        this.sentenceCount = 0;
        if (tokenizeText) {
            sentences = this.sentenceTokenize(text);
        } else {
            sentences = new ArrayList<String>();
            sentences.add(text);
        }
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        List<Rule> allRules = this.getAllRules();
        this.printIfVerbose(allRules.size() + " rules activated for language " + this.language);
        int charCount = 0;
        int lineCount = 0;
        int columnCount = 1;
        this.unknownWords = new HashSet<String>();
        for (String sentence : sentences) {
            ++this.sentenceCount;
            AnalyzedSentence analyzedSentence = this.getAnalyzedSentence(sentence);
            this.rememberUnknownWords(analyzedSentence);
            if (this.sentenceCount == sentences.size()) {
                AnalyzedTokenReadings[] anTokens = analyzedSentence.getTokens();
                anTokens[anTokens.length - 1].setParaEnd();
                analyzedSentence = new AnalyzedSentence(anTokens);
            }
            this.printIfVerbose(analyzedSentence.toString());
            this.printIfVerbose(analyzedSentence.getAnnotations());
            List<RuleMatch> sentenceMatches = this.checkAnalyzedSentence(paraMode, allRules, charCount, lineCount, columnCount, sentence, analyzedSentence);
            Collections.sort(sentenceMatches);
            ruleMatches.addAll(sentenceMatches);
            charCount += sentence.length();
            lineCount += JLanguageTool.countLineBreaks(sentence);
            int lineBreakPos = sentence.lastIndexOf(10);
            if (lineBreakPos == -1) {
                columnCount += sentence.length();
                continue;
            }
            if (lineBreakPos == 0) {
                columnCount = sentence.length();
                if (this.language.getSentenceTokenizer().singleLineBreaksMarksPara()) continue;
                --columnCount;
                continue;
            }
            columnCount = sentence.length() - lineBreakPos;
        }
        if (!ruleMatches.isEmpty() && !paraMode.equals((Object)ParagraphHandling.ONLYNONPARA)) {
            for (Rule rule : allRules) {
                if (!rule.isParagraphBackTrack() || rule.getMatches() == null) continue;
                List<RuleMatch> rm = rule.getMatches();
                for (RuleMatch r : rm) {
                    if (!rule.isInRemoved(r)) continue;
                    ruleMatches.remove(r);
                }
            }
        }
        return ruleMatches;
    }

    public List<RuleMatch> checkAnalyzedSentence(ParagraphHandling paraMode, List<Rule> allRules, int tokenCount, int lineCount, int columnCount, String sentence, AnalyzedSentence analyzedSentence) throws IOException {
        ArrayList<RuleMatch> sentenceMatches = new ArrayList<RuleMatch>();
        block4: for (Rule rule : allRules) {
            RuleMatch[] thisMatches;
            Category category;
            if (this.disabledRules.contains(rule.getId()) || rule.isDefaultOff() && !this.enabledRules.contains(rule.getId()) || (category = rule.getCategory()) != null && this.disabledCategories.contains(category.getName())) continue;
            switch (paraMode) {
                case ONLYNONPARA: {
                    if (!rule.isParagraphBackTrack()) break;
                    continue block4;
                }
                case ONLYPARA: {
                    if (rule.isParagraphBackTrack()) break;
                    continue block4;
                }
            }
            for (RuleMatch element1 : thisMatches = rule.match(analyzedSentence)) {
                RuleMatch thisMatch = this.adjustRuleMatchPos(element1, tokenCount, columnCount, lineCount, sentence);
                sentenceMatches.add(thisMatch);
                if (!rule.isParagraphBackTrack()) continue;
                rule.addRuleMatch(thisMatch);
            }
        }
        SameRuleGroupFilter filter = new SameRuleGroupFilter();
        return filter.filter(sentenceMatches);
    }

    public RuleMatch adjustRuleMatchPos(RuleMatch match, int sentLen, int columnCount, int lineCount, String sentence) {
        RuleMatch thisMatch = new RuleMatch(match.getRule(), match.getFromPos() + sentLen, match.getToPos() + sentLen, match.getMessage(), match.getShortMessage());
        thisMatch.setSuggestedReplacements(match.getSuggestedReplacements());
        String sentencePartToError = sentence.substring(0, match.getFromPos());
        String sentencePartToEndOfError = sentence.substring(0, match.getToPos());
        int lastLineBreakPos = sentencePartToError.lastIndexOf(10);
        int column = lastLineBreakPos == -1 ? sentencePartToError.length() + columnCount : sentencePartToError.length() - lastLineBreakPos;
        int lastLineBreakPosInError = sentencePartToEndOfError.lastIndexOf(10);
        int endColumn = lastLineBreakPosInError == -1 ? sentencePartToEndOfError.length() + columnCount : sentencePartToEndOfError.length() - lastLineBreakPosInError;
        int lineBreaksToError = JLanguageTool.countLineBreaks(sentencePartToError);
        int lineBreaksToEndOfError = JLanguageTool.countLineBreaks(sentencePartToEndOfError);
        thisMatch.setLine(lineCount + lineBreaksToError);
        thisMatch.setEndLine(lineCount + lineBreaksToEndOfError);
        thisMatch.setColumn(column);
        thisMatch.setEndColumn(endColumn);
        thisMatch.setOffset(match.getFromPos() + sentLen);
        return thisMatch;
    }

    private void rememberUnknownWords(AnalyzedSentence analyzedText) {
        if (this.listUnknownWords) {
            AnalyzedTokenReadings[] atr;
            for (AnalyzedTokenReadings reading : atr = analyzedText.getTokensWithoutWhitespace()) {
                if (!reading.getReadings().toString().contains("null]")) continue;
                this.unknownWords.add(reading.getToken());
            }
        }
    }

    public List<String> getUnknownWords() {
        if (!this.listUnknownWords) {
            throw new IllegalStateException("listUnknownWords is set to false, unknown words not stored");
        }
        ArrayList<String> words = new ArrayList<String>(this.unknownWords);
        Collections.sort(words);
        return words;
    }

    static int countLineBreaks(String s) {
        int nextPos;
        int pos = -1;
        int count = 0;
        while ((nextPos = s.indexOf(10, pos + 1)) != -1) {
            pos = nextPos;
            ++count;
        }
        return count;
    }

    public AnalyzedSentence getAnalyzedSentence(String sentence) throws IOException {
        return this.disambiguator.disambiguate(this.getRawAnalyzedSentence(sentence));
    }

    public AnalyzedSentence getRawAnalyzedSentence(String sentence) throws IOException {
        AnalyzedToken sentenceStartToken;
        List<String> tokens = this.wordTokenizer.tokenize(sentence);
        HashMap<Integer, String> softHyphenTokens = new HashMap<Integer, String>();
        for (int i = 0; i < tokens.size(); ++i) {
            if (tokens.get(i).indexOf(173) == -1) continue;
            softHyphenTokens.put(i, tokens.get(i));
            tokens.set(i, tokens.get(i).replaceAll("\u00ad", ""));
        }
        List<AnalyzedTokenReadings> aTokens = this.tagger.tag(tokens);
        int numTokens = aTokens.size();
        int posFix = 0;
        for (int i = 1; i < numTokens; ++i) {
            aTokens.get(i).setWhitespaceBefore(aTokens.get(i - 1).isWhitespace());
            aTokens.get(i).setStartPos(aTokens.get(i).getStartPos() + posFix);
            if (softHyphenTokens.isEmpty() || softHyphenTokens.get(i) == null) continue;
            aTokens.get(i).addReading(this.tagger.createToken((String)softHyphenTokens.get(i), null));
            posFix += ((String)softHyphenTokens.get(i)).length() - aTokens.get(i).getToken().length();
        }
        AnalyzedTokenReadings[] tokenArray = new AnalyzedTokenReadings[tokens.size() + 1];
        AnalyzedToken[] startTokenArray = new AnalyzedToken[1];
        int toArrayCount = 0;
        startTokenArray[0] = sentenceStartToken = new AnalyzedToken("", SENTENCE_START_TAGNAME, null);
        tokenArray[toArrayCount++] = new AnalyzedTokenReadings(startTokenArray, 0);
        int startPos = 0;
        for (AnalyzedTokenReadings posTag : aTokens) {
            posTag.setStartPos(startPos);
            tokenArray[toArrayCount++] = posTag;
            startPos += posTag.getToken().length();
        }
        int lastToken = toArrayCount - 1;
        for (int i = 0; i < toArrayCount - 1; ++i) {
            if (tokenArray[lastToken - i].isWhitespace()) continue;
            lastToken -= i;
            break;
        }
        tokenArray[lastToken].setSentEnd();
        if (tokenArray.length == lastToken + 1 && tokenArray[lastToken].isLinebreak()) {
            tokenArray[lastToken].setParaEnd();
        }
        return new AnalyzedSentence(tokenArray);
    }

    public List<Rule> getAllRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.addAll(this.builtinRules);
        rules.addAll(this.userRules);
        for (Rule rule : rules) {
            rule.reset();
        }
        return rules;
    }

    public List<Rule> getAllActiveRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<Rule> rulesActive = new ArrayList<Rule>();
        rules.addAll(this.builtinRules);
        rules.addAll(this.userRules);
        for (Rule rule : rules) {
            rule.reset();
            if (this.disabledRules.contains(rule.getId())) continue;
            rulesActive.add(rule);
        }
        return rulesActive;
    }

    public int getSentenceCount() {
        return this.sentenceCount;
    }

    private void printIfVerbose(String s) {
        if (this.printStream != null) {
            this.printStream.println(s);
        }
    }

    public static void addTemporaryFile(File file) {
        temporaryFiles.add(file);
    }

    public static void removeTemporaryFiles() {
        for (File file : temporaryFiles) {
            file.delete();
        }
    }

    public static enum ParagraphHandling {
        NORMAL,
        ONLYPARA,
        ONLYNONPARA;

    }
}

