/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.commandline;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tika.language.LanguageIdentifier;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.bitext.BitextReader;
import org.languagetool.bitext.TabBitextReader;
import org.languagetool.commandline.CommandLineOptions;
import org.languagetool.commandline.CommandLineParser;
import org.languagetool.commandline.UnknownParameterException;
import org.languagetool.commandline.WrongParameterNumberException;
import org.languagetool.language.English;
import org.languagetool.rules.Rule;
import org.languagetool.rules.bitext.BitextRule;
import org.languagetool.tools.JnaTools;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;
import org.xml.sax.SAXException;

class Main {
    private static final int MAX_FILE_SIZE = 64000;
    private final boolean verbose;
    private final boolean apiFormat;
    private final boolean taggerOnly;
    private final boolean applySuggestions;
    private final boolean autoDetect;
    private final boolean singleLineBreakMarksParagraph;
    private final String[] enabledRules;
    private final String[] disabledRules;
    private final Language motherTongue;
    private JLanguageTool lt;
    private boolean profileRules;
    private boolean bitextMode;
    private JLanguageTool srcLt;
    private List<BitextRule> bRules;
    private Rule currentRule;

    Main(boolean verbose, boolean taggerOnly, Language language, Language motherTongue, String[] disabledRules, String[] enabledRules, boolean apiFormat, boolean applySuggestions, boolean autoDetect, boolean singleLineBreakMarksParagraph) throws IOException, SAXException, ParserConfigurationException {
        this.verbose = verbose;
        this.apiFormat = apiFormat;
        this.taggerOnly = taggerOnly;
        this.applySuggestions = applySuggestions;
        this.autoDetect = autoDetect;
        this.enabledRules = enabledRules;
        this.disabledRules = disabledRules;
        this.motherTongue = motherTongue;
        this.singleLineBreakMarksParagraph = singleLineBreakMarksParagraph;
        this.profileRules = false;
        this.bitextMode = false;
        this.srcLt = null;
        this.bRules = null;
        this.lt = new JLanguageTool(language, motherTongue);
        this.lt.activateDefaultPatternRules();
        this.lt.activateDefaultFalseFriendRules();
        Tools.selectRules((JLanguageTool)this.lt, (String[])disabledRules, (String[])enabledRules);
    }

    JLanguageTool getJLanguageTool() {
        return this.lt;
    }

    private void setListUnknownWords(boolean listUnknownWords) {
        this.lt.setListUnknownWords(listUnknownWords);
    }

    private void cleanUp() {
        JLanguageTool.removeTemporaryFiles();
    }

    private void setProfilingMode() {
        this.profileRules = true;
    }

    private void setBitextMode(Language sourceLang, String[] disabledRules, String[] enabledRules) throws IOException, ParserConfigurationException, SAXException {
        this.bitextMode = true;
        Language target = this.lt.getLanguage();
        this.lt = new JLanguageTool(target, null);
        this.srcLt = new JLanguageTool(sourceLang);
        this.lt.activateDefaultPatternRules();
        Tools.selectRules((JLanguageTool)this.lt, (String[])disabledRules, (String[])enabledRules);
        Tools.selectRules((JLanguageTool)this.srcLt, (String[])disabledRules, (String[])enabledRules);
        this.bRules = Tools.getBitextRules((Language)sourceLang, (Language)this.lt.getLanguage());
        ArrayList<Object> bRuleList = new ArrayList<BitextRule>(this.bRules);
        for (BitextRule bitextRule : this.bRules) {
            for (String disabledRule : disabledRules) {
                if (!bitextRule.getId().equals(disabledRule)) continue;
                bRuleList.remove(bitextRule);
            }
        }
        this.bRules = bRuleList;
        if (enabledRules.length > 0) {
            bRuleList = new ArrayList();
            for (String enabledRule : enabledRules) {
                for (BitextRule bitextRule : this.bRules) {
                    if (!bitextRule.getId().equals(enabledRule)) continue;
                    bRuleList.add(bitextRule);
                }
            }
            this.bRules = bRuleList;
        }
    }

    private void runOnFile(String filename, String encoding, boolean listUnknownWords, boolean xmlFiltering) throws IOException {
        boolean oneTime = false;
        if (!"-".equals(filename)) {
            File file;
            if (this.autoDetect) {
                Language language = Main.detectLanguageOfFile(filename, encoding);
                if (language == null) {
                    System.err.println("Could not detect language well enough, using English");
                    language = new English();
                }
                this.changeLanguage(language, this.motherTongue, this.disabledRules, this.enabledRules);
                System.out.println("Using " + language.getName() + " for file " + filename);
            }
            boolean bl = oneTime = (file = new File(filename)).length() < 64000L || this.bitextMode;
        }
        if (oneTime) {
            this.runOnFileInOneGo(filename, encoding, listUnknownWords, xmlFiltering);
        } else {
            this.runOnFileLineByLine(filename, encoding, listUnknownWords);
        }
    }

    private void runOnFileInOneGo(String filename, String encoding, boolean listUnknownWords, boolean xmlFiltering) throws IOException {
        if (this.bitextMode) {
            TabBitextReader reader = new TabBitextReader(filename, encoding);
            if (this.applySuggestions) {
                Tools.correctBitext((BitextReader)reader, (JLanguageTool)this.srcLt, (JLanguageTool)this.lt, this.bRules);
            } else {
                Tools.checkBitext((BitextReader)reader, (JLanguageTool)this.srcLt, (JLanguageTool)this.lt, this.bRules, (boolean)this.apiFormat);
            }
        } else {
            String text = this.getFilteredText(filename, encoding, xmlFiltering);
            if (this.applySuggestions) {
                System.out.print(Tools.correctText((String)text, (JLanguageTool)this.lt));
            } else if (this.profileRules) {
                Tools.profileRulesOnText((String)text, (JLanguageTool)this.lt);
            } else if (!this.taggerOnly) {
                Tools.checkText((String)text, (JLanguageTool)this.lt, (boolean)this.apiFormat, (int)0);
            } else {
                Tools.tagText((String)text, (JLanguageTool)this.lt);
            }
            if (listUnknownWords) {
                System.out.println("Unknown words: " + this.lt.getUnknownWords());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnFileLineByLine(String filename, String encoding, boolean listUnknownWords) throws IOException {
        if (this.verbose) {
            this.lt.setOutput(System.err);
        }
        if (!this.apiFormat && !this.applySuggestions) {
            if ("-".equals(filename)) {
                System.out.println("Working on STDIN...");
            } else {
                System.out.println("Working on " + filename + "...");
            }
        }
        int runCount = 1;
        List rules = this.lt.getAllActiveRules();
        if (this.profileRules) {
            System.out.printf("Testing %d rules\n", rules.size());
            System.out.println("Rule ID\tTime\tSentences\tMatches\tSentences per sec.");
            runCount = rules.size();
        }
        InputStreamReader isr = null;
        BufferedReader br = null;
        int lineOffset = 0;
        int tmpLineOffset = 0;
        ArrayList<String> unknownWords = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (int ruleIndex = 0; !rules.isEmpty() && ruleIndex < runCount; ++ruleIndex) {
            this.currentRule = (Rule)rules.get(ruleIndex);
            int matches = 0;
            long sentences = 0L;
            long startTime = System.currentTimeMillis();
            try {
                String line;
                isr = this.getInputStreamReader(filename, encoding);
                br = new BufferedReader(isr);
                int lineCount = 0;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    if (++lineCount == 1 && this.autoDetect) {
                        Language language = Main.detectLanguageOfString(line);
                        if (language == null) {
                            System.err.println("Could not detect language well enough, using English");
                            language = new English();
                        }
                        System.out.println("Language used is: " + language.getName());
                        language.getSentenceTokenizer().setSingleLineBreaksMarksParagraph(this.singleLineBreakMarksParagraph);
                        this.changeLanguage(language, this.motherTongue, this.disabledRules, this.enabledRules);
                    }
                    sb.append('\n');
                    ++tmpLineOffset;
                    if (this.lt.getLanguage().getSentenceTokenizer().singleLineBreaksMarksPara()) {
                        matches = this.handleLine(matches, lineOffset, sb);
                        sentences += (long)this.lt.getSentenceCount();
                        if (this.profileRules) {
                            sentences += (long)this.lt.sentenceTokenize(sb.toString()).size();
                        }
                        if (listUnknownWords && !this.taggerOnly) {
                            for (String word : this.lt.getUnknownWords()) {
                                if (unknownWords.contains(word)) continue;
                                unknownWords.add(word);
                            }
                        }
                        sb = new StringBuilder();
                        lineOffset = tmpLineOffset;
                        continue;
                    }
                    if (!"".equals(line) && sb.length() < 64000) continue;
                    matches = this.handleLine(matches, lineOffset, sb);
                    sentences += (long)this.lt.getSentenceCount();
                    if (this.profileRules) {
                        sentences += (long)this.lt.sentenceTokenize(sb.toString()).size();
                    }
                    if (listUnknownWords && !this.taggerOnly) {
                        for (String word : this.lt.getUnknownWords()) {
                            if (unknownWords.contains(word)) continue;
                            unknownWords.add(word);
                        }
                    }
                    sb = new StringBuilder();
                    lineOffset = tmpLineOffset;
                }
                continue;
            }
            finally {
                if (sb.length() > 0) {
                    matches = this.handleLine(matches, tmpLineOffset - 1, sb);
                    sentences += (long)this.lt.getSentenceCount();
                    if (this.profileRules) {
                        sentences += (long)this.lt.sentenceTokenize(sb.toString()).size();
                    }
                    if (this.apiFormat && !this.taggerOnly && !this.applySuggestions) {
                        System.out.println("</matches>");
                    }
                    if (listUnknownWords && !this.taggerOnly) {
                        for (String word : this.lt.getUnknownWords()) {
                            if (unknownWords.contains(word)) continue;
                            unknownWords.add(word);
                        }
                    }
                }
                this.printTimingInformation(listUnknownWords, rules, unknownWords, ruleIndex, matches, sentences, startTime);
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
            }
        }
    }

    private InputStreamReader getInputStreamReader(String filename, String encoding) throws UnsupportedEncodingException, FileNotFoundException {
        InputStreamReader isr;
        if (!"-".equals(filename)) {
            File file = new File(filename);
            isr = encoding != null ? new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file.getAbsolutePath())), encoding) : new InputStreamReader(new BufferedInputStream(new FileInputStream(file.getAbsolutePath())));
        } else {
            isr = encoding != null ? new InputStreamReader((InputStream)new BufferedInputStream(System.in), encoding) : new InputStreamReader(new BufferedInputStream(System.in));
        }
        return isr;
    }

    private void printTimingInformation(boolean listUnknownWords, List<Rule> rules, List<String> unknownWords, int ruleIndex, int matches, long sentences, long startTime) {
        if (!this.applySuggestions) {
            long endTime = System.currentTimeMillis();
            long time = endTime - startTime;
            float timeInSeconds = (float)time / 1000.0f;
            float sentencesPerSecond = (float)sentences / timeInSeconds;
            if (this.apiFormat) {
                System.out.println("<!--");
            }
            if (this.profileRules) {
                System.out.printf(Locale.ENGLISH, "%s\t%d\t%d\t%d\t%.1f", rules.get(ruleIndex).getId(), time, sentences, matches, Float.valueOf(sentencesPerSecond));
                System.out.println();
            } else {
                System.out.printf(Locale.ENGLISH, "Time: %dms for %d sentences (%.1f sentences/sec)", time, sentences, Float.valueOf(sentencesPerSecond));
                System.out.println();
            }
            if (listUnknownWords) {
                Collections.sort(unknownWords);
                System.out.println("Unknown words: " + unknownWords);
            }
            if (this.apiFormat) {
                System.out.println("-->");
            }
        }
    }

    private int handleLine(int matchNo, int lineOffset, StringBuilder sb) throws IOException {
        int matches = matchNo;
        if (this.applySuggestions) {
            System.out.print(Tools.correctText((String)StringTools.filterXML((String)sb.toString()), (JLanguageTool)this.lt));
        } else if (this.profileRules) {
            matches += Tools.profileRulesOnLine((String)StringTools.filterXML((String)sb.toString()), (JLanguageTool)this.lt, (Rule)this.currentRule);
        } else if (!this.taggerOnly) {
            matches = matches == 0 ? (matches += Tools.checkText((String)StringTools.filterXML((String)sb.toString()), (JLanguageTool)this.lt, (boolean)this.apiFormat, (int)-1, (int)lineOffset, (int)matches, (StringTools.XmlPrintMode)StringTools.XmlPrintMode.START_XML)) : (matches += Tools.checkText((String)StringTools.filterXML((String)sb.toString()), (JLanguageTool)this.lt, (boolean)this.apiFormat, (int)-1, (int)lineOffset, (int)matches, (StringTools.XmlPrintMode)StringTools.XmlPrintMode.CONTINUE_XML));
        } else {
            Tools.tagText((String)StringTools.filterXML((String)sb.toString()), (JLanguageTool)this.lt);
        }
        return matches;
    }

    private void runRecursive(String filename, String encoding, boolean listUnknown, boolean xmlFiltering) throws IOException, ParserConfigurationException, SAXException {
        File[] files;
        File dir = new File(filename);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir.getAbsolutePath() + " is not a directory, cannot use recursion");
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.runRecursive(file.getAbsolutePath(), encoding, listUnknown, xmlFiltering);
                continue;
            }
            this.runOnFile(file.getAbsolutePath(), encoding, listUnknown, xmlFiltering);
        }
    }

    private String getFilteredText(String filename, String encoding, boolean xmlFiltering) throws IOException {
        if (this.verbose) {
            this.lt.setOutput(System.err);
        }
        if (!this.apiFormat && !this.applySuggestions) {
            System.out.println("Working on " + filename + "...");
        }
        String fileContents = StringTools.readFile((InputStream)new FileInputStream(filename), (String)encoding);
        if (xmlFiltering) {
            return StringTools.filterXML((String)fileContents);
        }
        return fileContents;
    }

    private void changeLanguage(Language language, Language motherTongue, String[] disabledRules, String[] enabledRules) {
        try {
            this.lt = new JLanguageTool(language, motherTongue);
            this.lt.activateDefaultPatternRules();
            this.lt.activateDefaultFalseFriendRules();
            Tools.selectRules((JLanguageTool)this.lt, (String[])disabledRules, (String[])enabledRules);
            if (this.verbose) {
                this.lt.setOutput(System.err);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create LanguageTool instance for language " + language, e);
        }
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        JnaTools.setBugWorkaroundProperty();
        CommandLineParser commandLineParser = new CommandLineParser();
        CommandLineOptions options = null;
        try {
            options = commandLineParser.parseOptions(args);
        }
        catch (WrongParameterNumberException e) {
            commandLineParser.printUsage();
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
        catch (UnknownParameterException e) {
            if (e.getMessage() != null) {
                System.err.println(e.getMessage());
            } else {
                System.err.println(e.toString());
            }
            commandLineParser.printUsage(System.err);
            System.exit(1);
        }
        if (options.isPrintUsage()) {
            commandLineParser.printUsage();
            System.exit(1);
        }
        if (options.isPrintVersion()) {
            System.out.println("LanguageTool version 2.2 (" + JLanguageTool.BUILD_DATE + ")");
            System.exit(0);
        }
        if (options.isPrintLanguages()) {
            Main.printLanguages();
            System.exit(0);
        }
        if (options.getFilename() == null) {
            options.setFilename("-");
        }
        if (options.getLanguage() == null) {
            if (!options.isApiFormat() && !options.isAutoDetect()) {
                System.err.println("No language specified, using English");
            }
            options.setLanguage((Language)new English());
        } else if (!options.isApiFormat() && !options.isApplySuggestions()) {
            System.out.println("Expected text language: " + options.getLanguage().getName());
        }
        options.getLanguage().getSentenceTokenizer().setSingleLineBreaksMarksParagraph(options.isSingleLineBreakMarksParagraph());
        Main prg = new Main(options.isVerbose(), options.isTaggerOnly(), options.getLanguage(), options.getMotherTongue(), options.getDisabledRules(), options.getEnabledRules(), options.isApiFormat(), options.isApplySuggestions(), options.isAutoDetect(), options.isSingleLineBreakMarksParagraph());
        prg.setListUnknownWords(options.isListUnknown());
        if (options.isProfile()) {
            prg.setProfilingMode();
        }
        if (options.isBitext()) {
            if (options.getMotherTongue() == null) {
                throw new IllegalArgumentException("You have to set the source language (as mother tongue) in bitext mode.");
            }
            prg.setBitextMode(options.getMotherTongue(), options.getDisabledRules(), options.getEnabledRules());
        }
        if (options.isRecursive()) {
            prg.runRecursive(options.getFilename(), options.getEncoding(), options.isListUnknown(), options.isXmlFiltering());
        } else {
            prg.runOnFile(options.getFilename(), options.getEncoding(), options.isListUnknown(), options.isXmlFiltering());
        }
        prg.cleanUp();
    }

    private static void printLanguages() {
        ArrayList<String> languages = new ArrayList<String>();
        for (Language language : Language.REAL_LANGUAGES) {
            languages.add(language.getShortNameWithVariant() + " " + language.getName());
        }
        Collections.sort(languages);
        for (String s : languages) {
            System.out.println(s);
        }
    }

    private static Language detectLanguageOfFile(String filename, String encoding) throws IOException {
        String text = StringTools.readFile((InputStream)new FileInputStream(filename), (String)encoding);
        return Main.detectLanguageOfString(text);
    }

    private static Language detectLanguageOfString(String text) {
        LanguageIdentifier identifier = new LanguageIdentifier(text);
        Language lang = Language.getLanguageForShortName((String)identifier.getLanguage());
        return lang;
    }
}

