/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.zh;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.Tagger;

public class ChineseTagger
implements Tagger {
    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        for (String word : sentenceTokens) {
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            AnalyzedToken at = this.asAnalyzedToken(word);
            l.add(at);
            tokenReadings.add(new AnalyzedTokenReadings(l, pos));
            pos += at.getToken().length();
        }
        return tokenReadings;
    }

    public final AnalyzedTokenReadings createNullToken(String token, int startPos) {
        return new AnalyzedTokenReadings(new AnalyzedToken(token, null, null), startPos);
    }

    public AnalyzedToken createToken(String token, String posTag) {
        return new AnalyzedToken(token, posTag, null);
    }

    private AnalyzedToken asAnalyzedToken(String word) {
        if (!word.contains("/")) {
            return new AnalyzedToken(" ", null, null);
        }
        String[] parts = word.split("/");
        if (parts[0].equals("") && parts[parts.length - 1].equals("w")) {
            return new AnalyzedToken(word.substring(0, word.length() - 2), word.substring(word.length() - 1, word.length()), null);
        }
        return new AnalyzedToken(parts[0], parts[1], null);
    }
}

