/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.zh.ChineseConfusionProbabilityRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.zh.ChineseTagger;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.zh.ChineseSentenceTokenizer;
import org.languagetool.tokenizers.zh.ChineseWordTokenizer;

public class Chinese
extends Language
implements AutoCloseable {
    private Tagger tagger;
    private Tokenizer wordTokenizer;
    private SentenceTokenizer sentenceTokenizer;
    private LuceneLanguageModel languageModel;

    public String getShortName() {
        return "zh";
    }

    public String getShortCode() {
        return "zh";
    }

    public String getName() {
        return "Chinese";
    }

    public String[] getCountries() {
        return new String[]{"CN"};
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Tao Lin")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) {
        return Arrays.asList(new DoublePunctuationRule(messages), new MultipleWhitespaceRule(messages, (Language)this));
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new ChineseTagger();
        }
        return this.tagger;
    }

    public Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new ChineseWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new ChineseSentenceTokenizer();
        }
        return this.sentenceTokenizer;
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        if (this.languageModel == null) {
            this.languageModel = new LuceneLanguageModel(new File(indexDir, this.getShortCode()));
        }
        return this.languageModel;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel) throws IOException {
        return Arrays.asList(new Rule[]{new ChineseConfusionProbabilityRule(messages, languageModel, this)});
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }
}

